/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.commodity.mall.atom.api.InterfaceCurrentPriceQryService;
import com.tydic.commodity.mall.atom.api.UccMallCurrentPriceQryAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdPriceBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentPriceQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentPriceQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJdPriceBO;
import com.tydic.commodity.mall.atom.bo.InterfaceNotJdPriceBO;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentPriceQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentPriceQryRspBO;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccMallCurrentPriceQryAtomServiceImpl
implements UccMallCurrentPriceQryAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallCurrentPriceQryAtomServiceImpl.class);
    @Autowired
    private InterfaceCurrentPriceQryService interfaceCurrentPriceQryService;
    @Value(value="#{'${JD_SUPPLIER_ID}'.split(',')}")
    private List<String> JD_SUPPLIER_ID;
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @Override
    public UccMallCurrentPriceQryRspBO qryCommdCurrentPrice(UccMallCurrentPriceQryReqBO reqBO) {
        UccMallCurrentPriceQryRspBO rspBO = new UccMallCurrentPriceQryRspBO();
        try {
            InterfaceCurrentPriceQryReqBO uccCurrentPriceQryReqBO = new InterfaceCurrentPriceQryReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccCurrentPriceQryReqBO);
            InterfaceCurrentPriceQryRspBO uccCurrentPriceQryRspBO = this.interfaceCurrentPriceQryService.qryCommdCurrentPrice(uccCurrentPriceQryReqBO);
            if ("0000".equals(uccCurrentPriceQryRspBO.getResultCode())) {
                InterfaceCommdPriceBO commdPriceBO = new InterfaceCommdPriceBO();
                if (uccCurrentPriceQryRspBO.getResult() != null) {
                    BeanUtils.copyProperties((Object)uccCurrentPriceQryRspBO.getResult(), (Object)commdPriceBO);
                }
                rspBO.setCommdPriceInfo(commdPriceBO);
                rspBO.setFailSkuIdList(this.getEmallSkuIds(uccCurrentPriceQryRspBO.getFailSkuIdList()));
                rspBO.setRespCode(uccCurrentPriceQryRspBO.getResultCode());
                rspBO.setRespDesc(uccCurrentPriceQryRspBO.getResultMessage());
            } else {
                if (!ObjectUtil.isEmpty(uccCurrentPriceQryRspBO.getFailSkuIdList())) {
                    rspBO = this.returnSuccess(rspBO, reqBO.getSkuIds(), false);
                    rspBO.setFailSkuIdList(this.getEmallSkuIds(uccCurrentPriceQryRspBO.getFailSkuIdList()));
                } else {
                    rspBO = this.returnSuccess(rspBO, reqBO.getSkuIds(), true);
                }
                rspBO.setFailError(uccCurrentPriceQryRspBO.getResultMessage());
            }
        }
        catch (BusinessException e) {
            LOGGER.error(e.getMessage());
            rspBO = this.returnSuccess(rspBO, reqBO.getSkuIds(), true);
            rspBO.setFailError(e.getMessage());
        }
        return rspBO;
    }

    private UccMallCurrentPriceQryRspBO returnSuccess(UccMallCurrentPriceQryRspBO rspBO, List<String> skuIds, Boolean mark) {
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        InterfaceCommdPriceBO interfaceCommdPriceBO = new InterfaceCommdPriceBO();
        ArrayList<InterfaceJdPriceBO> jdPriceInfos = new ArrayList<InterfaceJdPriceBO>();
        ArrayList<InterfaceNotJdPriceBO> notJdPriceInfo = new ArrayList<InterfaceNotJdPriceBO>();
        for (String skuId : skuIds) {
            List<UccSkuPricePo> uccSkuPricePoList = this.uccMallSkuPriceMapper.getPricesByExtSkuId(skuId);
            if (ObjectUtil.isEmpty(uccSkuPricePoList)) continue;
            for (UccSkuPricePo uccSkuPricePo : uccSkuPricePoList) {
                if (this.JD_SUPPLIER_ID.contains(String.valueOf(uccSkuPricePo.getSkuId()))) {
                    InterfaceJdPriceBO jdPriceBO = new InterfaceJdPriceBO();
                    jdPriceBO.setPrice(MoneyUtils.haoToYuan(uccSkuPricePo.getAgreementPrice()));
                    jdPriceBO.setJdPrice(MoneyUtils.haoToYuan(uccSkuPricePo.getAgreementPrice()));
                    jdPriceBO.setSkuId(skuId);
                    jdPriceInfos.add(jdPriceBO);
                    continue;
                }
                InterfaceNotJdPriceBO notJdPriceBO = new InterfaceNotJdPriceBO();
                notJdPriceBO.setEcPrice(MoneyUtils.haoToYuan(uccSkuPricePo.getMarketPrice()));
                notJdPriceBO.setPrice(MoneyUtils.haoToYuan(uccSkuPricePo.getAgreementPrice()));
                notJdPriceBO.setSkuId(skuId);
                notJdPriceInfo.add(notJdPriceBO);
            }
        }
        interfaceCommdPriceBO.setJdPriceInfos(jdPriceInfos);
        interfaceCommdPriceBO.setNotJdPriceInfo(notJdPriceInfo);
        rspBO.setCommdPriceInfo(interfaceCommdPriceBO);
        rspBO.setFailMark(1);
        if (mark.booleanValue()) {
            rspBO.setFailSkuIdList(this.getEmallSkuIds(skuIds));
        }
        return rspBO;
    }

    private List<String> getEmallSkuIds(List<String> failReturnList) {
        List<String> eMallSkuIds = new ArrayList<String>();
        if (ObjectUtil.isEmpty(failReturnList)) {
            return eMallSkuIds;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setFailList(failReturnList);
        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        eMallSkuIds = uccSkuPoList.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getSkuId())).map(o -> String.valueOf(o.getSkuId())).collect(Collectors.toList());
        return eMallSkuIds;
    }
}

