/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.tydic.commodity.mall.ability.bo.UccMallCommdStockBO_busi;
import com.tydic.commodity.mall.atom.api.InterfaceCurrentStockQryService;
import com.tydic.commodity.mall.atom.api.InterfaceJDAddressFromAddressQryService;
import com.tydic.commodity.mall.atom.api.UccMallCurrentStockQryAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceCommdStockBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentStockQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceCurrentStockQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJDAddressFromAddressQryReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceJDAddressFromAddressQryRspBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuNumBO;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallSkuNumBO_Atom;
import com.tydic.commodity.mall.config.CommdProPertiesVo;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.umc.general.ability.api.UmcCrcQryAddressAbilityService;
import com.tydic.umc.general.ability.bo.UmcCrcQryAddressAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcCrcQryAddressAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallCurrentStockQryAtomServiceImpl
implements UccMallCurrentStockQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccMallCurrentStockQryAtomServiceImpl.class);
    @Autowired
    private InterfaceCurrentStockQryService interfaceCurrentStockQryService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallCurrentStockQryAtomServiceImpl.class);
    @Autowired
    private InterfaceJDAddressFromAddressQryService interfaceJDAddressFromAddressQryService;
    @Autowired
    private UmcCrcQryAddressAbilityService umcCrcQryAddressAbilityService;
    @Autowired
    private CommdProPertiesVo commdProPertiesVo;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @Override
    public UccMallCurrentStockQryRspBO qryCommdCurrentStock(UccMallCurrentStockQryReqBO reqBO) {
        UccMallCurrentStockQryRspBO rspBO = new UccMallCurrentStockQryRspBO();
        try {
            String errorMsg = "";
            if (CollectionUtils.isEmpty(reqBO.getSkuNum())) {
                rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
                rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5355\u54c1\u4fe1\u606f");
                return rspBO;
            }
            UmcCrcQryAddressAbilityReqBO umcCrcQryAddressAbilityReqBO = new UmcCrcQryAddressAbilityReqBO();
            umcCrcQryAddressAbilityReqBO.setProvinceCode(reqBO.getProvince());
            umcCrcQryAddressAbilityReqBO.setCityCode(reqBO.getCity());
            umcCrcQryAddressAbilityReqBO.setAreaCode(reqBO.getCounty());
            umcCrcQryAddressAbilityReqBO.setTownsCode(reqBO.getTown());
            UmcCrcQryAddressAbilityRspBO umcCrcQryAddressAbilityRspBO = this.umcCrcQryAddressAbilityService.qryAddress(umcCrcQryAddressAbilityReqBO);
            reqBO.setProvinceName(umcCrcQryAddressAbilityRspBO.getProvinceName());
            reqBO.setCityName(umcCrcQryAddressAbilityRspBO.getCityName());
            reqBO.setCountyName(umcCrcQryAddressAbilityRspBO.getAreaName());
            reqBO.setTownName(umcCrcQryAddressAbilityRspBO.getTownName());
            if ("jd".equals(reqBO.getSupplierCode())) {
                InterfaceJDAddressFromAddressQryReqBO jdAddressFromAddressQryReqBO = new InterfaceJDAddressFromAddressQryReqBO();
                jdAddressFromAddressQryReqBO.setProvinceName(umcCrcQryAddressAbilityRspBO.getProvinceName());
                jdAddressFromAddressQryReqBO.setCityName(umcCrcQryAddressAbilityRspBO.getCityName());
                jdAddressFromAddressQryReqBO.setAreaName(umcCrcQryAddressAbilityRspBO.getAreaName());
                jdAddressFromAddressQryReqBO.setTownName(umcCrcQryAddressAbilityRspBO.getTownName());
                jdAddressFromAddressQryReqBO.setSysTenantId(reqBO.getSysTenantId());
                reqBO.setProvinceName(umcCrcQryAddressAbilityRspBO.getProvinceName());
                reqBO.setCityName(umcCrcQryAddressAbilityRspBO.getCityName());
                reqBO.setCountyName(umcCrcQryAddressAbilityRspBO.getAreaName());
                reqBO.setTownName(umcCrcQryAddressAbilityRspBO.getTownName());
                InterfaceJDAddressFromAddressQryRspBO jdAddressFromAddressQryRspBO = this.interfaceJDAddressFromAddressQryService.getJDAddressFromAddress(jdAddressFromAddressQryReqBO);
                reqBO.setProvince(jdAddressFromAddressQryRspBO.getResult().getProvinceId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getProvinceId().longValue());
                reqBO.setCity(jdAddressFromAddressQryRspBO.getResult().getCityId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getCityId().longValue());
                reqBO.setCounty(jdAddressFromAddressQryRspBO.getResult().getCountyId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getCountyId().longValue());
                reqBO.setTown(jdAddressFromAddressQryRspBO.getResult().getTownId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getTownId().longValue());
            }
            InterfaceCurrentStockQryReqBO uccCurrentStockQryReqBO = new InterfaceCurrentStockQryReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccCurrentStockQryReqBO);
            ArrayList<InterfaceSkuNumBO> skuNums = new ArrayList<InterfaceSkuNumBO>();
            for (UccMallSkuNumBO_Atom each : reqBO.getSkuNum()) {
                InterfaceSkuNumBO bo = new InterfaceSkuNumBO();
                bo.setSkuId(each.getSkuId());
                bo.setNum(each.getNum());
                skuNums.add(bo);
            }
            uccCurrentStockQryReqBO.setSkuNum(skuNums);
            InterfaceCurrentStockQryRspBO uccCurrentStockQryRspBO = null;
            try {
                uccCurrentStockQryRspBO = this.interfaceCurrentStockQryService.qryCommdCurrentStock(uccCurrentStockQryReqBO);
            }
            catch (BusinessException e) {
                errorMsg = e.getMessage();
                rspBO = this.returnSuccess(rspBO, reqBO.getSkuNum(), true);
                rspBO.setFailError(errorMsg);
                return rspBO;
            }
            if (uccCurrentStockQryRspBO == null) {
                LOGGER.error("uccCurrentStockQryService ->{ 67 - null }");
                rspBO = this.returnSuccess(rspBO, reqBO.getSkuNum(), true);
                rspBO.setFailError(errorMsg);
                return rspBO;
            }
            if ("0000".equals(uccCurrentStockQryRspBO.getResultCode())) {
                if (uccCurrentStockQryRspBO.getCommdStockInfo() != null && uccCurrentStockQryRspBO.getCommdStockInfo().size() > 0) {
                    ArrayList<UccMallCommdStockBO_busi> commdStockBOBusis = new ArrayList<UccMallCommdStockBO_busi>();
                    for (InterfaceCommdStockBO commdStockBO : uccCurrentStockQryRspBO.getCommdStockInfo()) {
                        String json = JSONObject.toJSONString((Object)commdStockBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                        UccMallCommdStockBO_busi commdStockBOBusi1 = (UccMallCommdStockBO_busi)JSON.parseObject((String)json, UccMallCommdStockBO_busi.class);
                        BeanUtils.copyProperties((Object)commdStockBO, (Object)commdStockBOBusi1);
                        if (commdStockBOBusi1.getRemainNum().compareTo(new BigDecimal("0")) > 0) {
                            for (UccMallSkuNumBO_Atom uccMallsSkuNumBO_atom : reqBO.getSkuNum()) {
                                if (!commdStockBOBusi1.getSkuId().equals(uccMallsSkuNumBO_atom.getSkuId()) || commdStockBOBusi1.getRemainNum().compareTo(new BigDecimal(uccMallsSkuNumBO_atom.getNum())) >= 0) continue;
                                commdStockBOBusi1.setStockStateId(Integer.valueOf(0));
                            }
                        }
                        commdStockBOBusis.add(commdStockBOBusi1);
                    }
                    rspBO.setCommdStockInfo(commdStockBOBusis);
                }
                uccCurrentStockQryRspBO.getCommdStockInfo();
                rspBO.setFailSkuIdList(this.getEmallSkuIds(uccCurrentStockQryRspBO.getFailSkuIdList()));
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            } else {
                rspBO.setRespCode(uccCurrentStockQryRspBO.getRespCode());
                rspBO.setRespDesc(uccCurrentStockQryRspBO.getResultMessage());
                if (!ObjectUtil.isEmpty(uccCurrentStockQryRspBO.getFailSkuIdList())) {
                    rspBO = this.returnSuccess(rspBO, reqBO.getSkuNum(), false);
                    rspBO.setFailSkuIdList(uccCurrentStockQryRspBO.getFailSkuIdList());
                } else {
                    rspBO = this.returnSuccess(rspBO, reqBO.getSkuNum(), true);
                }
                rspBO.setFailError(uccCurrentStockQryRspBO.getResultMessage());
            }
            return rspBO;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBO = this.returnSuccess(rspBO, reqBO.getSkuNum(), true);
            rspBO.setFailError(e.getMessage());
            return rspBO;
        }
    }

    private UccMallCurrentStockQryRspBO returnSuccess(UccMallCurrentStockQryRspBO rspBO, List<UccMallSkuNumBO_Atom> skuNum, Boolean mark) {
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<UccMallCommdStockBO_busi> commdStockInfo = new ArrayList<UccMallCommdStockBO_busi>();
        ArrayList<String> failSkuIdList = new ArrayList<String>();
        for (UccMallSkuNumBO_Atom uccMallSkuNumBO_atom : skuNum) {
            UccMallCommdStockBO_busi bo = new UccMallCommdStockBO_busi();
            bo.setSkuId(uccMallSkuNumBO_atom.getSkuId());
            bo.setStockStateId(Integer.valueOf(34));
            bo.setStockStateDesc("\u65e0\u8d27");
            commdStockInfo.add(bo);
            failSkuIdList.add(uccMallSkuNumBO_atom.getSkuId());
        }
        if (mark.booleanValue()) {
            rspBO.setFailSkuIdList(this.getEmallSkuIds(failSkuIdList));
        }
        rspBO.setCommdStockInfo(commdStockInfo);
        rspBO.setFailMark(1);
        return rspBO;
    }

    private List<String> getEmallSkuIds(List<String> failReturnList) {
        List<String> eMallSkuIds = new ArrayList<String>();
        if (ObjectUtil.isEmpty(failReturnList)) {
            return eMallSkuIds;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setFailList(failReturnList);
        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        eMallSkuIds = uccSkuPoList.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getSkuId())).map(o -> String.valueOf(o.getSkuId())).collect(Collectors.toList());
        return eMallSkuIds;
    }
}

