/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.commodity.mall.atom.api.InterfaceDeliveryTimeQryService;
import com.tydic.commodity.mall.atom.api.UccMallExpectDeliveryTimeQueryAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceDeliveryTimeQueryReqBo;
import com.tydic.commodity.mall.atom.bo.InterfaceDeliveryTimeQueryRspBo;
import com.tydic.commodity.mall.atom.bo.UccMallExpectDeliveryTimeQueryAtomReqBo;
import com.tydic.commodity.mall.atom.bo.UccMallExpectDeliveryTimeQueryAtomRspBo;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.umc.general.ability.api.UmcCrcQryAddressAbilityService;
import com.tydic.umc.general.ability.bo.UmcCrcQryAddressAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcCrcQryAddressAbilityRspBO;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallExpectDeliveryTimeQueryAtomServiceImpl
implements UccMallExpectDeliveryTimeQueryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccMallExpectDeliveryTimeQueryAtomServiceImpl.class);
    @Autowired
    private InterfaceDeliveryTimeQryService interfaceDeliveryTimeQryService;
    @Autowired
    private UmcCrcQryAddressAbilityService umcCrcQryAddressAbilityService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;

    @Override
    public UccMallExpectDeliveryTimeQueryAtomRspBo getExpectDeliveryTime(UccMallExpectDeliveryTimeQueryAtomReqBo reqBo) {
        UccMallExpectDeliveryTimeQueryAtomRspBo rspBo = new UccMallExpectDeliveryTimeQueryAtomRspBo();
        UmcCrcQryAddressAbilityReqBO umcCrcQryAddressAbilityReqBO = new UmcCrcQryAddressAbilityReqBO();
        umcCrcQryAddressAbilityReqBO.setProvinceCode(Long.valueOf(reqBo.getProvince()));
        umcCrcQryAddressAbilityReqBO.setCityCode(Long.valueOf(reqBo.getCity()));
        umcCrcQryAddressAbilityReqBO.setAreaCode(Long.valueOf(reqBo.getCounty()));
        if (reqBo.getTown() == 0) {
            umcCrcQryAddressAbilityReqBO.setTownsCode(Long.valueOf(0L));
        } else {
            umcCrcQryAddressAbilityReqBO.setTownsCode(Long.valueOf(reqBo.getTown()));
        }
        UmcCrcQryAddressAbilityRspBO umcCrcQryAddressAbilityRspBO = this.umcCrcQryAddressAbilityService.qryAddress(umcCrcQryAddressAbilityReqBO);
        reqBo.setProvinceName(umcCrcQryAddressAbilityRspBO.getProvinceName());
        reqBo.setCityName(umcCrcQryAddressAbilityRspBO.getCityName());
        reqBo.setCountyName(umcCrcQryAddressAbilityRspBO.getAreaName());
        reqBo.setTownName(umcCrcQryAddressAbilityRspBO.getTownName());
        try {
            InterfaceDeliveryTimeQueryReqBo uccExpectDeliveryTimeQueryReqBo = new InterfaceDeliveryTimeQueryReqBo();
            BeanUtils.copyProperties((Object)reqBo, (Object)uccExpectDeliveryTimeQueryReqBo);
            InterfaceDeliveryTimeQueryRspBo uccExpectDeliveryTimeQueryRspBo = this.interfaceDeliveryTimeQryService.getPromiseTips(uccExpectDeliveryTimeQueryReqBo);
            if ("0000".equals(uccExpectDeliveryTimeQueryRspBo.getResultCode())) {
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                rspBo.setFailSkuIdList(uccExpectDeliveryTimeQueryRspBo.getFailSkuIdList());
                rspBo.setResult(uccExpectDeliveryTimeQueryRspBo.getResult());
            } else {
                rspBo = this.returnSuccess(rspBo, reqBo.getSkuId(), reqBo.getSupplierId());
                if (!ObjectUtil.isEmpty(uccExpectDeliveryTimeQueryRspBo.getFailSkuIdList())) {
                    rspBo.setFailSkuIdList(uccExpectDeliveryTimeQueryRspBo.getFailSkuIdList());
                }
                rspBo.setFailError(uccExpectDeliveryTimeQueryRspBo.getResultMessage());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo = this.returnSuccess(rspBo, reqBo.getSkuId(), reqBo.getSupplierId());
            rspBo.setFailError(e.getMessage());
        }
        return rspBo;
    }

    private UccMallExpectDeliveryTimeQueryAtomRspBo returnSuccess(UccMallExpectDeliveryTimeQueryAtomRspBo rspBo, String skuId, Long supplierId) {
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setFailMark(1);
        if (!ObjectUtil.isEmpty((Object)skuId)) {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setExtSkuId(skuId);
            uccSkuPo.setSupplierShopId(supplierId);
            List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo);
            if (!ObjectUtil.isEmpty((Object)uccSkuPos.get(0).getPreDeliverDay())) {
                String preDeliverDay = "\u9884\u8ba1<b>" + uccSkuPos.get(0).getPreDeliverDay() + "\u5929</b>\u9001\u8fbe";
                rspBo.setResult(preDeliverDay);
            }
            rspBo.setFailSkuIdList(Arrays.asList(skuId));
        }
        return rspBo;
    }
}

