/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.tydic.commodity.mall.atom.api.UccMallGoodsInfoCheckAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallGoodsInfoCheckAtomReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallGoodsInfoCheckAtomRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallGoodsInfoCheckAtomServiceImpl
implements UccMallGoodsInfoCheckAtomService {
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallGoodsInfoCheckAtomServiceImpl.class);

    @Override
    public UccMallGoodsInfoCheckAtomRspBO dealUccGoodsInfoCheck(UccMallGoodsInfoCheckAtomReqBO reqBO) {
        UccMallGoodsInfoCheckAtomRspBO rspBO = new UccMallGoodsInfoCheckAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getSkuId() == null) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5355\u54c1ID");
            return rspBO;
        }
        if (reqBO.getSupplierShopId() == null) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5e97\u94faID");
            return rspBO;
        }
        try {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(reqBO.getSkuId());
            uccSkuPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPo.setSysTenantId(reqBO.getSysTenantId());
            List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty(uccSkuPos)) {
                rspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
                rspBO.setRespDesc("\u5355\u54c1\u4e0d\u5b58\u5728");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code(), "\u67e5\u8be2\u5931\u8d25");
        }
        return rspBO;
    }
}

