/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.tydic.commodity.mall.atom.api.UccMallQryPriceFromLadderPriceAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallQryPriceFromLadderPriceBO;
import com.tydic.commodity.mall.atom.bo.UccMallQryPriceFromLadderPriceReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallQryPriceFromLadderPriceRspBO;
import com.tydic.commodity.mall.dao.UccMallLadderPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.utils.ListCloneUtils;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallQryPriceFromLadderPriceAtomServiceImpl
implements UccMallQryPriceFromLadderPriceAtomService {
    @Autowired
    private UccMallLadderPriceMapper ladderPriceMapper;
    @Autowired
    private UccMallSkuPriceMapper skuPriceMapper;

    @Override
    public UccMallQryPriceFromLadderPriceRspBO qryPriceFromLadderPrice(UccMallQryPriceFromLadderPriceReqBO reqBO) {
        UccMallQryPriceFromLadderPriceRspBO rspBO = new UccMallQryPriceFromLadderPriceRspBO();
        List<UccLadderPricePO> uccLadderPricePOList = null;
        try {
            uccLadderPricePOList = ListCloneUtils.clonePOListToBOList(reqBO.getQryPriceFromLadderPriceBOS(), UccLadderPricePO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<UccMallQryPriceFromLadderPriceBO> uccMallQryPriceFromLadderPriceBOS = new ArrayList<UccMallQryPriceFromLadderPriceBO>(reqBO.getQryPriceFromLadderPriceBOS().size());
        if (CollectionUtils.isNotEmpty(uccLadderPricePOList)) {
            List<UccLadderPricePO> ladderPricePOS = this.ladderPriceMapper.selectReturnLadderPriceBySkuId(uccLadderPricePOList, reqBO.getSysTenantId());
            Map<Long, List<UccLadderPricePO>> ladderPriceMap = ladderPricePOS.stream().filter(poList -> poList.getSkuId() != null).collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
            for (UccMallQryPriceFromLadderPriceBO uccMallQryPriceFromLadderPriceBO : reqBO.getQryPriceFromLadderPriceBOS()) {
                UccMallQryPriceFromLadderPriceBO priceFromLadderPriceBO = new UccMallQryPriceFromLadderPriceBO();
                if (ladderPriceMap.containsKey(uccMallQryPriceFromLadderPriceBO.getSkuId())) {
                    List<UccLadderPricePO> pricePOS = ladderPriceMap.get(uccMallQryPriceFromLadderPriceBO.getSkuId());
                    for (UccLadderPricePO pricePO : pricePOS) {
                        if (null == pricePO.getStop() && uccMallQryPriceFromLadderPriceBO.getPurchaseQuantity().compareTo(MoneyUtils.haoToYuan(pricePO.getStart())) >= 0) {
                            priceFromLadderPriceBO.setSkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                            priceFromLadderPriceBO.setPurchasePrice(MoneyUtils.haoToYuan(pricePO.getPrice()));
                        } else {
                            if (uccMallQryPriceFromLadderPriceBO.getPurchaseQuantity().compareTo(MoneyUtils.haoToYuan(pricePO.getStart())) < 0 || uccMallQryPriceFromLadderPriceBO.getPurchaseQuantity().compareTo(MoneyUtils.haoToYuan(pricePO.getStop())) >= 0) continue;
                            priceFromLadderPriceBO.setSkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                            priceFromLadderPriceBO.setPurchasePrice(MoneyUtils.haoToYuan(pricePO.getPrice()));
                        }
                        break;
                    }
                } else {
                    List<UccSkuPricePo> skuPricePos = this.skuPriceMapper.getPricesBySkuId(uccMallQryPriceFromLadderPriceBO.getSkuId(), reqBO.getSysTenantId());
                    if (CollectionUtils.isNotEmpty(skuPricePos)) {
                        priceFromLadderPriceBO.setPurchasePrice(MoneyUtils.haoToYuan(skuPricePos.get(0).getSalePrice()));
                        priceFromLadderPriceBO.setSkuId(uccMallQryPriceFromLadderPriceBO.getSkuId());
                        priceFromLadderPriceBO.setHavLadderPriceFlag(false);
                    }
                }
                uccMallQryPriceFromLadderPriceBOS.add(priceFromLadderPriceBO);
            }
        }
        rspBO.setQryPriceFromLadderPriceBOS(uccMallQryPriceFromLadderPriceBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

