/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuExtDetailsBO;
import com.tydic.commodity.mall.busi.api.UccMallCommdDetailsQryBusiService;
import com.tydic.commodity.mall.busi.api.UccMallOrderQrySkuDetailListBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallCommdDetailsQryBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallCommdDetailsQryBusiRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallOrderQrySkuDetailLisBO;
import com.tydic.commodity.mall.busi.bo.UccMallOrderQrySkuDetailLisReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallOrderQrySkuDetailLisRspBO;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityMeasureMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityPicMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccSkuAnnexExtMapper;
import com.tydic.commodity.mall.dao.UccSkuExpandMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccCommodityMeasurePo;
import com.tydic.commodity.mall.po.UccCommodityPicPo;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccMallSkuDetailInfoPO;
import com.tydic.commodity.mall.po.UccSkuAnnexExtPo;
import com.tydic.commodity.mall.po.UccSkuExpandPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMallOrderQrySkuDetailListBusiServiceImpl
implements UccMallOrderQrySkuDetailListBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallOrderQrySkuDetailListBusiServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccMallCommdDetailsQryBusiService uccMallCommdDetailsQryBusiService;
    @Autowired
    private UccMallCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccMallCommodityPicMapper uccMallCommodityPicMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Value(value="${xc_tenat_list:305775845729763327}")
    private String xcTenatList;
    @Autowired
    private UccSkuAnnexExtMapper uccSkuAnnexExtMapper;

    @Override
    public UccMallOrderQrySkuDetailLisRspBO qryOrderSkuInfo(UccMallOrderQrySkuDetailLisReqBO reqBO) {
        ArrayList<UccMallSkuDetailInfoBO> orderSkuList;
        UccMallOrderQrySkuDetailLisRspBO rspBO = new UccMallOrderQrySkuDetailLisRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<UccCommodityMeasurePo> measurePos = this.uccCommodityMeasureMapper.queryAll(reqBO.getSysTenantId());
        Map<Long, UccCommodityMeasurePo> measureMap = null;
        if (!CollectionUtils.isEmpty(measurePos)) {
            measureMap = measurePos.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureId, UccCommodityMeasurePo2 -> UccCommodityMeasurePo2));
        }
        ArrayList<Long> skus = new ArrayList<Long>(reqBO.getSkuList().stream().map(UccMallOrderQrySkuDetailLisBO::getSkuId).collect(Collectors.toSet()));
        List<UccMallSkuDetailInfoPO> skuInfoDetailPOS = this.uccMallSkuMapper.qryOrderSkusInfoList(skus, reqBO.getSysTenantId());
        List<UccSkuExpandPo> expandPos = this.uccSkuExpandMapper.querySkuExpandBySkus(skus);
        Map<String, List<UccSkuExpandPo>> technicalMap = expandPos.stream().filter(e -> !StringUtils.isEmpty((Object)e.getExpand5())).collect(Collectors.groupingBy(UccSkuExpandPo::getExpand5));
        Map skuExpandPoMap = expandPos.stream().collect(Collectors.toMap(UccSkuExpandPo::getSkuId, Function.identity(), (oldValue, newValue) -> oldValue));
        Map<Object, Object> annexExtPoMap = new HashMap();
        if (!technicalMap.isEmpty()) {
            UccSkuAnnexExtPo skuAnnexExtPo = new UccSkuAnnexExtPo();
            skuAnnexExtPo.setIds(technicalMap.keySet().stream().map(Long::valueOf).collect(Collectors.toList()));
            List<UccSkuAnnexExtPo> annexExtPoList = this.uccSkuAnnexExtMapper.querySkuAnnex(skuAnnexExtPo);
            if (!CollectionUtils.isEmpty(annexExtPoList)) {
                annexExtPoMap = annexExtPoList.stream().collect(Collectors.toMap(UccSkuAnnexExtPo::getId, Function.identity()));
            }
        }
        if (!CollectionUtils.isEmpty(skuInfoDetailPOS)) {
            List<UccCommodityPicPo> commodityPicPoList;
            log.info("-------------------------------------------------------skuInfoDetailPOS:{}", (Object)JSON.toJSONString(skuInfoDetailPOS));
            Map<Long, BigDecimal> skuReqStock = reqBO.getSkuList().stream().collect(Collectors.toMap(UccMallOrderQrySkuDetailLisBO::getSkuId, UccMallOrderQrySkuDetailLisBO::getNum, (value1, value2) -> value2));
            orderSkuList = new ArrayList<UccMallSkuDetailInfoBO>();
            if (skuInfoDetailPOS.size() != skus.size()) {
                throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_EXIST.code(), "\u5355\u54c1\u6570\u636e" + UccMallConstantsEnums.SKU_NOT_ON_EXIST.message());
            }
            ArrayList<Long> notPicSpu = new ArrayList<Long>();
            for (UccMallSkuDetailInfoPO uccSkuInfoDetailPO : skuInfoDetailPOS) {
                UccMallSkuDetailInfoBO uccSkuInfoDetailBO = new UccMallSkuDetailInfoBO();
                BeanUtils.copyProperties((Object)uccSkuInfoDetailPO, (Object)uccSkuInfoDetailBO);
                if (uccSkuInfoDetailPO.getSkuStatus() != ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                    throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_SELFE.code(), uccSkuInfoDetailPO.getSkuName() + UccMallConstantsEnums.SKU_NOT_ON_SELFE.message());
                }
                if (StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getMaterialName())) {
                    uccSkuInfoDetailBO.setMaterialName(uccSkuInfoDetailPO.getOrgMaterialName());
                }
                if (uccSkuInfoDetailBO.getMeasureId() != null && !measureMap.isEmpty()) {
                    if (measureMap.containsKey(uccSkuInfoDetailPO.getMeasureId())) {
                        uccSkuInfoDetailBO.setDecimalLimit(measureMap.get(uccSkuInfoDetailBO.getMeasureId()).getDecimalLimit());
                    } else {
                        log.error("\u8ba1\u91cf\u5355\u4f4d\u67e5\u8be2\u5f02\u5e38->{}" + uccSkuInfoDetailBO.getMeasureId());
                    }
                }
                if (uccSkuInfoDetailPO.getMoq().compareTo(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())) > 0) {
                    throw new BusinessException(UccMallConstantsEnums.SKU_MOQ_UNMET.code(), uccSkuInfoDetailPO.getSkuName() + UccMallConstantsEnums.SKU_MOQ_UNMET.message());
                }
                if (uccSkuInfoDetailPO.getSwitchOn() == 1 && !CollectionUtils.isEmpty(uccSkuInfoDetailPO.getLadderPricePOList())) {
                    for (UccLadderPricePO ladderprice : uccSkuInfoDetailPO.getLadderPricePOList()) {
                        if (MoneyUtils.haoToYuan(ladderprice.getStart()).compareTo(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())) > 0 || ladderprice.getStop() != null && MoneyUtils.haoToYuan(ladderprice.getStop()).compareTo(skuReqStock.get(uccSkuInfoDetailPO.getSkuId())) <= 0) continue;
                        uccSkuInfoDetailBO.setSalePrice(ladderprice.getPrice());
                        uccSkuInfoDetailBO.setSwitchOn(uccSkuInfoDetailPO.getSwitchOn());
                    }
                }
                if (skuExpandPoMap.containsKey(uccSkuInfoDetailPO.getSkuId()) && !StringUtils.isEmpty((Object)((UccSkuExpandPo)skuExpandPoMap.get(uccSkuInfoDetailPO.getSkuId())).getExpand5()) && annexExtPoMap.containsKey(Long.valueOf(((UccSkuExpandPo)skuExpandPoMap.get(uccSkuInfoDetailPO.getSkuId())).getExpand5()))) {
                    uccSkuInfoDetailBO.setTechnicalSpecificateName(((UccSkuAnnexExtPo)annexExtPoMap.get(Long.valueOf(((UccSkuExpandPo)skuExpandPoMap.get(uccSkuInfoDetailPO.getSkuId())).getExpand5()))).getAnnexName());
                    uccSkuInfoDetailBO.setTechnicalSpecificateUrl(((UccSkuAnnexExtPo)annexExtPoMap.get(Long.valueOf(((UccSkuExpandPo)skuExpandPoMap.get(uccSkuInfoDetailPO.getSkuId())).getExpand5()))).getAnnexUrl());
                }
                if (reqBO.getSysTenantId() == null || !this.xcTenatList.contains(reqBO.getSysTenantId().toString())) {
                    uccSkuInfoDetailBO.setXcSku("0");
                    uccSkuInfoDetailBO.setXcCategor("0");
                } else if (skuExpandPoMap.containsKey(uccSkuInfoDetailPO.getSkuId())) {
                    uccSkuInfoDetailBO.setXcCategor(((UccSkuExpandPo)skuExpandPoMap.get(uccSkuInfoDetailPO.getSkuId())).getExpand8());
                    uccSkuInfoDetailBO.setXcSku(((UccSkuExpandPo)skuExpandPoMap.get(uccSkuInfoDetailPO.getSkuId())).getExpand9());
                } else {
                    uccSkuInfoDetailBO.setXcCategor("0");
                    uccSkuInfoDetailBO.setXcSku("0");
                }
                orderSkuList.add(uccSkuInfoDetailBO);
                if (uccSkuInfoDetailBO.getSkuSource() == 2) {
                    UccMallCommdDetailsQryBusiReqBO uccCommdDetailsQryReqBO = new UccMallCommdDetailsQryBusiReqBO();
                    uccCommdDetailsQryReqBO.setSkuId(uccSkuInfoDetailBO.getSkuId());
                    uccCommdDetailsQryReqBO.setSupplierShopId(uccSkuInfoDetailBO.getSupplierShopId());
                    uccCommdDetailsQryReqBO.setSysTenantId(reqBO.getSysTenantId());
                    uccCommdDetailsQryReqBO.setSysTenantName(reqBO.getSysTenantName());
                    UccMallCommdDetailsQryBusiRspBo bo = null;
                    try {
                        bo = this.uccMallCommdDetailsQryBusiService.qryCommdDetails(uccCommdDetailsQryReqBO);
                    }
                    catch (Exception e2) {
                        log.error("\u8ba2\u5355\u67e5\u8be2\u7535\u5b50\u8d85\u5e02\u5546\u54c1\u8be6\u60c5\u5f02\u5e38\uff1a " + e2.getMessage());
                    }
                    if (bo == null) continue;
                    if (bo.getCommdInfo() != null) {
                        if (bo.getCommdInfo().getNotJdCommdDetails() != null) {
                            if (!uccSkuInfoDetailBO.getSkuName().equals(((UccMallSkuExtDetailsBO)bo.getCommdInfo().getNotJdCommdDetails().getSkuGroup().get(0)).getName())) {
                                uccSkuInfoDetailBO.setSkuName(((UccMallSkuExtDetailsBO)bo.getCommdInfo().getNotJdCommdDetails().getSkuGroup().get(0)).getName());
                            }
                            if (StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) {
                                uccSkuInfoDetailBO.setSkuMainPic(bo.getCommdInfo().getNotJdCommdDetails().getImagePath());
                            }
                        } else if (bo.getCommdInfo().getJdVedioInfo() != null) {
                            if (!uccSkuInfoDetailBO.getSkuName().equals(bo.getCommdInfo().getJdVedioInfo().getName())) {
                                uccSkuInfoDetailBO.setSkuName(bo.getCommdInfo().getJdVedioInfo().getName());
                            }
                            if (StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) {
                                uccSkuInfoDetailBO.setSkuMainPic(bo.getCommdInfo().getJdVedioInfo().getImage());
                            }
                        } else if (bo.getCommdInfo().getJdBookInfo() != null) {
                            if (!uccSkuInfoDetailBO.getSkuName().equals(bo.getCommdInfo().getJdBookInfo().getName())) {
                                uccSkuInfoDetailBO.setSkuName(bo.getCommdInfo().getJdBookInfo().getName());
                            }
                            if (StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) {
                                uccSkuInfoDetailBO.setSkuMainPic(bo.getCommdInfo().getJdBookInfo().getImage());
                            }
                        } else if (bo.getCommdInfo().getJdCommdInfo() != null) {
                            if (!uccSkuInfoDetailBO.getSkuName().equals(bo.getCommdInfo().getJdCommdInfo().getName())) {
                                uccSkuInfoDetailBO.setSkuName(bo.getCommdInfo().getJdCommdInfo().getName());
                            }
                            if (StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) {
                                uccSkuInfoDetailBO.setSkuMainPic(bo.getCommdInfo().getJdCommdInfo().getImagePath());
                            }
                        }
                    }
                }
                if (!StringUtils.isEmpty((Object)uccSkuInfoDetailBO.getSkuMainPic())) continue;
                notPicSpu.add(uccSkuInfoDetailBO.getCommodityId());
            }
            if (!CollectionUtils.isEmpty(notPicSpu) && !CollectionUtils.isEmpty(commodityPicPoList = this.uccMallCommodityPicMapper.queryBatchLesCloum(notPicSpu, null, 1, reqBO.getSysTenantId()))) {
                Map<Long, String> spuPicMap = commodityPicPoList.stream().collect(Collectors.toMap(UccCommodityPicPo::getCommodityId, UccCommodityPicPo::getCommodityPicUrl));
                for (UccMallSkuDetailInfoBO each : orderSkuList) {
                    if (!spuPicMap.containsKey(each.getCommodityId())) continue;
                    each.setSkuMainPic(spuPicMap.get(each.getCommodityId()));
                }
            }
        } else {
            throw new BusinessException(UccMallConstantsEnums.SKU_NOT_ON_EXIST.code(), "\u5355\u54c1\u6570\u636e" + UccMallConstantsEnums.SKU_NOT_ON_EXIST.message());
        }
        rspBO.setOrderSkuList(orderSkuList);
        return rspBO;
    }
}

