/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.mall.busi.api.UccMallRemovedProductBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallRemovedProductBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallRemovedProductBusiRspBO;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccMallRemovedProductBusiServiceImpl
implements UccMallRemovedProductBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallRemovedProductBusiServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Resource(name="uccMalllmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer uccMalllmSyncCommodityMqServiceProvider;
    @Value(value="${LM_UCC_SYNC_PID}")
    private String uccSyncPid;
    @Value(value="${LM_UCC_SYNC_CID}")
    private String uccSyncCid;
    @Value(value="${LM_UCC_SYNC_TOPIC}")
    private String uccSyncTopic;
    @Value(value="${LM_UCC_SYNC_TAG}")
    private String uccSyncTag;

    @Override
    public UccMallRemovedProductBusiRspBO removedProduct(UccMallRemovedProductBusiReqBO reqBO) {
        UccMallRemovedProductBusiRspBO rspBO = new UccMallRemovedProductBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (ObjectUtil.isEmpty(reqBO.getUpdateSkuIds())) {
            return rspBO;
        }
        ArrayList<String> updateIds = new ArrayList<String>();
        ArrayList<Map<String, Long>> syncSkuIds = new ArrayList<Map<String, Long>>();
        for (String updateSkuId : reqBO.getUpdateSkuIds()) {
            UccSkuPo uccSkuPo = new UccSkuPo();
            if (!ObjectUtil.isEmpty((Object)reqBO.getMethodName()) && "qrySkuState".equals(reqBO.getMethodName())) {
                uccSkuPo.setSkuId(Long.parseLong(updateSkuId));
            } else {
                uccSkuPo.setExtSkuId(updateSkuId);
            }
            if (ObjectUtil.isEmpty((Object)uccSkuPo.getSkuId()) && ObjectUtil.isEmpty((Object)uccSkuPo.getExtSkuId())) {
                log.info("\u5f53\u524d\u67e5\u8be2\u5165\u53c2\u4e3a\u7a7a");
                continue;
            }
            List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySkuToAgrId(uccSkuPo);
            if (ObjectUtil.isEmpty(uccSkuPoList)) continue;
            Long agreementId = uccSkuPoList.get(0).getAgreementId();
            if (ObjectUtil.isEmpty((Object)agreementId)) {
                HashMap<String, Long> temp = new HashMap<String, Long>();
                temp.put("skuId", uccSkuPoList.get(0).getSkuId());
                temp.put("supId", uccSkuPoList.get(0).getSupplierShopId());
                syncSkuIds.add(temp);
                if (!ObjectUtil.isEmpty((Object)reqBO.getMethodName()) && "qrySkuState".equals(reqBO.getMethodName())) {
                    updateIds.add(uccSkuPoList.get(0).getExtSkuId());
                    continue;
                }
                updateIds.add(updateSkuId);
                continue;
            }
            AgrQryAgreementSubjectDetailsAbilityReqBO agrQryAgreementSubjectDetailsAbilityReqBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
            agrQryAgreementSubjectDetailsAbilityReqBO.setAgreementId(agreementId);
            log.info("\u67e5\u8be2\u534f\u8bae\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)agrQryAgreementSubjectDetailsAbilityReqBO));
            AgrQryAgreementSubjectDetailsAbilityRspBO rspBO1 = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(agrQryAgreementSubjectDetailsAbilityReqBO);
            log.info("\u67e5\u8be2\u534f\u8bae\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)rspBO1));
            if (!ObjectUtil.isEmpty((Object)rspBO1.getAgrAgreementBO()) && !ObjectUtil.isEmpty((Object)rspBO1.getAgrAgreementBO().getAgreementMode()) && "2".equals(String.valueOf(rspBO1.getAgrAgreementBO().getAgreementMode()))) continue;
            HashMap<String, Long> temp = new HashMap<String, Long>();
            temp.put("skuId", uccSkuPoList.get(0).getSkuId());
            temp.put("supId", uccSkuPoList.get(0).getSupplierShopId());
            syncSkuIds.add(temp);
            if (!ObjectUtil.isEmpty((Object)reqBO.getMethodName()) && "qrySkuState".equals(reqBO.getMethodName())) {
                updateIds.add(uccSkuPoList.get(0).getExtSkuId());
                continue;
            }
            updateIds.add(updateSkuId);
        }
        if (ObjectUtil.isEmpty(updateIds)) {
            return rspBO;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setUpdateSkuIds(updateIds);
        uccSkuPo.setSkuStatus(reqBO.getSkuStatus());
        uccSkuPo.setRemark(reqBO.getRemark());
        this.uccMallSkuMapper.updateSkuByIds(uccSkuPo);
        this.sendMqToSyncSkuInfo(syncSkuIds);
        return rspBO;
    }

    private void sendMqToSyncSkuInfo(List<Map<String, Long>> skuInfos) {
        for (Map<String, Long> skuInfo : skuInfos) {
            Long supplierShopId = skuInfo.get("supId");
            List<Long> skus = Arrays.asList(skuInfo.get("skuId"));
            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(Integer.valueOf(2));
            syncSceneCommodityToEsReqBO.setSyncType(Integer.valueOf(4));
            syncSceneCommodityToEsReqBO.setSingleType(2);
            log.info("\u540c\u6b65\u5546\u54c1es\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            try {
                this.uccMalllmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
    }
}

