/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.agreement.ability.api.AgrMallQryAgreementSubjectAbilityService;
import com.tydic.agreement.ability.api.AgrQryAgreementSkuDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrMallQryAgreementSubjectAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrMallQryAgreementSubjectAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrMallQryAgreementSubjectBO;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallLadderPriceBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.commodity.mall.atom.api.InterfaceQryFscRuleAbilitySerive;
import com.tydic.commodity.mall.atom.bo.InterfaceMerchantConfBatchQueryReqDataBO;
import com.tydic.commodity.mall.atom.bo.InterfaceQryFscRuleAbilityBo;
import com.tydic.commodity.mall.atom.bo.InterfaceQryFscRuleAbilityReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceQryFscRuleAbilityRspBO;
import com.tydic.commodity.mall.busi.api.UccMallReplacementPriceBusiService;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallLadderPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallVendorMapper;
import com.tydic.commodity.mall.dao.UccSkuExpandMapper;
import com.tydic.commodity.mall.dao.UccSkuExtMapper;
import com.tydic.commodity.mall.po.UccCommodityPo;
import com.tydic.commodity.mall.po.UccLadderPricePO;
import com.tydic.commodity.mall.po.UccMallSkuVendorPO;
import com.tydic.commodity.mall.po.UccSkuExpandPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMallReplacementPriceBusiServiceImpl
implements UccMallReplacementPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallReplacementPriceBusiServiceImpl.class);
    @Autowired
    private UccMallVendorMapper uccMallVendorMapper;
    @Autowired
    private InterfaceQryFscRuleAbilitySerive interfaceQryFscRuleAbilitySerive;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuExtMapper uccSkuExtMapper;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallLadderPriceMapper uccMallLadderPriceMapper;
    @Autowired
    private AgrQryAgreementSkuDetailsAbilityService agrQryAgreementSkuDetailsAbilityService;
    @Autowired
    private AgrMallQryAgreementSubjectAbilityService agrMallQryAgreementSubjectAbilityService;
    @Value(value="${orgPathSZ}")
    private String orgPathSZ;

    @Override
    public UccMallReplacementPriceRspBo replacePrice(UccMallReplacementPriceReqBo reqBO) {
        Map<Integer, List<ReplacePriceInfoBO>> groupBySource;
        UccMallReplacementPriceRspBo rspBO = new UccMallReplacementPriceRspBo();
        List replacePriceInfo = reqBO.getReplacePriceInfo();
        if (CollectionUtils.isEmpty((Collection)replacePriceInfo)) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        List<UccLadderPricePO> uccLadderPricePOS = this.uccMallLadderPriceMapper.selectBySkuIds(replacePriceInfo.stream().map(ReplacePriceInfoBO::getSkuId).collect(Collectors.toList()), null);
        if (!CollectionUtils.isEmpty(uccLadderPricePOS)) {
            Map<Long, List<UccLadderPricePO>> ladderPricePOMap = uccLadderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
            for (Object each : replacePriceInfo) {
                if (!ladderPricePOMap.containsKey(each.getSkuId())) continue;
                ArrayList<UccMallLadderPriceBo> ladderPrice = new ArrayList<UccMallLadderPriceBo>();
                for (UccLadderPricePO po : ladderPricePOMap.get(each.getSkuId())) {
                    UccMallLadderPriceBo uccMallLadderPriceBo = new UccMallLadderPriceBo();
                    BeanUtils.copyProperties((Object)po, (Object)uccMallLadderPriceBo);
                    if (po.getPrice() != null) {
                        uccMallLadderPriceBo.setPrice(MoneyUtils.haoToYuan(po.getPrice()));
                    }
                    if (po.getStart() != null) {
                        uccMallLadderPriceBo.setStart(MoneyUtils.haoToYuan(po.getStart()));
                    }
                    if (po.getStop() != null) {
                        uccMallLadderPriceBo.setStop(MoneyUtils.haoToYuan(po.getStop()));
                    }
                    ladderPrice.add(uccMallLadderPriceBo);
                }
                each.setLadderPrice(ladderPrice);
            }
        }
        if (StringUtils.isEmpty((Object)reqBO.getCompanyId())) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(reqBO.getReplacePriceInfo());
            return rspBO;
        }
        List<Long> skuIds = replacePriceInfo.stream().map(ReplacePriceInfoBO::getSkuId).collect(Collectors.toList());
        List<UccMallSkuVendorPO> uccMallSkuVendorPOS = null;
        if (!CollectionUtils.isEmpty(skuIds) && !CollectionUtils.isEmpty(uccMallSkuVendorPOS = this.uccMallVendorMapper.batchSelectBySkuIds(skuIds, reqBO.getSysTenantId()))) {
            for (ReplacePriceInfoBO replacePriceInfoBO : reqBO.getReplacePriceInfo()) {
                for (UccMallSkuVendorPO uccMallSkuVendorPO : uccMallSkuVendorPOS) {
                    if (!replacePriceInfoBO.getSkuId().equals(uccMallSkuVendorPO.getSkuId())) continue;
                    replacePriceInfoBO.setCommodityTypeId(uccMallSkuVendorPO.getCommodityTypeId());
                    replacePriceInfoBO.setVendorId(uccMallSkuVendorPO.getVendorId());
                }
            }
        }
        if ((groupBySource = reqBO.getReplacePriceInfo().stream().collect(Collectors.groupingBy(ReplacePriceInfoBO::getSkuSource))).isEmpty()) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        UccSkuExpandPo uccSkuExpandPo = new UccSkuExpandPo();
        uccSkuExpandPo.setSkuIds(reqBO.getReplacePriceInfo().stream().map(ReplacePriceInfoBO::getSkuId).collect(Collectors.toList()));
        uccSkuExpandPo.setSysTenantId(reqBO.getSysTenantId());
        List<UccSkuExpandPo> uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand(uccSkuExpandPo);
        Map<Object, Object> collect = new HashMap();
        if (!CollectionUtils.isEmpty(uccSkuExpandPos)) {
            collect = uccSkuExpandPos.stream().collect(Collectors.toMap(UccSkuExpandPo::getSkuId, Function.identity()));
        }
        ArrayList<ReplacePriceInfoBO> agrList = new ArrayList<ReplacePriceInfoBO>();
        ArrayList<InterfaceMerchantConfBatchQueryReqDataBO> qryInfo = new ArrayList<InterfaceMerchantConfBatchQueryReqDataBO>();
        InterfaceMerchantConfBatchQueryReqDataBO fscMerchantConfBatchQueryReqDataBO = null;
        for (Map.Entry<Integer, List<ReplacePriceInfoBO>> entry : groupBySource.entrySet()) {
            if (ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION.equals(entry.getKey())) {
                for (ReplacePriceInfoBO bo : entry.getValue()) {
                    agrList.add(bo);
                }
            }
            if (ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT.equals(entry.getKey())) {
                for (ReplacePriceInfoBO bo : entry.getValue()) {
                    if (collect.containsKey(bo.getSkuId()) && ((UccSkuExpandPo)collect.get(bo.getSkuId())).getSourceAssort() != null && ((UccSkuExpandPo)collect.get(bo.getSkuId())).getSourceAssort() == 1) {
                        agrList.add(bo);
                        continue;
                    }
                    fscMerchantConfBatchQueryReqDataBO = new InterfaceMerchantConfBatchQueryReqDataBO();
                    fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                    fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                    fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                    qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
                }
            }
            if (!ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT.equals(entry.getKey())) continue;
            for (ReplacePriceInfoBO bo : entry.getValue()) {
                fscMerchantConfBatchQueryReqDataBO = new InterfaceMerchantConfBatchQueryReqDataBO();
                fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                UccCommodityPo uccCommodityPo = this.uccMallCommodityMapper.getCommodityById(bo.getCommodityId(), reqBO.getSysTenantId());
                fscMerchantConfBatchQueryReqDataBO.setModelContractId(uccCommodityPo.getOtherSourceId());
                qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
            }
        }
        if (CollectionUtils.isEmpty(qryInfo) && CollectionUtils.isEmpty(agrList)) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        if (!CollectionUtils.isEmpty(agrList)) {
            List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qeryBatchSkus(agrList.stream().map(ReplacePriceInfoBO::getSkuId).collect(Collectors.toList()), reqBO.getSysTenantId());
            List agrIds = uccSkuPos.stream().map(UccSkuPo::getAgreementId).collect(Collectors.toList());
            AgrMallQryAgreementSubjectAbilityReqBO agrMallQryAgreementSubjectAbilityReqBO = new AgrMallQryAgreementSubjectAbilityReqBO();
            agrMallQryAgreementSubjectAbilityReqBO.setAgreementIdList(agrIds);
            AgrMallQryAgreementSubjectAbilityRspBO agrQryRspBo = this.agrMallQryAgreementSubjectAbilityService.qryAgreementSubject(agrMallQryAgreementSubjectAbilityReqBO);
            if (!"0000".equals(agrQryRspBo.getRespCode())) {
                log.error("\u67e5\u8be2\u534f\u8bae\u62a5\u9519 " + JSONObject.toJSONString((Object)agrMallQryAgreementSubjectAbilityReqBO) + "  " + agrQryRspBo.getRespDesc());
            } else if (!CollectionUtils.isEmpty((Collection)agrQryRspBo.getRows())) {
                Map<Long, Long> skuAgrMap = uccSkuPos.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo::getAgreementId));
                Map<Long, Byte> agrTradeMode = agrQryRspBo.getRows().stream().collect(Collectors.toMap(AgrMallQryAgreementSubjectBO::getAgreementId, AgrMallQryAgreementSubjectBO::getTradeMode));
                for (ReplacePriceInfoBO eachprice : reqBO.getReplacePriceInfo()) {
                    if (!skuAgrMap.containsKey(eachprice.getSkuId()) || !agrTradeMode.containsKey(skuAgrMap.get(eachprice.getSkuId()))) continue;
                    if (agrTradeMode.get(skuAgrMap.get(eachprice.getSkuId())) == 2) {
                        eachprice.setReplace(Integer.valueOf(1));
                        eachprice.setBusiMode(Integer.valueOf(2));
                        if (eachprice.getSwitchOn() != null && eachprice.getSwitchOn() == 1) {
                            eachprice.setAgreementPrice(eachprice.getSalePrice());
                            continue;
                        }
                        eachprice.setSalePrice(eachprice.getAgreementPrice());
                        continue;
                    }
                    if (StringUtils.isEmpty((Object)reqBO.getOrgPath()) || !reqBO.getOrgPath().contains(this.orgPathSZ)) continue;
                    eachprice.setSalePrice(eachprice.getAgreementPrice());
                    eachprice.setBusiMode(Integer.valueOf(2));
                    eachprice.setReplace(Integer.valueOf(1));
                }
            } else {
                log.error("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u4e3b\u9898\u4fe1\u606f: " + JSONObject.toJSONString((Object)agrMallQryAgreementSubjectAbilityReqBO));
            }
        }
        if (!CollectionUtils.isEmpty(qryInfo)) {
            InterfaceQryFscRuleAbilityReqBO CnncQryFscRuleAbilityReqBO = new InterfaceQryFscRuleAbilityReqBO();
            CnncQryFscRuleAbilityReqBO.setQryInfo(qryInfo);
            CnncQryFscRuleAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
            InterfaceQryFscRuleAbilityRspBO cnncQryFscRuleAbilityRspBO = this.interfaceQryFscRuleAbilitySerive.qryRule(CnncQryFscRuleAbilityReqBO);
            if ("0000".equals(cnncQryFscRuleAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty(cnncQryFscRuleAbilityRspBO.getResult())) {
                for (ReplacePriceInfoBO eachprice : reqBO.getReplacePriceInfo()) {
                    for (InterfaceQryFscRuleAbilityBo fsc : cnncQryFscRuleAbilityRspBO.getResult()) {
                        if (!fsc.getVendorId().equals(eachprice.getVendorId()) || !fsc.getCommodityTypeId().equals(eachprice.getCommodityTypeId())) continue;
                        if (eachprice.getContractId() != null) {
                            if (!fsc.getContractId().equals(eachprice.getOtherSourceId())) continue;
                            if (fsc.getBusiMode() != null && fsc.getBusiMode() == 2) {
                                eachprice.setReplace(Integer.valueOf(1));
                                eachprice.setBusiMode(Integer.valueOf(2));
                                if (eachprice.getSwitchOn() != null && eachprice.getSwitchOn() == 1) {
                                    eachprice.setAgreementPrice(eachprice.getSalePrice());
                                    continue;
                                }
                                eachprice.setSalePrice(eachprice.getAgreementPrice());
                                continue;
                            }
                            if (StringUtils.isEmpty((Object)reqBO.getOrgPath()) || !reqBO.getOrgPath().contains(this.orgPathSZ)) continue;
                            eachprice.setSalePrice(eachprice.getAgreementPrice());
                            eachprice.setBusiMode(Integer.valueOf(2));
                            eachprice.setReplace(Integer.valueOf(1));
                            continue;
                        }
                        if (fsc.getBusiMode() != null && fsc.getBusiMode() == 2) {
                            eachprice.setReplace(Integer.valueOf(1));
                            eachprice.setBusiMode(Integer.valueOf(2));
                            if (eachprice.getSwitchOn() != null && eachprice.getSwitchOn() == 1) {
                                eachprice.setAgreementPrice(eachprice.getSalePrice());
                                continue;
                            }
                            eachprice.setSalePrice(eachprice.getAgreementPrice());
                            continue;
                        }
                        if (StringUtils.isEmpty((Object)reqBO.getOrgPath()) || !reqBO.getOrgPath().contains(this.orgPathSZ)) continue;
                        eachprice.setSalePrice(eachprice.getAgreementPrice());
                        eachprice.setBusiMode(Integer.valueOf(2));
                        eachprice.setReplace(Integer.valueOf(1));
                    }
                }
            }
        }
        this.replaceByPsDisount(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(reqBO.getReplacePriceInfo());
        List rows = rspBO.getRows();
        ArrayList<Long> uccVendIds = new ArrayList<Long>();
        for (ReplacePriceInfoBO bo : rows) {
            uccVendIds.add(bo.getVendorId());
        }
        if (!CollectionUtils.isEmpty(uccVendIds)) {
            List<UccMallSkuVendorPO> uccVendorPos = this.uccMallVendorMapper.batchSelectBySkuIds(skuIds, reqBO.getSysTenantId());
            block12: for (ReplacePriceInfoBO bo : rows) {
                for (UccMallSkuVendorPO po : uccVendorPos) {
                    if (!po.getVendorId().equals(bo.getVendorId())) continue;
                    bo.setVendorName(po.getVendorName());
                    continue block12;
                }
            }
        }
        return rspBO;
    }

    private void replaceByPsDisount(UccMallReplacementPriceReqBo reqBO) {
        if (reqBO.getPsDiscountRate() != null && reqBO.getPsDiscountRate().compareTo(BigDecimal.ZERO) != 0) {
            for (ReplacePriceInfoBO replacePriceInfoBO : reqBO.getReplacePriceInfo()) {
                if (replacePriceInfoBO.getReplace() != 1) {
                    replacePriceInfoBO.setBusiMode(Integer.valueOf(1));
                    if (replacePriceInfoBO.getSalePrice().equals(replacePriceInfoBO.getAgreementPrice())) continue;
                    Long difValue = replacePriceInfoBO.getSalePrice() - replacePriceInfoBO.getAgreementPrice();
                    Long salePirce = new BigDecimal(difValue.toString()).multiply(reqBO.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, 0)).longValue() + replacePriceInfoBO.getAgreementPrice();
                    replacePriceInfoBO.setSalePrice(salePirce);
                    continue;
                }
                replacePriceInfoBO.setBusiMode(Integer.valueOf(2));
            }
        }
    }
}

