/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.tydic.commodity.mall.ability.bo.UccMallShufflingPicQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallShufflingPicQryAbilityRspBO;
import com.tydic.commodity.mall.atom.api.UccMallShufflingPicQryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallShufflingPicQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallShufflingPicQryRspBO;
import com.tydic.commodity.mall.busi.api.UccMallShufflingPicQryBusiService;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallShufflingPicQryBusiServiceImpl
implements UccMallShufflingPicQryBusiService {
    @Autowired
    private UccMallShufflingPicQryAtomService uccMallShufflingPicQryAtomService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;

    @Override
    public UccMallShufflingPicQryAbilityRspBO qryShufflingPic(UccMallShufflingPicQryAbilityReqBO reqBo) {
        SupplierShopPo supplierShopPo;
        UccMallShufflingPicQryAbilityRspBO rspBo = new UccMallShufflingPicQryAbilityRspBO();
        if (null == reqBo || null == reqBo.getSupplierShopId()) {
            rspBo.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        List<Object> skuPoList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuIds()) && CollectionUtils.isEmpty(skuPoList = this.uccMallSkuMapper.queryBatchSkusLessCloum(reqBo.getSkuIds(), reqBo.getSupplierShopId(), reqBo.getSysTenantId()))) {
            rspBo.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94SKU\u4fe1\u606f");
            return rspBo;
        }
        List<Object> uccSkuPos = new ArrayList();
        if (null != reqBo.getSpuId()) {
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setCommodityId(reqBo.getSpuId());
            uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
            uccSkuPo.setSysTenantId(reqBo.getSysTenantId());
            uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo);
        }
        if ((supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId(), reqBo.getSysTenantId())) == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId, reqBo.getSysTenantId());
        if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        UccMallShufflingPicQryReqBO uccShufflingPicQryReqBo = new UccMallShufflingPicQryReqBO();
        if (!CollectionUtils.isEmpty(skuPoList)) {
            uccShufflingPicQryReqBo.setSkuIds(skuPoList.stream().map(UccSkuPo::getExtSkuId).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(uccSkuPos)) {
            uccShufflingPicQryReqBo.setSpuId(((UccSkuPo)uccSkuPos.get(0)).getExtSpuId());
        }
        uccShufflingPicQryReqBo.setSupplierCode(supplierCode);
        uccShufflingPicQryReqBo.setSupplierId(supplierId);
        uccShufflingPicQryReqBo.setSysTenantId(reqBo.getSysTenantId());
        UccMallShufflingPicQryRspBO uccShufflingPicQryRspBo = this.uccMallShufflingPicQryAtomService.qryShufflingPic(uccShufflingPicQryReqBo);
        if (!"0000".equals(uccShufflingPicQryRspBo.getRespCode())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(uccShufflingPicQryRspBo.getRespDesc());
            return rspBo;
        }
        if (!CollectionUtils.isEmpty(uccShufflingPicQryRspBo.getCommdShufflingPicInfos())) {
            rspBo.setSku(uccShufflingPicQryRspBo.getCommdShufflingPicInfos().get(0).getSku());
            rspBo.setJdCommdPicInfos(uccShufflingPicQryRspBo.getCommdShufflingPicInfos().get(0).getJdCommdPicInfos());
            rspBo.setNotJdCommdPicInfo(uccShufflingPicQryRspBo.getCommdShufflingPicInfos().get(0).getNotJdCommdPicInfo());
            rspBo.setFailMark(uccShufflingPicQryRspBo.getFailMark());
            rspBo.setFailError(uccShufflingPicQryRspBo.getFailError());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

