/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.self.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.consumer.bo.DycUccApproveTaskSyncBO;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.self.ability.bo.UccSelfSkuBatchEnforceDownApplyAbilityReqBO;
import com.tydic.commodity.self.ability.bo.UccSelfSkuBatchEnforceDownApplyAbilityRspBO;
import com.tydic.commodity.self.busi.api.UccSelfSkuBatchEnforceDownApplyBusiService;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ListUtils;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import com.tydic.umc.general.ability.api.UmcSendHaveDoneAbilityService;
import com.tydic.umc.general.ability.bo.UmcSendHaveDoneAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcSendHaveDoneAbilityRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSelfSkuBatchEnforceDownApplyBusiServiceImpl
implements UccSelfSkuBatchEnforceDownApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSelfSkuBatchEnforceDownApplyBusiServiceImpl.class);
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="dycUccProcessTaskSyncBySelfProducer")
    private ProxyMessageProducer dycUccProcessTaskSyncBySelfProducer;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private UmcSendHaveDoneAbilityService umcSendHaveDoneAbilityService;

    @Override
    public UccSelfSkuBatchEnforceDownApplyAbilityRspBO dealSelfSkuEnforceDownApply(UccSelfSkuBatchEnforceDownApplyAbilityReqBO reqBO) {
        UccSelfSkuBatchEnforceDownApplyAbilityRspBO rspBO = new UccSelfSkuBatchEnforceDownApplyAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5f3a\u5236\u4e0b\u67b6\u6210\u529f");
        HashMap<Long, List<Object>> syncInfo = new HashMap<Long, List<Object>>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u4e0b\u67b6\u5355\u54c1\u4fe1\u606f");
            return rspBO;
        }
        List<Object> skus = new ArrayList();
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        for (Long supplierShopId : mapSku.keySet()) {
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List uccSkuPos = null;
            try {
                uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
                List<Long> failIds = new ArrayList();
                List<Long> downGoAudit = new ArrayList();
                ArrayList<Long> editGoAudit = new ArrayList<Long>();
                if (uccSkuPos.size() < skus.size()) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                    return rspBO;
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (uccSkuPo.getSkuStatus() == SkuStatusEnum.ON_SHELVES_STATUS.getStatus()) continue;
                        failIds.add(uccSkuPo.getSkuId());
                    }
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (uccSkuPo.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO) {
                            downGoAudit.add(uccSkuPo.getSkuId());
                        }
                        if (uccSkuPo.getApprovalStatus() != ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO) continue;
                        editGoAudit.add(uccSkuPo.getCommodityId());
                    }
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIds = ListUtils.removeNull(failIds))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + failIds.toString() + "\u72b6\u6001\u4e0d\u4e3a\u4e0a\u67b6");
                    return rspBO;
                }
                if (reqBO.getSameLevel() == 1) {
                    ArrayList<Integer> skuStatus = new ArrayList<Integer>();
                    skuStatus.add(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
                    skuStatus.add(SkuStatusEnum.FROZEN_STATUS.getStatus());
                    List sameLevelOtrherSku = this.uccSkuMapper.queySameLevelOtrherSku(skus, supplierShopId, skuStatus, null, null);
                    if (!CollectionUtils.isEmpty((Collection)sameLevelOtrherSku)) {
                        Iterator iterator = sameLevelOtrherSku.iterator();
                        while (iterator.hasNext()) {
                            UccSkuPo same = (UccSkuPo)iterator.next();
                            if (same != null && same.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO) {
                                downGoAudit.add(same.getSkuId());
                                skus.add(same.getSkuId());
                            }
                            if (same == null || same.getApprovalStatus() != ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO) continue;
                            editGoAudit.add(same.getCommodityId());
                            skus.add(same.getSkuId());
                        }
                    }
                }
                downGoAudit = ListUtils.removeNull(downGoAudit);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(editGoAudit)) {
                    editGoAudit = new ArrayList(new HashSet(ListUtils.removeNull(editGoAudit)));
                }
                ArrayList<Long> businessIdList = new ArrayList<Long>();
                businessIdList.addAll(editGoAudit);
                businessIdList.addAll(downGoAudit);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(businessIdList)) {
                    this.dealApproveRollBack(businessIdList, reqBO);
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(downGoAudit)) {
                        // empty if block
                    }
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty(editGoAudit)) {
                        this.uccCommodityMapper.batchUpdateSpuApprovalStatus(editGoAudit, null, supplierShopId);
                        this.uccCommodityMapper.batchUpdateStep(editGoAudit, null, supplierShopId);
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new BusinessException("8888", "\u5931\u8d25" + e.getMessage());
            }
            UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
            UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
            ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
            UccSkuUpdateStatusBO bo = null;
            for (Long l : skus) {
                bo = new UccSkuUpdateStatusBO();
                bo.setSkuId(l);
                bo.setSkuStatus(SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus());
                skuUpdateStatusBOS.add(bo);
            }
            uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
            uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
            uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
            uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus("0");
            uccStatusChangeUpdateSpuAtomReqBO.setStepId("null");
            syncInfo.put(supplierShopId, skus);
            try {
                statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
                if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
                }
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
            }
            try {
                for (Long l : skus) {
                    UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                    uccSkuPutCirReqBO.setSkuId(l);
                    uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                    uccSkuPutCirReqBO.setDownType(Integer.valueOf(1));
                    uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr((Date)new Date()));
                    uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                    uccSkuPutCirReqBO.setRemark("\u5f3a\u5236\u4e0b\u67b6");
                    this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
            }
        }
        rspBO.setSyncInfo(syncInfo);
        return rspBO;
    }

    private void dealApproveRollBack(List<Long> businessIdList, UccSelfSkuBatchEnforceDownApplyAbilityReqBO reqBO) {
        log.info("\u65e0\u534f\u8bae\u5355\u54c1\u5f3a\u5236\u4e0b\u67b6\uff0c\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c-----------businessIdList:{}", (Object)JSON.toJSONString(businessIdList));
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setBusinessIds(businessIdList.stream().map(Object::toString).collect(Collectors.toList()));
        eacRuTaskPO.setStatus("ACTIVE");
        List taskList = this.eacRuTaskMapper.getList(eacRuTaskPO);
        Map<String, List<EacRuTaskPO>> collect = taskList.stream().collect(Collectors.groupingBy(EacRuTaskPO::getApproveInstId));
        ArrayList<EacApproveAbilityRspInfoBO> list = new ArrayList<EacApproveAbilityRspInfoBO>();
        for (String approveInstId : collect.keySet()) {
            EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
            eacRuInstAbilityReqBO.setApproveInstId(approveInstId);
            try {
                log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u5165\u53c2eacRuInstAbilityReqBO:" + JSON.toJSON((Object)eacRuInstAbilityReqBO));
                EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
                log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u51fa\u53c2eacRuInstAbilityRspBO:" + JSON.toJSON((Object)eacRuInstAbilityRspBO));
                if (!"0000".equals(eacRuInstAbilityRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), eacRuInstAbilityRspBO.getRespDesc());
                }
            }
            catch (BusinessException e) {
                throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), e.getMsgInfo());
            }
            EacApproveAbilityRspInfoBO eacApproveAbilityRspInfoBO = new EacApproveAbilityRspInfoBO();
            eacApproveAbilityRspInfoBO.setApproveInstId(approveInstId);
            eacApproveAbilityRspInfoBO.setIsFinish(Boolean.valueOf(true));
            eacApproveAbilityRspInfoBO.setTacheCode(collect.get(approveInstId).get(0).getTacheCode());
            eacApproveAbilityRspInfoBO.setTacheName(collect.get(approveInstId).get(0).getTacheName());
            list.add(eacApproveAbilityRspInfoBO);
        }
        log.info("----------------------list:{}", (Object)JSON.toJSONString(list));
        for (EacApproveAbilityRspInfoBO each : list) {
            try {
                DycUccApproveTaskSyncBO dycUccApproveTaskSyncBO = new DycUccApproveTaskSyncBO();
                dycUccApproveTaskSyncBO.setIsfinish(null);
                dycUccApproveTaskSyncBO.setIsfinish(each.getIsFinish());
                dycUccApproveTaskSyncBO.setProcInstId(each.getApproveInstId());
                log.info("------------------\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u4eff\u7167\u5ba1\u6279\u4e2d\u5fc3\u53d1\u9001mq\uff1a{}" + JSON.toJSONString((Object)dycUccApproveTaskSyncBO));
                this.dycUccProcessTaskSyncBySelfProducer.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_APPROVE_TASK_SYNC_BY_SELF_TOPIC"), PropertiesUtil.getProperty((String)"APPROVE_TASK_SYNC_TAG"), JSON.toJSONString((Object)dycUccApproveTaskSyncBO)));
            }
            catch (Exception e) {
                log.error("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u4eff\u7167\u5ba1\u6279\u4e2d\u5fc3\u53d1\u9001mq\u5931\u8d25\uff1a" + e.getMessage());
            }
            try {
                UmcSendHaveDoneAbilityReqBO umcSendHaveDoneAbilityReqBO = new UmcSendHaveDoneAbilityReqBO();
                umcSendHaveDoneAbilityReqBO.setBusiId(each.getApproveInstId() + "-" + each.getTacheCode());
                umcSendHaveDoneAbilityReqBO.setOperUserId(reqBO.getUserId().toString());
                umcSendHaveDoneAbilityReqBO.setOperUserName(reqBO.getUsername());
                umcSendHaveDoneAbilityReqBO.setBusinessUnid(each.getApproveInstId());
                umcSendHaveDoneAbilityReqBO.setCurnode(each.getTacheName());
                umcSendHaveDoneAbilityReqBO.setFlowstatus("\u6d41\u7a0b\u7ed3\u675f");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                umcSendHaveDoneAbilityReqBO.setFlowovertime(simpleDateFormat.format(new Date(System.currentTimeMillis())));
                log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u6d41\u7a0b\u7ed3\u675f\uff0c\u53d1\u9001\u5df2\u529e\u5165\u53c2umcSendHaveDoneAbilityReqBO:{}", (Object)JSON.toJSONString((Object)umcSendHaveDoneAbilityReqBO));
                UmcSendHaveDoneAbilityRspBO umcSendHaveDoneAbilityRspBO = this.umcSendHaveDoneAbilityService.sendHaveDone(umcSendHaveDoneAbilityReqBO);
                log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u6d41\u7a0b\u7ed3\u675f\uff0c\u53d1\u9001\u5df2\u529e\u51fa\u53c2umcSendHaveDoneAbilityRspBO:{}", (Object)JSON.toJSONString((Object)umcSendHaveDoneAbilityRspBO));
            }
            catch (Exception e) {
                log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u6d41\u7a0b\u7ed3\u675f\uff0c\u53d1\u9001\u5df2\u529e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }
}

