/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.bo.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrIteminbulkApplyAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrIteminbulkApplyAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrIteminbulkApplyAbilityRspBO;
import com.tydic.commodity.zone.busi.api.UccAgrRenewalSpuBusibService;
import com.tydic.commodity.zone.busi.bo.UccAgrRenewalSpuBusiReqBO;
import com.tydic.commodity.zone.comb.api.UccAgrRenewalSpuCombService;
import com.tydic.commodity.zone.comb.bo.RenewalRelationBO;
import com.tydic.commodity.zone.comb.bo.UccAgrRenewalSpuCombReqBO;
import com.tydic.commodity.zone.comb.bo.UccAgrRenewalSpuCombRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAgrRenewalSpuCombServiceImpl
implements UccAgrRenewalSpuCombService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrRenewalSpuCombServiceImpl.class);
    @Autowired
    public AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Autowired
    private UccAgrRenewalSpuBusibService uccAgrRenewalSpuBusibService;
    @Autowired
    private UccAgrIteminbulkApplyAbilityService uccAgrIteminbulkApplyAbilityService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccAgrRenewalSpuCombRspBO dealRenewalSpu(UccAgrRenewalSpuCombReqBO reqBO) {
        UccAgrRenewalSpuCombRspBO combRspBO = new UccAgrRenewalSpuCombRspBO();
        combRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBO.getOldAgreementSkuIds())) {
            return combRspBO;
        }
        if (CollectionUtils.isEmpty(reqBO.getRenewalRelationBOS())) {
            return combRspBO;
        }
        if (CollectionUtils.isEmpty(reqBO.getAgrAgreementSkuBOS())) {
            return combRspBO;
        }
        AgrQryAgreementSubjectDetailsAbilityReqBO agrQryAgreementSubjectDetailsAbilityReqBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
        agrQryAgreementSubjectDetailsAbilityReqBO.setAgreementId(reqBO.getAgreementId());
        AgrQryAgreementSubjectDetailsAbilityRspBO agrQryAgreementSubjectDetailsAbilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(agrQryAgreementSubjectDetailsAbilityReqBO);
        if (!"0000".equals(agrQryAgreementSubjectDetailsAbilityRspBO.getRespCode())) {
            log.error("\u534f\u8bae\u7eed\u7b7e\u67e5\u8be2\u5f02\u5e38 \uff1a " + agrQryAgreementSubjectDetailsAbilityRspBO.getRespDesc());
            return combRspBO;
        }
        List skuPoList = this.uccSkuMapper.selectByAgreementDetailIds(new ArrayList(), reqBO.getOldAgreementSkuIds());
        if (CollectionUtils.isEmpty((Collection)skuPoList)) {
            return combRspBO;
        }
        List notRelation = skuPoList.stream().filter(e -> !e.getSupplierShopId().toString().equals(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getVendorId().toString())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notRelation)) {
            log.info("\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\uff0c\u4e0d\u7eed\u7b7e \uff1a " + notRelation.stream().map(UccSkuPo::getAgreementDetailsId).collect(Collectors.toList()));
            skuPoList.removeAll(notRelation);
        }
        if (CollectionUtils.isEmpty((Collection)skuPoList)) {
            return combRspBO;
        }
        Map<Long, Long> agreDetailMap = skuPoList.stream().collect(Collectors.toMap(UccSkuPo::getAgreementDetailsId, UccSkuPo::getSkuId));
        HashMap<Long, Long> skuRelation = new HashMap<Long, Long>();
        for (RenewalRelationBO each : reqBO.getRenewalRelationBOS()) {
            if (!agreDetailMap.containsKey(each.getOldAgreementSkuId())) continue;
            skuRelation.put(agreDetailMap.get(each.getOldAgreementSkuId()), each.getNewAgreementSkuId());
        }
        Map agrDeatilInfoMap = reqBO.getAgrAgreementSkuBOS().stream().collect(Collectors.toMap(AgrAgreementSkuBO::getAgreementSkuId, Function.identity()));
        Iterator iterator = skuRelation.keySet().iterator();
        UccAgrRenewalSpuBusiReqBO spuBusiReqBO = null;
        while (iterator.hasNext()) {
            spuBusiReqBO = new UccAgrRenewalSpuBusiReqBO();
            Long skuId = (Long)iterator.next();
            spuBusiReqBO.setAgreementId(reqBO.getAgreementId());
            spuBusiReqBO.setSkuId(skuId);
            spuBusiReqBO.setAgreementName(reqBO.getAgreementName());
            spuBusiReqBO.setAgreementSkuBO((AgrAgreementSkuBO)agrDeatilInfoMap.get(skuRelation.get(skuId)));
            spuBusiReqBO.setEffDate(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getEffDate());
            spuBusiReqBO.setEntAgreementCode(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getEntAgreementCode());
            spuBusiReqBO.setHrAgreementType(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getAgreementClassification());
            spuBusiReqBO.setPlaAgreementCode(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getPlaAgreementCode());
            spuBusiReqBO.setScopeBOS(reqBO.getScopeBOS());
            UccAgrRenewalSpuCombRspBO renewalSpuCombRspBO = this.uccAgrRenewalSpuBusibService.dealRenewalSpu(spuBusiReqBO);
            if ("0000".equals(renewalSpuCombRspBO.getRespCode())) {
                UccBatchSkuBO uccBatchSkuBO = new UccBatchSkuBO();
                uccBatchSkuBO.setSkuId(renewalSpuCombRspBO.getSkuId());
                uccBatchSkuBO.setSupplierShopId(renewalSpuCombRspBO.getShopId());
                UccAgrIteminbulkApplyAbilityReqBO uccAgrIteminbulkApplyAbilityReqBO = new UccAgrIteminbulkApplyAbilityReqBO();
                uccAgrIteminbulkApplyAbilityReqBO.setOrgId(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getVendorId());
                uccAgrIteminbulkApplyAbilityReqBO.setUserId(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getProducerId());
                uccAgrIteminbulkApplyAbilityReqBO.setUsername(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getProducerName());
                uccAgrIteminbulkApplyAbilityReqBO.setSameLevel(Integer.valueOf(0));
                uccAgrIteminbulkApplyAbilityReqBO.setBatchSkuList(Arrays.asList(uccBatchSkuBO));
                UccAgrIteminbulkApplyAbilityRspBO uccAgrIteminbulkApplyAbilityRspBO = this.uccAgrIteminbulkApplyAbilityService.dealPutOnSelf(uccAgrIteminbulkApplyAbilityReqBO);
                if (!"0000".equals(uccAgrIteminbulkApplyAbilityRspBO.getRespCode())) {
                    log.error("\u7533\u8bf7\u4e0a\u67b6\u5f02\u5e38\uff1a " + uccAgrIteminbulkApplyAbilityRspBO.getRespDesc());
                    continue;
                }
                UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
                try {
                    notifyMessageBO.setAuditStatus("0");
                    notifyMessageBO.setStationCode("0");
                    notifyMessageBO.setAgreementId(reqBO.getAgreementId().toString());
                    notifyMessageBO.setAgreementSkuIds(Arrays.asList(spuBusiReqBO.getAgreementSkuBO().getAgreementSkuId().toString()));
                    notifyMessageBO.setAgreementSkuStatus("0");
                    notifyMessageBO.setMemIdIn(agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO().getProducerId());
                    notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_UP_SHELF.code());
                    log.info("\u521b\u5efa\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
                    this.zoneGoodsAuditMQ.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TOPIC"), PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
                }
                catch (Exception var16) {
                    log.error("\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                    throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
                }
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(Arrays.asList(renewalSpuCombRspBO.getSpuId()));
                syncSceneCommodityToEsReqBO.setSupplierId(renewalSpuCombRspBO.getShopId());
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e2) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
                continue;
            }
            log.error("\u7eed\u7b7e\u534f\u8bae\u6570\u636e\u5f02\u5e38 " + JSONObject.toJSONString((Object)((Object)spuBusiReqBO)) + "errMSG: " + renewalSpuCombRspBO.getRespDesc());
        }
        return combRspBO;
    }
}

