/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.base.wordfilter;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

public class WordNode
implements Serializable {
    private static final long serialVersionUID = -576773041288823967L;
    private int value;
    private List<WordNode> subNodes;
    private boolean isLast;

    public WordNode(int value) {
        this.value = value;
    }

    WordNode(int value, boolean isLast) {
        this.value = value;
        this.isLast = isLast;
    }

    private WordNode addSubNode(WordNode subNode) {
        if (this.subNodes == null) {
            this.subNodes = Lists.newLinkedList();
        }
        this.subNodes.add(subNode);
        return subNode;
    }

    WordNode addIfNoExist(int value, boolean isLast) {
        if (this.subNodes == null) {
            return this.addSubNode(new WordNode(value, isLast));
        }
        for (WordNode subNode : this.subNodes) {
            if (subNode.value != value) continue;
            if (!subNode.isLast && isLast) {
                subNode.isLast = true;
            }
            return subNode;
        }
        return this.addSubNode(new WordNode(value, isLast));
    }

    WordNode querySub(int value) {
        if (this.subNodes == null) {
            return null;
        }
        for (WordNode subNode : this.subNodes) {
            if (subNode.value != value) continue;
            return subNode;
        }
        return null;
    }

    boolean isLast() {
        return this.isLast;
    }

    void setLast() {
        this.isLast = true;
    }

    public int hashCode() {
        return this.value;
    }
}

