/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecEvaluateBrowseBusiService;
import com.tydic.uec.busi.bo.UecEvaluateBrowseBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateBrowseBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaListQryInfo;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.EvaBrowseRecMapper;
import com.tydic.uec.dao.EvaMapper;
import com.tydic.uec.dao.po.EvaBrowseRecPO;
import com.tydic.uec.dao.po.EvaPO;
import com.tydic.uec.utils.RedisUtil;
import com.tydic.uec.utils.UecGenerateIdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UecEvaluateBrowseBusiServiceImpl
implements UecEvaluateBrowseBusiService {
    private final EvaMapper evaMapper;
    private final EvaBrowseRecMapper evaBrowseRecMapper;
    private final UecGenerateIdUtil generateIdUtil;
    private final RedisUtil redisUtil;

    @Autowired
    public UecEvaluateBrowseBusiServiceImpl(EvaMapper evaMapper, EvaBrowseRecMapper evaBrowseRecMapper, RedisUtil redisUtil, UecGenerateIdUtil generateIdUtil) {
        this.evaMapper = evaMapper;
        this.evaBrowseRecMapper = evaBrowseRecMapper;
        this.generateIdUtil = generateIdUtil;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecEvaluateBrowseBusiRspBO dealEvaluateBrowse(UecEvaluateBrowseBusiReqBO reqBO) {
        UecEvaluateBrowseBusiRspBO rspBO = new UecEvaluateBrowseBusiRspBO();
        EvaPO evaPO = this.evaMapper.getModelById(reqBO.getEvaId(), reqBO.getSysTenantId());
        if (evaPO == null) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8bc4\u4ef7\u6d4f\u89c8\u5931\u8d25\uff0c\u8bc4\u4ef7\u4e0d\u5b58\u5728[evaId=" + reqBO.getEvaId() + "]");
            return rspBO;
        }
        EvaBrowseRecPO insertBrowsePO = new EvaBrowseRecPO();
        BeanUtils.copyProperties((Object)reqBO.getEvaBrowseRec(), (Object)insertBrowsePO);
        insertBrowsePO.setId(this.generateIdUtil.nextId());
        insertBrowsePO.setEvaId(reqBO.getEvaId());
        if (insertBrowsePO.getIsAnonymous() == null) {
            insertBrowsePO.setIsAnonymous(UecCommonConstant.AnonymousEnum.NO.value);
        }
        insertBrowsePO.setSysTenantId(reqBO.getSysTenantId());
        insertBrowsePO.setSysTenantName(reqBO.getSysTenantName());
        this.evaBrowseRecMapper.insert(insertBrowsePO);
        Object hashValue = this.redisUtil.hashGet("uec_eva_list_", reqBO.getEvaId().toString());
        if (hashValue != null) {
            EvaListQryInfo evaInfo = (EvaListQryInfo)hashValue;
            evaInfo.setBrowseCount(Integer.valueOf(evaInfo.getBrowseCount() + 1));
            this.redisUtil.hashSet("uec_eva_list_", reqBO.getEvaId().toString(), evaInfo, UecRedisConstant.getExpireMinutes(20, 30));
        }
        this.redisUtil.del("uec_eva_detail_" + evaPO.getSysCode() + evaPO.getBusiSn(), "uec_eva_detail_" + evaPO.getSysCode() + "_busiSn#" + evaPO.getBusiSn());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8bc4\u4ef7\u6d4f\u89c8\u6210\u529f");
        return rspBO;
    }
}

