/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecEvaluateLikeBusiService;
import com.tydic.uec.busi.bo.UecEvaluateLikeBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateLikeBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaListQryInfo;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.EvaMapper;
import com.tydic.uec.dao.EvaThumbUpRecMapper;
import com.tydic.uec.dao.po.EvaPO;
import com.tydic.uec.dao.po.EvaThumbUpRecPO;
import com.tydic.uec.exception.BusinessException;
import com.tydic.uec.utils.RedisUtil;
import com.tydic.uec.utils.UecGenerateIdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UecEvaluateLikeBusiServiceImpl
implements UecEvaluateLikeBusiService {
    private final EvaMapper evaMapper;
    private final EvaThumbUpRecMapper evaThumbUpRecMapper;
    private final UecGenerateIdUtil generateIdUtil;
    private final RedisUtil redisUtil;

    @Autowired
    public UecEvaluateLikeBusiServiceImpl(EvaMapper evaMapper, EvaThumbUpRecMapper evaThumbUpRecMapper, UecGenerateIdUtil generateIdUtil, RedisUtil redisUtil) {
        this.evaMapper = evaMapper;
        this.evaThumbUpRecMapper = evaThumbUpRecMapper;
        this.generateIdUtil = generateIdUtil;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecEvaluateLikeBusiRspBO dealEvaluateLike(UecEvaluateLikeBusiReqBO reqBO) {
        Object hashValue = this.redisUtil.hashGet("uec_eva_list_", reqBO.getEvaId().toString());
        EvaPO evaPO = this.evaMapper.getModelById(reqBO.getEvaId(), reqBO.getSysTenantId());
        if (evaPO == null) {
            throw new BusinessException("2222", "\u8bc4\u4ef7\u70b9\u8d5e\u5931\u8d25\uff0c\u8bc4\u4ef7\u4e0d\u5b58\u5728[evaId=" + reqBO.getEvaId() + "]");
        }
        this.redisUtil.del("uec_eva_detail_" + evaPO.getSysCode() + evaPO.getBusiSn(), "uec_eva_detail_" + evaPO.getSysCode() + "_busiSn#" + evaPO.getBusiSn());
        if (UecCommonConstant.YES_FLAG.equals(reqBO.getCancelFlag())) {
            return this.cancelLike(reqBO, hashValue);
        }
        return this.likeOrNot(reqBO, hashValue, evaPO);
    }

    private UecEvaluateLikeBusiRspBO likeOrNot(UecEvaluateLikeBusiReqBO reqBO, Object hashValue, EvaPO evaPO) {
        UecEvaluateLikeBusiRspBO rspBO = new UecEvaluateLikeBusiRspBO();
        boolean isThumbUp = UecCommonConstant.YES_FLAG.equals(reqBO.getEvaThumbUpRec().getThumbUpType());
        if (isThumbUp) {
            if (UecCommonConstant.ThumbUpEnum.NO.value.equals(evaPO.getIsThumbUp())) {
                rspBO.setRespCode("2222");
                rspBO.setRespDesc("\u8bc4\u4ef7\u70b9\u8d5e\u5931\u8d25\uff0c\u8be5\u8bc4\u4ef7\u4e0d\u5141\u8bb8\u70b9\u8d5e");
                return rspBO;
            }
        } else if (UecCommonConstant.ThumbDownEnum.NO.value.equals(evaPO.getIsThumbDown())) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8bc4\u4ef7\u70b9\u8d5e\u5931\u8d25\uff0c\u8be5\u8bc4\u4ef7\u4e0d\u5141\u8bb8\u8e29");
            return rspBO;
        }
        EvaThumbUpRecPO paramPO = new EvaThumbUpRecPO();
        paramPO.setMemId(reqBO.getEvaThumbUpRec().getMemId());
        paramPO.setThumbUpType(reqBO.getEvaThumbUpRec().getThumbUpType());
        paramPO.setEvaId(reqBO.getEvaId());
        paramPO.setState(UecCommonConstant.StateEnum.YES.value);
        EvaThumbUpRecPO existThumb = this.evaThumbUpRecMapper.getModelBy(paramPO);
        if (existThumb != null) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u5df2\u70b9\u8d5e\u8be5\u8bc4\u4ef7\uff0c\u4e0d\u80fd\u91cd\u590d\u70b9\u8d5e");
            return rspBO;
        }
        EvaThumbUpRecPO insertThumb = new EvaThumbUpRecPO();
        BeanUtils.copyProperties((Object)reqBO.getEvaThumbUpRec(), (Object)insertThumb);
        if (insertThumb.getIsAnonymous() == null) {
            insertThumb.setIsAnonymous(UecCommonConstant.AnonymousEnum.NO.value);
        }
        insertThumb.setState(UecCommonConstant.StateEnum.YES.value);
        insertThumb.setId(this.generateIdUtil.nextId());
        insertThumb.setEvaId(reqBO.getEvaId());
        insertThumb.setSysTenantId(reqBO.getSysTenantId());
        insertThumb.setSysTenantName(reqBO.getSysTenantName());
        this.evaThumbUpRecMapper.insert(insertThumb);
        if (isThumbUp) {
            if (hashValue != null) {
                EvaListQryInfo evaInfo = (EvaListQryInfo)hashValue;
                evaInfo.setLikeCount(Integer.valueOf(evaInfo.getLikeCount() + 1));
                this.redisUtil.hashSet("uec_eva_list_", reqBO.getEvaId().toString(), evaInfo, UecRedisConstant.getExpireMinutes(20, 30));
            }
            this.redisUtil.sSet("uec_eva_like_" + reqBO.getEvaId().toString(), UecRedisConstant.getExpireMinutes(20, 60), reqBO.getEvaThumbUpRec().getMemId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8bc4\u4ef7\u70b9\u8d5e\u6210\u529f");
        return rspBO;
    }

    private UecEvaluateLikeBusiRspBO cancelLike(UecEvaluateLikeBusiReqBO reqBO, Object hashValue) {
        UecEvaluateLikeBusiRspBO rspBO = new UecEvaluateLikeBusiRspBO();
        EvaThumbUpRecPO updateThumb = new EvaThumbUpRecPO();
        updateThumb.setMemId(reqBO.getEvaThumbUpRec().getMemId());
        updateThumb.setThumbUpType(reqBO.getEvaThumbUpRec().getThumbUpType());
        updateThumb.setIpAddr(reqBO.getEvaThumbUpRec().getIpAddr());
        updateThumb.setEvaId(reqBO.getEvaId());
        updateThumb.setState(UecCommonConstant.StateEnum.NO.value);
        int count = this.evaThumbUpRecMapper.updateByPO(updateThumb);
        if (count == 0) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u8be5\u4f1a\u5458\u70b9\u8d5e\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return rspBO;
        }
        if (UecCommonConstant.YES_FLAG.equals(reqBO.getEvaThumbUpRec().getThumbUpType())) {
            if (hashValue != null) {
                EvaListQryInfo evaInfo = (EvaListQryInfo)hashValue;
                evaInfo.setLikeCount(Integer.valueOf(evaInfo.getLikeCount() - 1));
                this.redisUtil.hashSet("uec_eva_list_", reqBO.getEvaId().toString(), evaInfo, UecRedisConstant.getExpireMinutes(20, 30));
            }
            this.redisUtil.sRemove("uec_eva_like_" + reqBO.getEvaId().toString(), reqBO.getEvaThumbUpRec().getMemId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8bc4\u4ef7\u53d6\u6d88\u70b9\u8d5e\u6210\u529f");
        return rspBO;
    }
}

