/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.advice;

import com.tydic.uec.exception.BusinessException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=30)
public class RedisUtilAdvice {
    private static final Logger log = LoggerFactory.getLogger(RedisUtilAdvice.class);

    @Pointcut(value="(execution(* com.tydic.uec.utils.RedisUtil.*(..)))")
    public void pointCut() {
    }

    @Around(value="pointCut()()")
    public Object around(ProceedingJoinPoint pjp) {
        String methodString = pjp.getSignature().getName();
        try {
            return pjp.proceed();
        }
        catch (BusinessException e) {
            throw new BusinessException(e.getMsgCode(), "RedisUtil." + methodString + "()\u65b9\u6cd5\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
        }
        catch (Throwable e) {
            log.error("RedisUtil." + methodString + "()\u65b9\u6cd5\u64cd\u4f5c\u5f02\u5e38", e);
            return null;
        }
    }
}

