/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecAnswerCreateBusiService;
import com.tydic.uec.busi.bo.UecAnswerCreateBusiReqBO;
import com.tydic.uec.busi.bo.UecAnswerCreateBusiRspBO;
import com.tydic.uec.common.bo.answer.AnswerExtBO;
import com.tydic.uec.common.bo.answer.CommodityAnswerBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.AnswerExtMapper;
import com.tydic.uec.dao.CommodityAnswerMapper;
import com.tydic.uec.dao.po.AnswerExtPO;
import com.tydic.uec.dao.po.CommodityAnswerPO;
import com.tydic.uec.utils.RedisUtil;
import com.tydic.uec.utils.UecGenerateIdUtil;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecAnswerCreateBusiServiceImpl
implements UecAnswerCreateBusiService {
    private final CommodityAnswerMapper commodityAnswerMapper;
    private final AnswerExtMapper answerExtMapper;
    private final UecGenerateIdUtil generateIdUtil;
    private final RedisUtil redisUtil;

    @Autowired
    public UecAnswerCreateBusiServiceImpl(CommodityAnswerMapper commodityAnswerMapper, AnswerExtMapper answerExtMapper, UecGenerateIdUtil generateIdUtil, RedisUtil redisUtil) {
        this.commodityAnswerMapper = commodityAnswerMapper;
        this.answerExtMapper = answerExtMapper;
        this.generateIdUtil = generateIdUtil;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecAnswerCreateBusiRspBO createAnswer(UecAnswerCreateBusiReqBO reqBO) {
        CommodityAnswerPO answerPO = new CommodityAnswerPO();
        BeanUtils.copyProperties((Object)reqBO.getAnswerInfo(), (Object)answerPO);
        answerPO.setSysTenantId(reqBO.getSysTenantId());
        answerPO.setSysTenantName(reqBO.getSysTenantName());
        answerPO.setAnswerId(this.generateIdUtil.nextId());
        this.commodityAnswerMapper.insert(answerPO);
        Long answerId = answerPO.getAnswerId();
        if (!CollectionUtils.isEmpty(reqBO.getExtList())) {
            ArrayList<AnswerExtPO> insertList = new ArrayList<AnswerExtPO>(reqBO.getExtList().size());
            for (AnswerExtBO extBO : reqBO.getExtList()) {
                AnswerExtPO extPO = new AnswerExtPO();
                BeanUtils.copyProperties((Object)extBO, (Object)extPO);
                extPO.setId(this.generateIdUtil.nextId());
                extPO.setAnswerId(answerId);
                extPO.setQuestionId(answerPO.getQuestionId());
                extPO.setSysTenantId(reqBO.getSysTenantId());
                extPO.setSysTenantName(reqBO.getSysTenantName());
                insertList.add(extPO);
            }
            this.answerExtMapper.insertBatch(insertList);
        }
        if (UecCommonConstant.StateEnum.YES.value.equals(reqBO.getAnswerInfo().getState())) {
            this.saveAnswerInfoIntoRedis(reqBO, answerId.toString());
        }
        UecAnswerCreateBusiRspBO rspBO = new UecAnswerCreateBusiRspBO();
        rspBO.setAnswerId(answerId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u56de\u7b54\u521b\u5efa\u6210\u529f");
        return rspBO;
    }

    private void saveAnswerInfoIntoRedis(UecAnswerCreateBusiReqBO reqBO, String answerId) {
        String redisKey = "uec_answer_list_" + reqBO.getAnswerInfo().getQuestionId();
        CommodityAnswerBO answerBO = reqBO.getAnswerInfo();
        answerBO.setAnswerId(answerId);
        answerBO.setAnswerTime(new Date());
        if (StringUtils.isNotBlank((String)answerBO.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(answerBO.getIsAnonymous())) {
            answerBO.setMemName(answerBO.getMemName().substring(0, 1) + "***" + answerBO.getMemName().substring(answerBO.getMemName().length() - 1));
        }
        this.redisUtil.hashSet("uec_answer_list_", answerId, answerBO, UecRedisConstant.getExpireMinutes(30, 30));
        this.redisUtil.hashAdd("uec_answer_list_", redisKey + "_totalRecords", 1.0);
        Long answerKeySize = this.redisUtil.zGetSize(redisKey);
        if (answerKeySize != null && answerKeySize > 0L) {
            this.redisUtil.zAdd(redisKey, answerId, System.currentTimeMillis(), UecRedisConstant.getExpireMinutes(30, 10));
        }
    }
}

