/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tydic.uec.atom.UecEvaCreateCheckService;
import com.tydic.uec.atom.bo.UecEvaCreateCheckReqBO;
import com.tydic.uec.atom.bo.UecEvaCreateCheckRspBO;
import com.tydic.uec.busi.UecEvaluateDetailQryBusiService;
import com.tydic.uec.busi.bo.UecEvaluateDetailQryBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateDetailQryBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaAddInfo;
import com.tydic.uec.common.bo.eva.EvaApprovalBO;
import com.tydic.uec.common.bo.eva.EvaBrowseRecBO;
import com.tydic.uec.common.bo.eva.EvaDetailBO;
import com.tydic.uec.common.bo.eva.EvaExtBO;
import com.tydic.uec.common.bo.eva.EvaLabelBO;
import com.tydic.uec.common.bo.eva.EvaPicBO;
import com.tydic.uec.common.bo.eva.EvaStarLevelBO;
import com.tydic.uec.common.bo.eva.EvaThumbUpRecBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.EvaBaseExtMapper;
import com.tydic.uec.dao.EvaBrowseRecMapper;
import com.tydic.uec.dao.EvaExtMapper;
import com.tydic.uec.dao.EvaForwardRecMapper;
import com.tydic.uec.dao.EvaLabelMapper;
import com.tydic.uec.dao.EvaMapper;
import com.tydic.uec.dao.EvaPicMapper;
import com.tydic.uec.dao.EvaStarLevelMapper;
import com.tydic.uec.dao.EvaThumbUpRecMapper;
import com.tydic.uec.dao.UnionQuerySqlMapper;
import com.tydic.uec.dao.po.EvaBaseExtPO;
import com.tydic.uec.dao.po.EvaBrowseRecPO;
import com.tydic.uec.dao.po.EvaExtPO;
import com.tydic.uec.dao.po.EvaForwardRecPO;
import com.tydic.uec.dao.po.EvaLabelPO;
import com.tydic.uec.dao.po.EvaPO;
import com.tydic.uec.dao.po.EvaPicPO;
import com.tydic.uec.dao.po.EvaStarLevelPO;
import com.tydic.uec.dao.po.EvaThumbUpRecPO;
import com.tydic.uec.exception.BusinessException;
import com.tydic.uec.utils.CommonMethodUtil;
import com.tydic.uec.utils.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecEvaluateDetailQryBusiServiceImpl
implements UecEvaluateDetailQryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UecEvaluateDetailQryBusiServiceImpl.class);
    private final RedisUtil redisUtil;
    private final EvaMapper evaMapper;
    private final UecEvaCreateCheckService uecEvaCreateCheckService;
    private final UnionQuerySqlMapper unionQuerySqlMapper;
    private final EvaStarLevelMapper evaStarLevelMapper;
    private final EvaPicMapper evaPicMapper;
    private final EvaLabelMapper evaLabelMapper;
    private final EvaBaseExtMapper evaBaseExtMapper;
    private final EvaExtMapper evaExtMapper;
    private final EvaThumbUpRecMapper evaThumbUpRecMapper;
    private final EvaForwardRecMapper evaForwardRecMapper;
    private final EvaBrowseRecMapper evaBrowseRecMapper;

    @Autowired
    public UecEvaluateDetailQryBusiServiceImpl(RedisUtil redisUtil, EvaMapper evaMapper, UecEvaCreateCheckService uecEvaCreateCheckService, EvaStarLevelMapper evaStarLevelMapper, EvaPicMapper evaPicMapper, EvaLabelMapper evaLabelMapper, EvaBaseExtMapper evaBaseExtMapper, EvaExtMapper evaExtMapper, EvaThumbUpRecMapper evaThumbUpRecMapper, UnionQuerySqlMapper unionQuerySqlMapper, EvaForwardRecMapper evaForwardRecMapper, EvaBrowseRecMapper evaBrowseRecMapper) {
        this.redisUtil = redisUtil;
        this.evaMapper = evaMapper;
        this.uecEvaCreateCheckService = uecEvaCreateCheckService;
        this.unionQuerySqlMapper = unionQuerySqlMapper;
        this.evaStarLevelMapper = evaStarLevelMapper;
        this.evaPicMapper = evaPicMapper;
        this.evaLabelMapper = evaLabelMapper;
        this.evaBaseExtMapper = evaBaseExtMapper;
        this.evaExtMapper = evaExtMapper;
        this.evaThumbUpRecMapper = evaThumbUpRecMapper;
        this.evaForwardRecMapper = evaForwardRecMapper;
        this.evaBrowseRecMapper = evaBrowseRecMapper;
    }

    @Override
    public UecEvaluateDetailQryBusiRspBO qryEvaluateDetail(UecEvaluateDetailQryBusiReqBO reqBO) {
        UecEvaluateDetailQryBusiRspBO rspBO = new UecEvaluateDetailQryBusiRspBO();
        List<EvaPO> evaList = this.getEvaBaseInfo(reqBO.getEvaId(), reqBO.getBusiSn(), reqBO.getSysTenantId());
        this.handleEvaDetail(evaList, rspBO, reqBO.getNeedEvaLikeInfo(), reqBO.getSysTenantId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u8bc4\u4ef7\u8be6\u60c5\u6210\u529f");
        return rspBO;
    }

    private List<EvaPO> handleRedisValue(UecEvaluateDetailQryBusiReqBO reqBO, UecEvaluateDetailQryBusiRspBO rspBO) {
        Object evaBaseInfo;
        ArrayList evaDetailList = Lists.newArrayList();
        List<EvaPO> evaList = this.getEvaBaseInfo(reqBO.getEvaId(), reqBO.getBusiSn(), reqBO.getSysTenantId());
        Map<Object, EvaPO> evaMap = evaList.stream().collect(Collectors.toMap(e -> e.getEvaId().toString(), e -> e));
        String evaDetailKey = "uec_eva_detail_" + reqBO.getSysCode() + "_busiSn#" + reqBO.getBusiSn();
        List<Object> evaDetails = this.redisUtil.hashMultiGet(evaDetailKey, evaMap.keySet());
        if (!CollectionUtils.isEmpty(evaDetails)) {
            for (Object evaDetail : evaDetails) {
                if (evaDetail == null) continue;
                evaDetailList.add((EvaDetailBO)evaDetail);
            }
            if (evaDetailList.size() != evaMap.size()) {
                log.error("\u7f13\u5b58\u4e0d\u4e00\u81f4\uff0c\u5f00\u59cb\u67e5\u8868");
                this.redisUtil.del(evaDetailKey);
                ArrayList qryEvaList = Lists.newArrayList();
                qryEvaList.addAll(evaMap.values());
                return qryEvaList;
            }
            String evaBaseKey = "uec_eva_detail_" + reqBO.getSysCode() + reqBO.getBusiSn();
            evaBaseInfo = this.redisUtil.get(evaBaseKey);
            int refreshMin = 10;
            if (this.redisUtil.getExpire(evaDetailKey) < (long)refreshMin) {
                int expireMin = UecRedisConstant.getExpireMinutes(60, 5);
                this.redisUtil.expire(evaBaseKey, expireMin);
                this.redisUtil.expire(evaDetailKey, expireMin);
            }
        } else {
            ArrayList qryEvaList = Lists.newArrayList();
            qryEvaList.addAll(evaMap.values());
            return qryEvaList;
        }
        BeanUtils.copyProperties((Object)evaBaseInfo, (Object)((Object)rspBO));
        rspBO.setEvaDetailList(evaDetailList);
        return null;
    }

    private List<EvaPO> getEvaBaseInfo(Long evaId, String busiSn, Long sysTenantId) {
        List<Object> evaList = Lists.newArrayList();
        if (evaId != null) {
            EvaPO evaPO = this.evaMapper.getModelById(evaId, sysTenantId);
            evaList.add(evaPO);
        } else {
            EvaPO paramPO = new EvaPO();
            paramPO.setBusiSn(busiSn);
            evaList = this.evaMapper.getList(paramPO);
        }
        if (CollectionUtils.isEmpty((Collection)evaList)) {
            throw new BusinessException("2222", "\u67e5\u8be2\u8bc4\u4ef7\u8be6\u60c5\u5931\u8d25\uff0c\u8bc4\u4ef7\u4e0d\u5b58\u5728");
        }
        return evaList;
    }

    private Map<String, Object> handleEvaDetail(List<EvaPO> evaList, UecEvaluateDetailQryBusiRspBO rspBO, Integer needEvaLikeInfo, Long sysTenantId) {
        ArrayList evaDetailList = Lists.newArrayList();
        HashMap hashMap = Maps.newHashMap();
        for (EvaPO evaPO : evaList) {
            Long evaId = evaPO.getEvaId();
            EvaDetailBO evaDetailBO = new EvaDetailBO();
            BeanUtils.copyProperties((Object)evaPO, (Object)evaDetailBO);
            if (StringUtils.isNotBlank((CharSequence)evaPO.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(evaPO.getIsAnonymous())) {
                rspBO.setMemName(evaPO.getMemName().substring(0, 1) + "***" + evaPO.getMemName().substring(evaPO.getMemName().length() - 1));
            }
            EvaAddInfo evaAddInfo = this.unionQuerySqlMapper.qryAddEvaInfo(evaId, sysTenantId);
            evaDetailBO.setIsAddEva(UecCommonConstant.NO_FLAG);
            if (evaAddInfo == null) {
                UecEvaCreateCheckReqBO checkReqBO = new UecEvaCreateCheckReqBO();
                checkReqBO.setAddEva(true);
                checkReqBO.setReviewLen(evaPO.getReviewLen());
                checkReqBO.setEvaTime(evaPO.getEvaTime());
                checkReqBO.setSysTenantId(sysTenantId);
                UecEvaCreateCheckRspBO checkRspBO = this.uecEvaCreateCheckService.checkEvaValid(checkReqBO);
                if ("0000".equals(checkRspBO.getRespCode())) {
                    evaDetailBO.setIsAddEva(UecCommonConstant.YES_FLAG);
                }
            } else {
                int intervalDays = CommonMethodUtil.getDay(evaPO.getEvaTime(), evaAddInfo.getEvaTime());
                evaAddInfo.setIntervalDays(Integer.valueOf(intervalDays));
                EvaApprovalBO evaApprovalBO = this.unionQuerySqlMapper.qryEvaluateApprovalInfoByEvaId(evaId, sysTenantId);
                evaAddInfo.setAuditStatus(evaApprovalBO.getEvaState());
                evaAddInfo.setAuditStatusStr(UecCommonConstant.AuditStateEnum.valueOf((int)evaApprovalBO.getEvaState().intValue()).desc);
                evaDetailBO.setAddEvaInfo(evaAddInfo);
            }
            EvaBaseExtPO evaBaseExtPO = new EvaBaseExtPO();
            evaBaseExtPO.setEvaId(evaId);
            evaBaseExtPO = this.evaBaseExtMapper.getModelBy(evaBaseExtPO);
            if (evaBaseExtPO != null) {
                evaDetailBO.setEvaContent(evaBaseExtPO.getEvaContent());
            }
            this.qryStarLevelList(evaId, evaDetailBO);
            this.qryPicList(evaId, evaDetailBO);
            this.qryLabelList(evaId, evaDetailBO);
            this.qryExtList(evaId, evaDetailBO);
            this.qryLikeInfo(evaId, UecCommonConstant.YES_FLAG.equals(needEvaLikeInfo), evaDetailBO);
            this.qryAuditInfo(evaId, evaDetailBO, sysTenantId);
            evaDetailList.add(evaDetailBO);
            hashMap.put(evaId.toString(), evaDetailBO);
        }
        BeanUtils.copyProperties((Object)evaList.get(0), (Object)((Object)rspBO));
        rspBO.setEvaDetailList(evaDetailList);
        return hashMap;
    }

    private void qryAuditInfo(Long evaId, EvaDetailBO evaDetailBO, Long sysTenantId) {
        EvaApprovalBO evaApprovalBO = this.unionQuerySqlMapper.qryEvaluateApprovalInfoByEvaId(evaId, sysTenantId);
        if (null != evaApprovalBO) {
            evaDetailBO.setAuditStatus(evaApprovalBO.getEvaState());
            evaDetailBO.setAuditStatusStr(UecCommonConstant.AuditStateEnum.valueOf((int)evaApprovalBO.getEvaState().intValue()).desc);
        }
    }

    private void qryStarLevelList(Long evaId, EvaDetailBO evaDetailBO) {
        EvaStarLevelPO starLevelParam = new EvaStarLevelPO();
        starLevelParam.setEvaId(evaId);
        List<EvaStarLevelPO> starLevelPOList = this.evaStarLevelMapper.getList(starLevelParam);
        if (!CollectionUtils.isEmpty(starLevelPOList)) {
            ArrayList<EvaStarLevelBO> starLevelList = new ArrayList<EvaStarLevelBO>(starLevelPOList.size());
            for (EvaStarLevelPO starLevelPO : starLevelPOList) {
                EvaStarLevelBO starLevel = new EvaStarLevelBO();
                BeanUtils.copyProperties((Object)starLevelPO, (Object)starLevel);
                starLevelList.add(starLevel);
            }
            evaDetailBO.setStarLevelList(starLevelList);
        }
    }

    private void qryPicList(Long evaId, EvaDetailBO evaDetailBO) {
        EvaPicPO evaPicParam = new EvaPicPO();
        evaPicParam.setEvaId(evaId);
        evaPicParam.setOrderBy("sort");
        List<EvaPicPO> picPOList = this.evaPicMapper.getList(evaPicParam);
        if (!CollectionUtils.isEmpty(picPOList)) {
            ArrayList<EvaPicBO> picList = new ArrayList<EvaPicBO>(picPOList.size());
            for (EvaPicPO evaPicPO : picPOList) {
                EvaPicBO evaPic = new EvaPicBO();
                BeanUtils.copyProperties((Object)evaPicPO, (Object)evaPic);
                picList.add(evaPic);
            }
            evaDetailBO.setPicList(picList);
        }
    }

    private void qryLabelList(Long evaId, EvaDetailBO evaDetailBO) {
        EvaLabelPO evaLabelParam = new EvaLabelPO();
        evaLabelParam.setEvaId(evaId);
        List<EvaLabelPO> labelPOList = this.evaLabelMapper.getList(evaLabelParam);
        if (!CollectionUtils.isEmpty(labelPOList)) {
            ArrayList<EvaLabelBO> labelList = new ArrayList<EvaLabelBO>(labelPOList.size());
            for (EvaLabelPO evaLabelPO : labelPOList) {
                EvaLabelBO evaLabel = new EvaLabelBO();
                BeanUtils.copyProperties((Object)evaLabelPO, (Object)evaLabel);
                labelList.add(evaLabel);
            }
            evaDetailBO.setLabelList(labelList);
        }
    }

    private void qryExtList(Long evaId, EvaDetailBO evaDetailBO) {
        EvaExtPO evaExtParam = new EvaExtPO();
        evaExtParam.setEvaId(evaId);
        List<EvaExtPO> extPOList = this.evaExtMapper.getList(evaExtParam);
        if (!CollectionUtils.isEmpty(extPOList)) {
            ArrayList<EvaExtBO> extList = new ArrayList<EvaExtBO>(extPOList.size());
            for (EvaExtPO evaExtPO : extPOList) {
                EvaExtBO evaExt = new EvaExtBO();
                BeanUtils.copyProperties((Object)evaExtPO, (Object)evaExt);
                extList.add(evaExt);
            }
            evaDetailBO.setExtList(extList);
        }
    }

    private void qryLikeInfo(Long evaId, Boolean qryLikeInfo, EvaDetailBO evaDetailBO) {
        EvaThumbUpRecPO thumbUpRecParam = new EvaThumbUpRecPO();
        thumbUpRecParam.setEvaId(evaId);
        thumbUpRecParam.setState(UecCommonConstant.StateEnum.YES.value);
        EvaForwardRecPO forwardRecParam = new EvaForwardRecPO();
        forwardRecParam.setEvaId(evaId);
        EvaBrowseRecPO browseRecParam = new EvaBrowseRecPO();
        browseRecParam.setEvaId(evaId);
        int thumbUpCount = 0;
        int thumbDownCount = 0;
        int forwardCount = 0;
        if (qryLikeInfo.booleanValue()) {
            List<EvaBrowseRecPO> browsePOList;
            List<EvaForwardRecPO> forwardPOList;
            List<EvaThumbUpRecPO> thumbPOList = this.evaThumbUpRecMapper.getList(thumbUpRecParam);
            if (!CollectionUtils.isEmpty(thumbPOList)) {
                thumbUpCount = (int)thumbPOList.stream().filter(e -> UecCommonConstant.ThumbUpEnum.YES.value.equals(e.getThumbUpType())).count();
                thumbDownCount = thumbPOList.size() - thumbUpCount;
                this.handleThumbList(thumbPOList, evaDetailBO);
            }
            if (!CollectionUtils.isEmpty(forwardPOList = this.evaForwardRecMapper.getList(forwardRecParam))) {
                forwardCount = forwardPOList.size();
                this.handleForwardList(forwardPOList, evaDetailBO);
            }
            if (!CollectionUtils.isEmpty(browsePOList = this.evaBrowseRecMapper.getList(browseRecParam))) {
                this.handleBrowseList(browsePOList, evaDetailBO);
            }
        } else {
            thumbUpRecParam.setThumbUpType(UecCommonConstant.ThumbUpEnum.YES.value);
            thumbUpCount = this.evaThumbUpRecMapper.getCountBy(thumbUpRecParam);
            forwardCount = this.evaForwardRecMapper.getCountBy(forwardRecParam);
        }
        evaDetailBO.setThumbUpCount(Integer.valueOf(thumbUpCount));
        evaDetailBO.setThumbDownCount(Integer.valueOf(thumbDownCount));
        evaDetailBO.setForwardCount(Integer.valueOf(forwardCount));
    }

    private void handleThumbList(List<EvaThumbUpRecPO> thumbPOList, EvaDetailBO evaDetailBO) {
        ArrayList<EvaThumbUpRecBO> thumbList = new ArrayList<EvaThumbUpRecBO>(thumbPOList.size());
        for (EvaThumbUpRecPO thumbUpRecPO : thumbPOList) {
            EvaThumbUpRecBO thumbBO = new EvaThumbUpRecBO();
            BeanUtils.copyProperties((Object)thumbUpRecPO, (Object)thumbBO);
            if (StringUtils.isNotBlank((CharSequence)thumbUpRecPO.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(thumbUpRecPO.getIsAnonymous())) {
                thumbBO.setMemName(thumbUpRecPO.getMemName().substring(0, 1) + "***" + thumbUpRecPO.getMemName().substring(thumbUpRecPO.getMemName().length() - 1));
            }
            thumbList.add(thumbBO);
        }
        evaDetailBO.setThumbList(thumbList);
    }

    private void handleForwardList(List<EvaForwardRecPO> forwardPOList, EvaDetailBO evaDetailBO) {
        ArrayList<EvaBrowseRecBO> forwardList = new ArrayList<EvaBrowseRecBO>(forwardPOList.size());
        for (EvaForwardRecPO forwardRecPO : forwardPOList) {
            EvaBrowseRecBO forwardBO = new EvaBrowseRecBO();
            BeanUtils.copyProperties((Object)forwardRecPO, (Object)forwardBO);
            if (StringUtils.isNotBlank((CharSequence)forwardRecPO.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(forwardRecPO.getIsAnonymous())) {
                forwardBO.setMemName(forwardRecPO.getMemName().substring(0, 1) + "***" + forwardRecPO.getMemName().substring(forwardRecPO.getMemName().length() - 1));
            }
            forwardList.add(forwardBO);
        }
        evaDetailBO.setForwardList(forwardList);
    }

    private void handleBrowseList(List<EvaBrowseRecPO> browsePOList, EvaDetailBO evaDetailBO) {
        ArrayList<EvaBrowseRecBO> browseList = new ArrayList<EvaBrowseRecBO>(browsePOList.size());
        for (EvaBrowseRecPO browseRecPO : browsePOList) {
            EvaBrowseRecBO browseBO = new EvaBrowseRecBO();
            BeanUtils.copyProperties((Object)browseRecPO, (Object)browseBO);
            if (StringUtils.isNotBlank((CharSequence)browseRecPO.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(browseRecPO.getIsAnonymous())) {
                browseBO.setMemName(browseRecPO.getMemName().substring(0, 1) + "***" + browseRecPO.getMemName().substring(browseRecPO.getMemName().length() - 1));
            }
            browseList.add(browseBO);
        }
        evaDetailBO.setBrowseList(browseList);
    }
}

