/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.google.common.collect.Maps;
import com.tydic.uec.busi.UecEvaluateRecordBusiService;
import com.tydic.uec.busi.bo.UecEvaluateRecordBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateRecordBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaLabelBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.EvaLabelMapper;
import com.tydic.uec.dao.po.EvaLabelPO;
import com.tydic.uec.exception.BusinessException;
import com.tydic.uec.utils.RedisUtil;
import com.tydic.uec.utils.UecGenerateIdUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UecEvaluateRecordBusiServiceImpl
implements UecEvaluateRecordBusiService {
    private final EvaLabelMapper evaLabelMapper;
    private final UecGenerateIdUtil generateIdUtil;
    private final RedisUtil redisUtil;

    @Autowired
    public UecEvaluateRecordBusiServiceImpl(EvaLabelMapper evaLabelMapper, UecGenerateIdUtil generateIdUtil, RedisUtil redisUtil) {
        this.evaLabelMapper = evaLabelMapper;
        this.generateIdUtil = generateIdUtil;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecEvaluateRecordBusiRspBO dealDataRecord(UecEvaluateRecordBusiReqBO reqBO) {
        if (!UecCommonConstant.StatsType.LABEL.equals(reqBO.getRecordType())) {
            throw new BusinessException("2222", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b[recordType]");
        }
        this.insertLabelList(reqBO.getLabelList(), reqBO.getEvaId(), reqBO.getObjId(), reqBO);
        this.handelLabelRedisUpdate(reqBO);
        UecEvaluateRecordBusiRspBO rspBO = new UecEvaluateRecordBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8bc4\u4ef7\u6570\u636e\u8bb0\u5f55\u6210\u529f");
        return rspBO;
    }

    private void insertLabelList(List<EvaLabelBO> labelList, Long evaId, String objId, UecEvaluateRecordBusiReqBO reqBO) {
        ArrayList<EvaLabelPO> insertList = new ArrayList<EvaLabelPO>(labelList.size());
        for (EvaLabelBO evaLabel : labelList) {
            EvaLabelPO insertPo = new EvaLabelPO();
            BeanUtils.copyProperties((Object)evaLabel, (Object)insertPo);
            insertPo.setId(this.generateIdUtil.nextId());
            insertPo.setEvaId(evaId);
            insertPo.setLabelValue(objId);
            insertPo.setSysTenantId(reqBO.getSysTenantId());
            insertPo.setSysTenantName(reqBO.getSysTenantName());
            insertList.add(insertPo);
        }
        this.evaLabelMapper.insertBatch(insertList);
    }

    private void handelLabelRedisUpdate(UecEvaluateRecordBusiReqBO reqBO) {
        String objSuffix = reqBO.getSysCode() + "_objType#" + reqBO.getObjType() + "_objId#" + reqBO.getObjId();
        String objKey = "uec_eva_list_" + objSuffix;
        String labelCountKey = objSuffix + "_label";
        HashMap saveMap = Maps.newHashMapWithExpectedSize((int)reqBO.getLabelList().size());
        for (EvaLabelBO label : reqBO.getLabelList()) {
            EvaLabelBO labelCount;
            Object hashValue;
            String labelKey = objKey + "_label#" + label.getLabelCode();
            this.redisUtil.hashAdd("uec_eva_list_", labelKey + "_totalRecords", 1.0);
            Long objKeySize = this.redisUtil.zGetSize(objKey);
            if (objKeySize != null && objKeySize > 0L) {
                this.redisUtil.zAdd(labelKey, reqBO.getEvaId(), System.currentTimeMillis(), UecRedisConstant.getExpireMinutes(20, 10));
            }
            if ((hashValue = this.redisUtil.hashGet(labelCountKey, label.getLabelCode())) != null) {
                labelCount = (EvaLabelBO)hashValue;
                labelCount.setEvaCount(Integer.valueOf(labelCount.getEvaCount() + 1));
            } else {
                labelCount = new EvaLabelBO();
                BeanUtils.copyProperties((Object)label, (Object)labelCount);
                labelCount.setLabelValue(reqBO.getObjId());
                labelCount.setEvaCount(Integer.valueOf(1));
            }
            saveMap.put(label.getLabelCode(), labelCount);
        }
        this.redisUtil.hashDel(labelCountKey, "empty_data");
        this.redisUtil.hashMapSet(labelCountKey, saveMap, UecRedisConstant.getExpireMinutes(60, 30));
    }
}

