/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.atom.UecAnswerListQryAtomService;
import com.tydic.uec.atom.bo.UecAnswerListQryAtomReqBO;
import com.tydic.uec.atom.bo.UecAnswerListQryAtomRspBO;
import com.tydic.uec.busi.UecQuestionDetailQryBusiService;
import com.tydic.uec.busi.bo.UecQuestionDetailQryBusiReqBO;
import com.tydic.uec.busi.bo.UecQuestionDetailQryBusiRspBO;
import com.tydic.uec.common.bo.answer.AnswerBrowseRecBO;
import com.tydic.uec.common.bo.answer.AnswerExtBO;
import com.tydic.uec.common.bo.answer.AnswerFollowRecBO;
import com.tydic.uec.common.bo.answer.CommodityQuestionBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.dao.AnswerBrowseRecMapper;
import com.tydic.uec.dao.AnswerExtMapper;
import com.tydic.uec.dao.AnswerFollowRecMapper;
import com.tydic.uec.dao.CommodityQuestionMapper;
import com.tydic.uec.dao.po.AnswerBrowseRecPO;
import com.tydic.uec.dao.po.AnswerExtPO;
import com.tydic.uec.dao.po.AnswerFollowRecPO;
import com.tydic.uec.dao.po.CommodityQuestionPO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecQuestionDetailQryBusiServiceImpl
implements UecQuestionDetailQryBusiService {
    private final CommodityQuestionMapper commodityQuestionMapper;
    private final AnswerExtMapper answerExtMapper;
    private final UecAnswerListQryAtomService uecAnswerListQryAtomService;
    private final AnswerFollowRecMapper answerFollowRecMapper;
    private final AnswerBrowseRecMapper answerBrowseRecMapper;

    @Autowired
    public UecQuestionDetailQryBusiServiceImpl(CommodityQuestionMapper commodityQuestionMapper, AnswerExtMapper answerExtMapper, UecAnswerListQryAtomService uecAnswerListQryAtomService, AnswerFollowRecMapper answerFollowRecMapper, AnswerBrowseRecMapper answerBrowseRecMapper) {
        this.commodityQuestionMapper = commodityQuestionMapper;
        this.answerExtMapper = answerExtMapper;
        this.uecAnswerListQryAtomService = uecAnswerListQryAtomService;
        this.answerFollowRecMapper = answerFollowRecMapper;
        this.answerBrowseRecMapper = answerBrowseRecMapper;
    }

    @Override
    public UecQuestionDetailQryBusiRspBO qryQuestionDetail(UecQuestionDetailQryBusiReqBO reqBO) {
        UecQuestionDetailQryBusiRspBO rspBO = new UecQuestionDetailQryBusiRspBO();
        Long questionId = reqBO.getQuestionId();
        CommodityQuestionPO questionPO = this.commodityQuestionMapper.getModelById(questionId, reqBO.getSysTenantId());
        if (questionPO == null) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u67e5\u8be2\u95ee\u9898\u8be6\u60c5\u5931\u8d25\uff0c\u95ee\u9898\u4e0d\u5b58\u5728[questionId=" + questionId + "]");
            return rspBO;
        }
        CommodityQuestionBO questionInfo = new CommodityQuestionBO();
        BeanUtils.copyProperties((Object)questionPO, (Object)questionInfo);
        questionInfo.setQuestionId(questionPO.getQuestionId().toString());
        UecAnswerListQryAtomReqBO atomReqBO = new UecAnswerListQryAtomReqBO();
        atomReqBO.setQuestionId(questionId);
        atomReqBO.setState(UecCommonConstant.StateEnum.YES.value);
        atomReqBO.setPageNo(reqBO.getPageNo());
        atomReqBO.setPageSize(reqBO.getPageSize());
        UecAnswerListQryAtomRspBO atomRspBO = this.uecAnswerListQryAtomService.qryAnswerList(atomReqBO);
        questionInfo.setAnswerList(atomRspBO.getRows());
        questionInfo.setAnswerRecords(atomRspBO.getTotalRecords());
        questionInfo.setAnswerPages(atomRspBO.getTotalPages());
        rspBO.setQuestionInfo(questionInfo);
        this.qryQuestionExtList(questionId, rspBO);
        this.qryFollowInfo(questionId, UecCommonConstant.YES_FLAG.equals(reqBO.getNeedFollowInfo()), rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u95ee\u9898\u8be6\u60c5\u6210\u529f");
        return rspBO;
    }

    private void qryQuestionExtList(Long questionId, UecQuestionDetailQryBusiRspBO rspBO) {
        AnswerExtPO extParam = new AnswerExtPO();
        extParam.setQuestionId(questionId);
        List<AnswerExtPO> extPOList = this.answerExtMapper.getList(extParam);
        if (!CollectionUtils.isEmpty(extPOList)) {
            ArrayList<AnswerExtBO> extList = new ArrayList<AnswerExtBO>(extPOList.size());
            for (AnswerExtPO extPO : extPOList) {
                AnswerExtBO extBO = new AnswerExtBO();
                BeanUtils.copyProperties((Object)extPO, (Object)extBO);
                extList.add(extBO);
            }
            rspBO.setExtList(extList);
        }
    }

    private void qryFollowInfo(Long questionId, boolean qryDetail, UecQuestionDetailQryBusiRspBO rspBO) {
        AnswerFollowRecPO followParam = new AnswerFollowRecPO();
        followParam.setQuestionId(questionId);
        followParam.setState(UecCommonConstant.StateEnum.YES.value);
        int followCount = 0;
        if (qryDetail) {
            List<AnswerFollowRecPO> followPOList = this.answerFollowRecMapper.getList(followParam);
            if (!CollectionUtils.isEmpty(followPOList)) {
                followCount = followPOList.size();
                ArrayList<AnswerFollowRecBO> followList = new ArrayList<AnswerFollowRecBO>(followCount);
                for (AnswerFollowRecPO followRecPO : followPOList) {
                    AnswerFollowRecBO followBO = new AnswerFollowRecBO();
                    BeanUtils.copyProperties((Object)followRecPO, (Object)followBO);
                    followList.add(followBO);
                }
                rspBO.setFollowList(followList);
            }
            AnswerBrowseRecPO browseRecParam = new AnswerBrowseRecPO();
            browseRecParam.setQuestionId(questionId);
            List<AnswerBrowseRecPO> browsePOList = this.answerBrowseRecMapper.getList(browseRecParam);
            if (!CollectionUtils.isEmpty(browsePOList)) {
                ArrayList<AnswerBrowseRecBO> browseList = new ArrayList<AnswerBrowseRecBO>(browsePOList.size());
                for (AnswerBrowseRecPO browseRecPO : browsePOList) {
                    AnswerBrowseRecBO browseBO = new AnswerBrowseRecBO();
                    BeanUtils.copyProperties((Object)browseRecPO, (Object)browseBO);
                    browseList.add(browseBO);
                }
                rspBO.setBrowseList(browseList);
            }
        } else {
            followCount = this.answerFollowRecMapper.getCountBy(followParam);
        }
        rspBO.setFollowCount(followCount);
    }
}

