/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.google.common.collect.Sets;
import com.tydic.uec.busi.UecReplyCreateBusiService;
import com.tydic.uec.busi.bo.UecReplyCreateBusiReqBO;
import com.tydic.uec.busi.bo.UecReplyCreateBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaListQryInfo;
import com.tydic.uec.common.bo.reply.ReplyBO;
import com.tydic.uec.common.bo.reply.ReplyExtBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.ReplyExtMapper;
import com.tydic.uec.dao.ReplyMapper;
import com.tydic.uec.dao.po.ReplyExtPO;
import com.tydic.uec.dao.po.ReplyPO;
import com.tydic.uec.utils.RedisUtil;
import com.tydic.uec.utils.UecGenerateIdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecReplyCreateBusiServiceImpl
implements UecReplyCreateBusiService {
    private final ReplyMapper replyMapper;
    private final ReplyExtMapper replyExtMapper;
    private final UecGenerateIdUtil generateIdUtil;
    private final RedisUtil redisUtil;

    @Autowired
    public UecReplyCreateBusiServiceImpl(ReplyMapper replyMapper, ReplyExtMapper replyExtMapper, UecGenerateIdUtil generateIdUtil, RedisUtil redisUtil) {
        this.replyMapper = replyMapper;
        this.replyExtMapper = replyExtMapper;
        this.generateIdUtil = generateIdUtil;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecReplyCreateBusiRspBO createReplyInfo(UecReplyCreateBusiReqBO reqBO) {
        ReplyPO replyPO = new ReplyPO();
        BeanUtils.copyProperties((Object)reqBO.getReplyInfo(), (Object)replyPO);
        replyPO.setReplyId(this.generateIdUtil.nextId());
        replyPO.setSysTenantId(reqBO.getSysTenantId());
        replyPO.setSysTenantName(reqBO.getSysTenantName());
        this.replyMapper.insert(replyPO);
        Long replyId = replyPO.getReplyId();
        if (!CollectionUtils.isEmpty(reqBO.getReplyExtList())) {
            ArrayList<ReplyExtPO> insertList = new ArrayList<ReplyExtPO>(reqBO.getReplyExtList().size());
            for (ReplyExtBO replyExtBO : reqBO.getReplyExtList()) {
                ReplyExtPO replyExtPO = new ReplyExtPO();
                BeanUtils.copyProperties((Object)replyExtBO, (Object)replyExtPO);
                replyExtPO.setId(this.generateIdUtil.nextId());
                replyExtPO.setReplyId(replyId);
                replyExtPO.setSysTenantId(reqBO.getSysTenantId());
                replyExtPO.setSysTenantName(reqBO.getSysTenantName());
                insertList.add(replyExtPO);
            }
            this.replyExtMapper.insertBatch(insertList);
        }
        if (UecCommonConstant.StateEnum.YES.value.equals(reqBO.getReplyInfo().getReplyState())) {
            if (UecCommonConstant.ReplyType.EVALUATE.equals(reqBO.getReplyInfo().getObjType())) {
                this.updateEvaHashValue(reqBO.getReplyInfo().getObjId());
            }
            if (reqBO.getReplyInfo().getUpperReplyId() != null) {
                this.addUpperReplyToRedis(replyPO);
            } else {
                this.saveReplyInfoIntoRedis(reqBO, replyPO);
            }
        }
        UecReplyCreateBusiRspBO rspBO = new UecReplyCreateBusiRspBO();
        rspBO.setReplyId(replyId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u521b\u5efa\u8bc4\u8bba\u6210\u529f");
        return rspBO;
    }

    private void updateEvaHashValue(String evaId) {
        Object hashValue = this.redisUtil.hashGet("uec_eva_list_", evaId);
        if (hashValue != null) {
            EvaListQryInfo evaInfo = (EvaListQryInfo)hashValue;
            evaInfo.setReplyCount(Integer.valueOf(evaInfo.getReplyCount() + 1));
            this.redisUtil.hashSet("uec_eva_list_", evaId, evaInfo, UecRedisConstant.getExpireMinutes(20, 30));
        }
    }

    private void saveReplyInfoIntoRedis(UecReplyCreateBusiReqBO reqBO, ReplyPO replyPO) {
        String memKey = "uec_reply_list_" + replyPO.getSysCode() + "_memId#" + replyPO.getMemId();
        String objKey = "uec_reply_list_" + replyPO.getSysCode() + "_objType#" + replyPO.getObjType() + "_objId#" + replyPO.getObjId();
        ReplyBO replyInfo = new ReplyBO();
        BeanUtils.copyProperties((Object)replyPO, (Object)replyInfo);
        replyInfo.setReplyId(replyPO.getReplyId().toString());
        replyInfo.setReplyTime(new Date());
        replyInfo.setThumbUpCount(Integer.valueOf(0));
        this.redisUtil.hashSet("uec_reply_list_", replyInfo.getReplyId(), replyInfo, UecRedisConstant.getExpireMinutes(10, 30));
        this.redisUtil.hashAdd("uec_reply_list_", memKey + "_totalRecords", 1.0);
        this.redisUtil.hashAdd("uec_reply_list_", objKey + "_totalRecords", 1.0);
        Long memKeySize = this.redisUtil.zGetSize(memKey);
        Long objKeySize = this.redisUtil.zGetSize(objKey);
        if (memKeySize != null && memKeySize > 0L) {
            this.redisUtil.zAdd(memKey, replyInfo.getReplyId(), System.currentTimeMillis(), UecRedisConstant.getExpireMinutes(10, 10));
        }
        if (objKeySize != null && objKeySize > 0L) {
            this.redisUtil.zAdd(objKey, replyInfo.getReplyId(), System.currentTimeMillis(), UecRedisConstant.getExpireMinutes(10, 10));
        }
    }

    private void addUpperReplyToRedis(ReplyPO replyPO) {
        ReplyBO replyInfo = new ReplyBO();
        BeanUtils.copyProperties((Object)replyPO, (Object)replyInfo);
        replyInfo.setReplyId(replyPO.getReplyId().toString());
        replyInfo.setReplyTime(new Date());
        replyInfo.setThumbUpCount(Integer.valueOf(0));
        this.redisUtil.hashSet("uec_reply_list_", replyInfo.getReplyId(), replyInfo, UecRedisConstant.getExpireMinutes(10, 30));
        Object childHashSet = this.redisUtil.hashGet("uec_reply_child_ids_", replyInfo.getUpperReplyId().toString());
        Set childReplyIds = childHashSet != null ? (Set)childHashSet : Sets.newHashSetWithExpectedSize((int)30);
        childReplyIds.add(replyInfo.getReplyId());
        this.redisUtil.hashSet("uec_reply_child_ids_", replyInfo.getUpperReplyId().toString(), childReplyIds, UecRedisConstant.getExpireMinutes(10, 60));
    }
}

