/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecReplyUpdateBusiService;
import com.tydic.uec.busi.bo.UecReplyUpdateBusiReqBO;
import com.tydic.uec.busi.bo.UecReplyUpdateBusiRspBO;
import com.tydic.uec.common.bo.reply.ReplyBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.ReplyMapper;
import com.tydic.uec.dao.po.ReplyPO;
import com.tydic.uec.utils.RedisUtil;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UecReplyUpdateBusiServiceImpl
implements UecReplyUpdateBusiService {
    private final ReplyMapper replyMapper;
    private final RedisUtil redisUtil;

    @Autowired
    public UecReplyUpdateBusiServiceImpl(ReplyMapper replyMapper, RedisUtil redisUtil) {
        this.replyMapper = replyMapper;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecReplyUpdateBusiRspBO updateReplyInfo(UecReplyUpdateBusiReqBO reqBO) {
        ReplyPO updateReply = new ReplyPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getReplyContent())) {
            updateReply.setReplyContent(reqBO.getReplyContent());
        }
        if (reqBO.getReplyState() != null) {
            updateReply.setReplyState(reqBO.getReplyState());
        }
        updateReply.setReplyId(reqBO.getReplyId());
        int count = this.replyMapper.updateById(updateReply);
        UecReplyUpdateBusiRspBO rspBO = new UecReplyUpdateBusiRspBO();
        if (count != 1) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u4fee\u6539\u8bc4\u8bba\u5931\u8d25\uff0c\u8be5\u8bc4\u8bba\u4e0d\u5b58\u5728");
            return rspBO;
        }
        this.updateHashValue(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u8bc4\u8bba\u6210\u529f");
        return rspBO;
    }

    private void updateHashValue(UecReplyUpdateBusiReqBO reqBO) {
        String replyId = reqBO.getReplyId().toString();
        Object hashValue = this.redisUtil.hashGet("uec_reply_list_", replyId);
        if (hashValue == null) {
            return;
        }
        ReplyBO replyInfo = (ReplyBO)hashValue;
        if (reqBO.getReplyState() != null && !UecCommonConstant.StateEnum.YES.value.equals(reqBO.getReplyState())) {
            Object childHashSet;
            this.redisUtil.hashDel("uec_reply_list_", replyId);
            if (replyInfo.getUpperReplyId() != null && (childHashSet = this.redisUtil.hashGet("uec_reply_child_ids_", replyInfo.getUpperReplyId().toString())) != null) {
                Set childReplyIds = (Set)childHashSet;
                childReplyIds.remove(replyInfo.getReplyId());
                this.redisUtil.hashSet("uec_reply_child_ids_", replyInfo.getUpperReplyId().toString(), childReplyIds, UecRedisConstant.getExpireMinutes(10, 60));
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getReplyContent())) {
            replyInfo.setReplyContent(reqBO.getReplyContent());
        }
        this.redisUtil.hashSet("uec_reply_list_", replyId, replyInfo, UecRedisConstant.getExpireMinutes(10, 30));
    }
}

