/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.impl;

import com.tydic.uec.ability.UecEvaluateRecordAbilityService;
import com.tydic.uec.ability.bo.UecEvaluateRecordAbilityReqBO;
import com.tydic.uec.ability.bo.UecEvaluateRecordAbilityRspBO;
import com.tydic.uec.busi.UecEvaluateRecordBusiService;
import com.tydic.uec.busi.bo.UecEvaluateRecordBusiReqBO;
import com.tydic.uec.common.bo.eva.EvaDataStatsBO;
import com.tydic.uec.common.bo.eva.EvaLabelBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UEC_GROUP_DEV/1.0.0/com.tydic.uec.ability.UecEvaluateRecordAbilityService"})
public class UecEvaluateRecordAbilityServiceImpl
implements UecEvaluateRecordAbilityService {
    private final UecEvaluateRecordBusiService uecEvaluateRecordBusiService;

    public UecEvaluateRecordAbilityServiceImpl(UecEvaluateRecordBusiService uecEvaluateRecordBusiService) {
        this.uecEvaluateRecordBusiService = uecEvaluateRecordBusiService;
    }

    @PostMapping(value={"recordEvaData"})
    public UecEvaluateRecordAbilityRspBO recordEvaData(@RequestBody UecEvaluateRecordAbilityReqBO reqBO) {
        this.validArgs(reqBO);
        UecEvaluateRecordBusiReqBO busiReqBO = new UecEvaluateRecordBusiReqBO();
        Map<Long, List<EvaDataStatsBO>> dataMap = reqBO.getRecordData().stream().collect(Collectors.groupingBy(EvaDataStatsBO::getStatsId));
        busiReqBO.setRecordType(reqBO.getRecordType());
        busiReqBO.setSysCode(reqBO.getSysCode());
        for (Map.Entry<Long, List<EvaDataStatsBO>> entry : dataMap.entrySet()) {
            busiReqBO.setEvaId(entry.getKey());
            busiReqBO.setObjId(entry.getValue().get(0).getObjId());
            busiReqBO.setObjType(entry.getValue().get(0).getObjType());
            ArrayList<EvaLabelBO> labelList = new ArrayList<EvaLabelBO>(entry.getValue().size());
            for (EvaDataStatsBO statsBO : entry.getValue()) {
                if (UecCommonConstant.StatsType.LABEL.equals(reqBO.getRecordType())) {
                    this.validData(statsBO);
                }
                EvaLabelBO labelBO = new EvaLabelBO();
                labelBO.setLabelCode(statsBO.getStatsCode());
                labelBO.setLabelName(statsBO.getStatsName());
                labelBO.setLabelDesc(statsBO.getStatsDesc());
                labelList.add(labelBO);
            }
            busiReqBO.setLabelList(labelList);
            busiReqBO.setSysTenantId(reqBO.getSysTenantId());
            busiReqBO.setSysTenantName(reqBO.getSysTenantName());
            this.uecEvaluateRecordBusiService.dealDataRecord(busiReqBO);
        }
        UecEvaluateRecordAbilityRspBO rspBO = new UecEvaluateRecordAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8bc4\u4ef7\u5206\u6790\u6570\u636e\u8bb0\u5f55\u6210\u529f");
        return rspBO;
    }

    private void validArgs(UecEvaluateRecordAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u5206\u6790\u6570\u636e\u8bb0\u5f55\u670d\u52a1\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSysCode())) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u5206\u6790\u6570\u636e\u8bb0\u5f55\u670d\u52a1\u4e1a\u52a1\u7cfb\u7edf[sysCode]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getRecordData())) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u5206\u6790\u8bb0\u5f55\u670d\u52a1\u6570\u636e[recordData]\u4e3a\u7a7a");
        }
        if (reqBO.getRecordType() == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u5206\u6790\u6570\u636e\u8bb0\u5f55\u670d\u52a1\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a[recordType]\u4e3a\u7a7a");
        }
    }

    private void validData(EvaDataStatsBO data) {
        if (data.getStatsId() == null || StringUtils.isBlank((CharSequence)data.getStatsCode()) || StringUtils.isBlank((CharSequence)data.getStatsName())) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u5206\u6790\u6570\u636e\u8bb0\u5f55\u670d\u52a1\u6807\u7b7e\u53c2\u6570\u4e3a\u7a7a");
        }
        if (data.getObjType() == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u5206\u6790\u6570\u636e\u8bb0\u5f55\u670d\u52a1\u5bf9\u8c61\u7c7b\u578b[objType]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)data.getObjId())) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u5206\u6790\u6570\u636e\u8bb0\u5f55\u670d\u52a1\u5bf9\u8c61ID[objId]\u4e3a\u7a7a");
        }
    }
}

