/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

public class CaptchaCodeUtils {
    private static final int CAPTCHA_WIDTH = 100;
    private static final int CAPTCHA_HEIGHT = 35;
    private static final int NUMBER_CNT = 4;
    private static final String IMAGE_TYPE = "JPEG";
    private Random r = new Random();
    private String[] fontNames = new String[]{"\u5b8b\u4f53", "\u9ed1\u4f53", "\u5fae\u8f6f\u96c5\u9ed1"};
    private String codes = "23456789abcdefghjkmnopqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";
    private Color bgColor = new Color(255, 255, 255);
    private String text;
    private static CaptchaCodeUtils utils = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CaptchaCodeUtils getInstance() {
        if (utils != null) return utils;
        Class<CaptchaCodeUtils> clazz = CaptchaCodeUtils.class;
        synchronized (CaptchaCodeUtils.class) {
            if (utils != null) return utils;
            utils = new CaptchaCodeUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return utils;
        }
    }

    public String getCode(String path) throws Exception {
        BufferedImage bi = utils.getImage();
        CaptchaCodeUtils.output(bi, new FileOutputStream(path));
        return this.text;
    }

    public CaptchaCode getCode() throws Exception {
        BufferedImage img = utils.getImage();
        CaptchaCode code = new CaptchaCode();
        code.setText(this.text);
        code.setData(this.copyImage2Byte(img));
        return code;
    }

    public byte[] copyImage2Byte(BufferedImage img) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, IMAGE_TYPE, bout);
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyByte2File(byte[] data, String file) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        FileOutputStream out = new FileOutputStream(file);
        try {
            byte[] buff = new byte[1024];
            int len = 0;
            while ((len = in.read(buff)) > -1) {
                out.write(buff, 0, len);
            }
            out.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            out.close();
            in.close();
        }
    }

    private Color randomColor() {
        int red = this.r.nextInt(150);
        int green = this.r.nextInt(150);
        int blue = this.r.nextInt(150);
        return new Color(red, green, blue);
    }

    private Font randomFont() {
        int index = this.r.nextInt(this.fontNames.length);
        String fontName = this.fontNames[index];
        int style = this.r.nextInt(4);
        int size = this.r.nextInt(5) + 24;
        return new Font(fontName, style, size);
    }

    private void drawLine(BufferedImage image) {
        int num = 5;
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        for (int i = 0; i < num; ++i) {
            int x1 = this.r.nextInt(100);
            int y1 = this.r.nextInt(35);
            int x2 = this.r.nextInt(100);
            int y2 = this.r.nextInt(35);
            g2.setStroke(new BasicStroke(1.5f));
            g2.setColor(this.randomColor());
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    private char randomChar() {
        int index = this.r.nextInt(this.codes.length());
        return this.codes.charAt(index);
    }

    private BufferedImage createImage() {
        BufferedImage image = new BufferedImage(100, 35, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, 100, 35);
        return image;
    }

    public BufferedImage getImage() {
        BufferedImage image = this.createImage();
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            String s = this.randomChar() + "";
            sb.append(s);
            float x = (float)i * 1.0f * 100.0f / 4.0f;
            g2.setFont(this.randomFont());
            g2.setColor(this.randomColor());
            g2.drawString(s, x, 30.0f);
        }
        this.text = sb.toString();
        return image;
    }

    public String getText() {
        return this.text;
    }

    public static void output(BufferedImage image, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)image, IMAGE_TYPE, out);
    }

    public static class CaptchaCode {
        private String text;
        private byte[] data;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }
    }
}

