/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.base;

import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.entity.AuthorityInfo;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;

public class UmcMemInfoHelper {
    private static final UmcMemInfoHelper INSTANCE = new UmcMemInfoHelper();
    private static final ThreadLocal<UmcMemInfoBO> CURRENT_USER = new ThreadLocal();

    public static UmcMemInfoHelper getInstance() {
        return INSTANCE;
    }

    public static UmcMemInfoBO getCurrentUser() {
        UmcMemInfoBO userInfo = CURRENT_USER.get();
        if (userInfo != null) {
            return userInfo;
        }
        Authentication authentication = UmcMemInfoHelper.getCurrentAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof UmcMemInfoBO) {
            userInfo = (UmcMemInfoBO)principal;
            return userInfo;
        }
        return null;
    }

    public static void setThreadUser(UmcMemInfoBO userInfo) {
        CURRENT_USER.set(userInfo);
    }

    public void removeThreadUser() {
        CURRENT_USER.remove();
    }

    private static Authentication getCurrentAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        return context == null ? null : context.getAuthentication();
    }

    public static boolean hasAuthority(String authority) {
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        if (userInfo == null) {
            throw new SessionAuthenticationException("\u8bf7\u5148\u767b\u5f55");
        }
        boolean authed = false;
        for (AuthorityInfo authorityInfo : userInfo.getPermission()) {
            if (!authority.equals(authorityInfo.getKey())) continue;
            authed = true;
            break;
        }
        return authed;
    }
}

