/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.base;

import com.tydic.umc.security.base.BaseBo;
import com.tydic.umc.security.utils.ExceptionHelper;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ResponseMessage
implements BaseBo {
    private Long timestamp;
    private Boolean success;
    private Integer code;
    private String message;
    private Object data;

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public static ResponseMessage ok() {
        return ResponseMessage.ok(null);
    }

    public static ResponseMessage ok(Object data) {
        ResponseMessage msg = new ResponseMessage();
        msg.timeStamp().code(200).data(data).success(Boolean.TRUE);
        return msg;
    }

    public static ResponseMessage error(Exception ex) {
        return ResponseMessage.error(500, ExceptionHelper.getBootMessage(ex));
    }

    public static ResponseMessage error(String message) {
        return ResponseMessage.error(500, message);
    }

    public static ResponseMessage error(int code, String message) {
        ResponseMessage msg = new ResponseMessage();
        msg.code(code).message(message).timeStamp().success(Boolean.FALSE);
        return msg;
    }

    private ResponseMessage timeStamp() {
        this.timeStamp(System.currentTimeMillis());
        return this;
    }

    private ResponseMessage timeStamp(Long timeStamp) {
        this.timestamp = timeStamp;
        return this;
    }

    public ResponseMessage success(Boolean success) {
        this.success = success;
        return this;
    }

    public ResponseMessage code(int code) {
        this.code = code;
        return this;
    }

    public ResponseMessage message(String message) {
        this.message = message;
        return this;
    }

    public <T> ResponseMessage data(T data) {
        this.data = data;
        return this;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

