/*
 * Decompiled with CFR 0.152.
 */
package com.crc.runwork.core.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.crc.runwork.core.utils.ResponseData;
import com.crc.runwork.core.utils.RunUserVo;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class JWTTokenUtil {
    private static final String USER_TOKEN_KEY = "userDataObj";
    private static final String RUN3_TOKEN = "run3token";

    public static String getTokenInfo(HttpServletRequest request, String secretKey) {
        String run3token = request.getHeader(RUN3_TOKEN);
        return JWTTokenUtil.getTokenInfo(run3token, secretKey);
    }

    public static String getTokenInfo(String run3token, String secretKey) {
        if (StringUtils.isEmpty(run3token)) {
            System.out.printf("JWTTokenUtil error: %s", "run3token is null");
            return ResponseData.getResponseData("E0S0A108", "run3token is null");
        }
        if (StringUtils.isEmpty(secretKey)) {
            System.out.printf("JWTTokenUtil error: %s", "secretKey is null");
            return ResponseData.getResponseData("E0S0A109", "secretKey is null");
        }
        try {
            DecodedJWT decodedJWT = JWT.require(Algorithm.HMAC256(secretKey)).build().verify(run3token);
            return decodedJWT.getClaims().get(USER_TOKEN_KEY).asString();
        }
        catch (TokenExpiredException e) {
            System.out.printf("JWTTokenUtil error: %s, %s", "The Token has expired", e.getMessage());
            return ResponseData.getResponseData("E0S0A104", "The Token has expired");
        }
        catch (SignatureVerificationException e) {
            System.out.printf("JWTTokenUtil error: %s, %s", "The Token's Signature resulted invalid", e);
            return ResponseData.getResponseData("E0S0A105", "The Token's Signature resulted invalid");
        }
        catch (Exception e) {
            System.out.printf("JWTTokenUtil error: %s, %s", "The Token's error", e);
            return ResponseData.getResponseData("E0S0A106", "The Token's error");
        }
    }

    public static RunUserVo toRunUserVo(String userDataJsonObj) {
        JSONObject jsonObject = JSON.parseObject(userDataJsonObj);
        RunUserVo runUserVo = JSONObject.toJavaObject(jsonObject, RunUserVo.class);
        return runUserVo;
    }

    public static String getLdap(String run3token) {
        RunUserVo runUserVo = JWTTokenUtil.toRunUserVo(run3token);
        if (null == runUserVo) {
            System.out.printf("JWTTokenUtil error: runUserVo is null", new Object[0]);
            return "";
        }
        return runUserVo.getUserId();
    }

    public static boolean isInvalidToken(String run3token) {
        if (StringUtils.isBlank(run3token)) {
            return true;
        }
        return !run3token.contains("user_id");
    }
}

