/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigFileChangeListener;
import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.RepositoryChangeListener;
import com.ctrip.framework.apollo.model.ConfigFileChangeEvent;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigFile
implements ConfigFile,
RepositoryChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigFile.class);
    private static ExecutorService m_executorService = Executors.newCachedThreadPool(ApolloThreadFactory.create((String)"ConfigFile", (boolean)true));
    protected ConfigRepository m_configRepository;
    protected String m_namespace;
    protected AtomicReference<Properties> m_configProperties;
    private List<ConfigFileChangeListener> m_listeners = Lists.newCopyOnWriteArrayList();

    public AbstractConfigFile(String namespace, ConfigRepository configRepository) {
        this.m_configRepository = configRepository;
        this.m_namespace = namespace;
        this.m_configProperties = new AtomicReference();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        try {
            this.m_configProperties.set(this.m_configRepository.getConfig());
        }
        catch (Throwable ex) {
            Tracer.logError((Throwable)ex);
            logger.warn("Init Apollo Config File failed - namespace: {}, reason: {}.", (Object)this.m_namespace, (Object)ExceptionUtil.getDetailMessage(ex));
        }
        finally {
            this.m_configRepository.addChangeListener(this);
        }
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    protected abstract void update(Properties var1);

    @Override
    public synchronized void onRepositoryChange(String namespace, Properties newProperties) {
        if (newProperties.equals(this.m_configProperties.get())) {
            return;
        }
        Properties newConfigProperties = new Properties();
        newConfigProperties.putAll((Map<?, ?>)newProperties);
        String oldValue = this.getContent();
        this.update(newProperties);
        String newValue = this.getContent();
        PropertyChangeType changeType = PropertyChangeType.MODIFIED;
        if (oldValue == null) {
            changeType = PropertyChangeType.ADDED;
        } else if (newValue == null) {
            changeType = PropertyChangeType.DELETED;
        }
        this.fireConfigChange(new ConfigFileChangeEvent(this.m_namespace, oldValue, newValue, changeType));
        Tracer.logEvent((String)"Apollo.Client.ConfigChanges", (String)this.m_namespace);
    }

    @Override
    public void addChangeListener(ConfigFileChangeListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    private void fireConfigChange(final ConfigFileChangeEvent changeEvent) {
        for (final ConfigFileChangeListener listener : this.m_listeners) {
            m_executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String listenerName = listener.getClass().getName();
                    Transaction transaction = Tracer.newTransaction((String)"Apollo.ConfigFileChangeListener", (String)listenerName);
                    try {
                        listener.onChange(changeEvent);
                        transaction.setStatus("0");
                    }
                    catch (Throwable ex) {
                        transaction.setStatus(ex);
                        Tracer.logError((Throwable)ex);
                        logger.error("Failed to invoke config file change listener {}", (Object)listenerName, (Object)ex);
                    }
                    finally {
                        transaction.complete();
                    }
                }
            });
        }
    }
}

