/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.property;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.spring.property.PlaceholderHelper;
import com.ctrip.framework.apollo.spring.property.SpringValueDefinition;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

public class SpringValueDefinitionProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Multimap<String, SpringValueDefinition> beanName2SpringValueDefinitions = LinkedListMultimap.create();
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private final PlaceholderHelper placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            this.processPropertyValues(registry);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public static Multimap<String, SpringValueDefinition> getBeanName2SpringValueDefinitions() {
        return beanName2SpringValueDefinitions;
    }

    private void processPropertyValues(BeanDefinitionRegistry beanRegistry) {
        String[] beanNames;
        if (!initialized.compareAndSet(false, true)) {
            return;
        }
        for (String beanName : beanNames = beanRegistry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanRegistry.getBeanDefinition(beanName);
            MutablePropertyValues mutablePropertyValues = beanDefinition.getPropertyValues();
            List propertyValues = mutablePropertyValues.getPropertyValueList();
            for (PropertyValue propertyValue : propertyValues) {
                String placeholder;
                Set<String> keys;
                Object value = propertyValue.getValue();
                if (!(value instanceof TypedStringValue) || (keys = this.placeholderHelper.extractPlaceholderKeys(placeholder = ((TypedStringValue)value).getValue())).isEmpty()) continue;
                for (String key : keys) {
                    beanName2SpringValueDefinitions.put((Object)beanName, (Object)new SpringValueDefinition(key, placeholder, propertyValue.getName()));
                }
            }
        }
    }

    private static void reset() {
        initialized.set(false);
        beanName2SpringValueDefinitions.clear();
    }
}

