/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.util;

import java.util.Objects;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BeanRegistrationUtil {
    public static boolean registerBeanDefinitionIfNotExists(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass) {
        String[] candidates;
        if (registry.containsBeanDefinition(beanName)) {
            return false;
        }
        for (String candidate : candidates = registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(candidate);
            if (!Objects.equals(beanDefinition.getBeanClassName(), beanClass.getName())) continue;
            return false;
        }
        AbstractBeanDefinition annotationProcessor = BeanDefinitionBuilder.genericBeanDefinition(beanClass).getBeanDefinition();
        registry.registerBeanDefinition(beanName, (BeanDefinition)annotationProcessor);
        return true;
    }
}

