/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.crypto.symmetric;

import com.dahuatech.hutool.core.util.ArrayUtil;
import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.crypto.Mode;
import com.dahuatech.hutool.crypto.Padding;
import com.dahuatech.hutool.crypto.SecureUtil;
import com.dahuatech.hutool.crypto.symmetric.SymmetricCrypto;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SM4
extends SymmetricCrypto {
    public static final String ALGORITHM_NAME = "SM4";
    private static final long serialVersionUID = 1L;

    public SM4() {
        super(ALGORITHM_NAME);
    }

    public SM4(byte[] key) {
        super(ALGORITHM_NAME, key);
    }

    public SM4(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public SM4(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public SM4(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public SM4(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, (IvParameterSpec)null);
    }

    public SM4(Mode mode, Padding padding, SecretKey key, byte[] iv) {
        this(mode, padding, key, ArrayUtil.isEmpty(iv) ? (IvParameterSpec)null : new IvParameterSpec(iv));
    }

    public SM4(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public SM4(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public SM4(String mode, String padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public SM4(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, SecureUtil.generateKey(ALGORITHM_NAME, key), ArrayUtil.isEmpty(iv) ? (IvParameterSpec)null : new IvParameterSpec(iv));
    }

    public SM4(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public SM4(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StrUtil.format((CharSequence)"SM4/{}/{}", mode, padding), key, iv);
    }
}

