/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.executor.handler;

import com.dangdang.ddframe.job.executor.handler.ExecutorServiceHandler;
import com.dangdang.ddframe.job.executor.handler.JobExceptionHandler;
import com.dangdang.ddframe.job.executor.handler.impl.DefaultExecutorServiceHandler;
import com.dangdang.ddframe.job.executor.handler.impl.DefaultJobExceptionHandler;
import com.dangdang.ddframe.job.util.json.GsonFactory;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JobProperties {
    private Map<JobPropertiesEnum, String> map = new LinkedHashMap<JobPropertiesEnum, String>(JobPropertiesEnum.values().length, 1.0f);

    public void put(String key, String value) {
        JobPropertiesEnum jobPropertiesEnum = JobPropertiesEnum.from(key);
        if (null == jobPropertiesEnum || null == value) {
            return;
        }
        this.map.put(jobPropertiesEnum, value);
    }

    public String get(JobPropertiesEnum jobPropertiesEnum) {
        return this.map.containsKey((Object)jobPropertiesEnum) ? this.map.get((Object)jobPropertiesEnum) : jobPropertiesEnum.getDefaultValue();
    }

    public String json() {
        LinkedHashMap<String, String> jsonMap = new LinkedHashMap<String, String>(JobPropertiesEnum.values().length, 1.0f);
        for (JobPropertiesEnum each : JobPropertiesEnum.values()) {
            jsonMap.put(each.getKey(), this.get(each));
        }
        return GsonFactory.getGson().toJson(jsonMap);
    }

    @ConstructorProperties(value={"map"})
    public JobProperties(Map<JobPropertiesEnum, String> map) {
        this.map = map;
    }

    public JobProperties() {
    }

    public static enum JobPropertiesEnum {
        JOB_EXCEPTION_HANDLER("job_exception_handler", JobExceptionHandler.class, DefaultJobExceptionHandler.class.getCanonicalName()),
        EXECUTOR_SERVICE_HANDLER("executor_service_handler", ExecutorServiceHandler.class, DefaultExecutorServiceHandler.class.getCanonicalName());

        private final String key;
        private final Class<?> classType;
        private final String defaultValue;

        public static JobPropertiesEnum from(String key) {
            for (JobPropertiesEnum each : JobPropertiesEnum.values()) {
                if (!each.getKey().equals(key)) continue;
                return each;
            }
            return null;
        }

        private JobPropertiesEnum(String key, Class<?> classType, String defaultValue) {
            this.key = key;
            this.classType = classType;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getClassType() {
            return this.classType;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

