/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.spring.namespace.parser.common;

import com.dangdang.ddframe.job.api.listener.AbstractDistributeOnceElasticJobListener;
import com.dangdang.ddframe.job.spring.namespace.parser.common.AbstractJobConfigurationDto;
import com.dangdang.ddframe.job.spring.namespace.parser.script.ScriptJobConfigurationDto;
import com.dangdang.ddframe.job.spring.schedule.SpringJobScheduler;
import com.google.common.base.Strings;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractJobBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringJobScheduler.class);
        factory.setInitMethodName("init");
        factory.addConstructorArgReference(element.getAttribute("registry-center-ref"));
        factory.addConstructorArgReference(this.createJobConfiguration(element, parserContext));
        factory.addConstructorArgValue(this.createJobListeners(element));
        return factory.getBeanDefinition();
    }

    private String createJobConfiguration(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(this.getJobConfigurationDTO());
        factory.addConstructorArgValue((Object)element.getAttribute("id"));
        if (!this.getJobConfigurationDTO().isAssignableFrom(ScriptJobConfigurationDto.class)) {
            factory.addConstructorArgValue((Object)element.getAttribute("class"));
        }
        factory.addConstructorArgValue((Object)element.getAttribute("sharding-total-count"));
        factory.addConstructorArgValue((Object)element.getAttribute("cron"));
        if (this.getJobConfigurationDTO().isAssignableFrom(ScriptJobConfigurationDto.class)) {
            factory.addConstructorArgValue((Object)element.getAttribute("script-command-line"));
        }
        this.addPropertyValueIfNotEmpty("sharding-item-parameters", "shardingItemParameters", element, factory);
        this.addPropertyValueIfNotEmpty("job-parameter", "jobParameter", element, factory);
        this.addPropertyValueIfNotEmpty("monitor-execution", "monitorExecution", element, factory);
        this.addPropertyValueIfNotEmpty("monitor-port", "monitorPort", element, factory);
        this.addPropertyValueIfNotEmpty("max-time-diff-seconds", "maxTimeDiffSeconds", element, factory);
        this.addPropertyValueIfNotEmpty("failover", "failover", element, factory);
        this.addPropertyValueIfNotEmpty("misfire", "misfire", element, factory);
        this.addPropertyValueIfNotEmpty("job-sharding-strategy-class", "jobShardingStrategyClass", element, factory);
        this.addPropertyValueIfNotEmpty("description", "description", element, factory);
        this.addPropertyValueIfNotEmpty("disabled", "disabled", element, factory);
        this.addPropertyValueIfNotEmpty("overwrite", "overwrite", element, factory);
        this.setPropertiesValue(element, factory);
        String result = element.getAttribute("id") + "Conf";
        parserContext.getRegistry().registerBeanDefinition(result, (BeanDefinition)factory.getBeanDefinition());
        return result;
    }

    protected abstract Class<? extends AbstractJobConfigurationDto> getJobConfigurationDTO();

    protected abstract void setPropertiesValue(Element var1, BeanDefinitionBuilder var2);

    private List<BeanDefinition> createJobListeners(Element element) {
        List listenerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        ManagedList result = new ManagedList(listenerElements.size());
        for (Element each : listenerElements) {
            String className = each.getAttribute("class");
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition((String)className);
            factory.setScope("prototype");
            try {
                Class<?> listenerClass = Class.forName(className);
                if (AbstractDistributeOnceElasticJobListener.class.isAssignableFrom(listenerClass)) {
                    factory.addConstructorArgValue((Object)each.getAttribute("started-timeout-milliseconds"));
                    factory.addConstructorArgValue((Object)each.getAttribute("completed-timeout-milliseconds"));
                }
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            result.add(factory.getBeanDefinition());
        }
        return result;
    }

    protected final void addPropertyValueIfNotEmpty(String attributeName, String propertyName, Element element, BeanDefinitionBuilder factory) {
        String attributeValue = element.getAttribute(attributeName);
        if (!Strings.isNullOrEmpty((String)attributeValue)) {
            factory.addPropertyValue(propertyName, (Object)attributeValue);
        }
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

