/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.spring.schedule;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.PropertySettingJobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public final class SpringJobFactory
extends PropertySettingJobFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringJobFactory.class);
    private static ApplicationContext applicationContext;

    public static void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        Preconditions.checkNotNull((Object)applicationContext, (Object)"applicationContext cannot be null, should call setApplicationContext first.");
        Job result = super.newJob(bundle, scheduler);
        Optional<ElasticJob> elasticJobBean = this.findElasticJobBean(bundle);
        if (elasticJobBean.isPresent()) {
            this.setBeanProps(result, this.getJobDataMap(bundle, scheduler, (ElasticJob)elasticJobBean.get()));
        }
        return result;
    }

    private Optional<ElasticJob> findElasticJobBean(TriggerFiredBundle bundle) {
        for (ElasticJob each : applicationContext.getBeansOfType(ElasticJob.class).values()) {
            if (!bundle.getJobDetail().getJobDataMap().containsKey((Object)"elasticJob") || AopUtils.getTargetClass((Object)each) != bundle.getJobDetail().getJobDataMap().get((Object)"elasticJob").getClass()) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    private JobDataMap getJobDataMap(TriggerFiredBundle bundle, Scheduler scheduler, ElasticJob elasticJobBean) throws SchedulerException {
        JobDataMap result = new JobDataMap();
        result.putAll((Map)scheduler.getContext());
        result.putAll((Map)bundle.getJobDetail().getJobDataMap());
        result.putAll((Map)bundle.getTrigger().getJobDataMap());
        elasticJobBean.setJobFacade(((ElasticJob)result.get((Object)"elasticJob")).getJobFacade());
        result.put("elasticJob", (Object)elasticJobBean);
        return result;
    }
}

