/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.ability.impl;

import com.tydic.se.es.ability.SeIndexUpdateAbilityService;
import com.tydic.se.es.ability.bo.SeIndexServiceRspBo;
import com.tydic.se.es.ability.bo.SeIndexUpdateServiceReqBo;
import com.tydic.se.es.constants.SeEsConstant;
import com.tydic.se.es.util.ElasticsearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="seIndexUpdateAbilityService")
public class SeIndexUpdateAbilityServiceImpl
implements SeIndexUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SeIndexUpdateAbilityServiceImpl.class);
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    public SeIndexServiceRspBo updateIndex(SeIndexUpdateServiceReqBo reqBo) {
        SeIndexServiceRspBo rspBo = new SeIndexServiceRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setCode("1");
            rspBo.setMessage("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        Boolean index = false;
        if (SeEsConstant.OPERATE_TYPE_SETTING.equals(reqBo.getOperateType())) {
            index = this.elasticsearchUtil.updateIndexSetting(reqBo.getIndexName(), reqBo.getSource());
        } else if (SeEsConstant.OPERATE_TYPE_MAPPING.equals(reqBo.getOperateType())) {
            index = this.elasticsearchUtil.updateMapping(reqBo.getIndexName(), reqBo.getSource());
        } else {
            rspBo.setCode("1");
            rspBo.setMessage("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + reqBo.getSource());
            return rspBo;
        }
        log.info("\u8c03\u7528\u5de5\u5177\u7c7b\u4fee\u6539ES\u7d22\u5f15");
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private String validateArg(SeIndexUpdateServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getIndexName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027indexName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOperateType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027operateType\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getSource())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027source\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

