/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.comb.impl;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.se.base.dao.UccCommodityMapper;
import com.tydic.se.base.dao.po.UccCommodityPo;
import com.tydic.se.es.async.SeDataAsyncService;
import com.tydic.se.es.beanpost.SyncAbleManager;
import com.tydic.se.es.busi.po.SeDataAsyncDataReqParam;
import com.tydic.se.es.comb.SeDataSyncCombService;
import com.tydic.se.es.comb.bo.SeDataSyncCombServiceReqBo;
import com.tydic.se.es.comb.bo.SeDataSyncCombServiceRspBo;
import com.tydic.se.es.constants.SeEsConstant;
import com.tydic.se.es.enums.SeEsEnums;
import com.tydic.se.es.syncable.SyncAble;
import com.tydic.se.es.syncable.bo.SyncAbleReqBo;
import com.tydic.se.es.syncable.bo.SyncAbleRspBo;
import com.tydic.se.es.util.SeEsRspUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="seDataSyncCombService")
public class SeDataSyncCombServiceImpl
implements SeDataSyncCombService {
    private static final Logger log = LoggerFactory.getLogger(SeDataSyncCombServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private SyncAbleManager syncAbleManager;
    private SyncAble syncAble;

    public SeDataSyncCombServiceRspBo syncData(SeDataSyncCombServiceReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u6570\u636e\u540c\u6b65\uff0c\u5165\u53c2\uff1a", (Object)JSON.toJSONString((Object)reqBo));
        }
        SeDataSyncCombServiceRspBo retBo = SeEsRspUtil.getSuccessRspBo(SeDataSyncCombServiceRspBo.class);
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setCode("1");
            retBo.setMessage(validateStr);
            return retBo;
        }
        this.syncAble = this.syncAbleManager.getSyncAbleByMethod(SeEsEnums.SyncMethod.ADD.getMethod());
        for (Long supplierId : reqBo.getSupplierIds()) {
            log.info("\u4f9b\u5e94\u5546[{}]\u6570\u636e\u540c\u6b65\u5f00\u59cb=======", (Object)supplierId);
            if (reqBo.getSheet() > 1) {
                this.dealAsync(reqBo, retBo, supplierId);
                continue;
            }
            this.dealSync(reqBo, retBo, supplierId);
        }
        return retBo;
    }

    private void dealSync(SeDataSyncCombServiceReqBo reqBo, SeDataSyncCombServiceRspBo retBo, Long supplierId) {
        int total = this.uccCommodityMapper.countCommodity(supplierId);
        if (0 == total) {
            log.info("\u8be5\u4f9b\u5e94\u5546[supplierId = {}]\u4e0b\u65e0\u9700\u8981\u540c\u6b65\u7684\u6570\u636e", (Object)supplierId);
            return;
        }
        int pageTotal = 0 == total % reqBo.getPageSize() ? total / reqBo.getPageSize() : total / reqBo.getPageSize() + 1;
        Page page = new Page();
        page.setPageSize(reqBo.getPageSize());
        UccCommodityPo commodityPo = new UccCommodityPo();
        commodityPo.setSupplierShopId(supplierId);
        SyncAbleReqBo ableReqBo = new SyncAbleReqBo();
        ableReqBo.setIndexName(reqBo.getIndexName());
        for (int i = 1; i <= pageTotal; ++i) {
            page.setPageNo(i);
            List commodityIds = this.uccCommodityMapper.queryCommodityList(commodityPo, page);
            if (CollectionUtils.isEmpty((Collection)commodityIds)) continue;
            ableReqBo.setSyncType(SeEsConstant.SYNC_TYPE_BY_COMMODITY_ID);
            ableReqBo.setCommodityIds(commodityIds);
            ableReqBo.setSupplierId(supplierId);
            SyncAbleRspBo ableRetBo = this.syncAble.dealSync(ableReqBo);
            if ("0".equals(ableRetBo.getCode())) continue;
            log.error("\u4f9b\u5e94\u5546\uff1a{}, \u6570\u636e\u540c\u6b65\u5931\u8d25\uff1a{}", (Object)supplierId, (Object)ableRetBo.getMessage());
        }
    }

    private void dealAsync(SeDataSyncCombServiceReqBo reqBo, SeDataSyncCombServiceRspBo retBo, Long supplierId) {
        if (log.isDebugEnabled()) {
            log.debug("\u4f9b\u5e94\u5546\uff1a[{}]\uff0c\u6570\u636e\u540c\u6b65\uff08\u5f02\u6b65\uff09\u5f00\u59cb", (Object)supplierId);
        }
        retBo.setCode("1");
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNamePrefix("ES-ASYNC-THREAD-").build();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(50, 50, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        long start = System.currentTimeMillis();
        int total = this.uccCommodityMapper.countCommodity(supplierId);
        int cycle = total % reqBo.getSheet() == 0 ? total / reqBo.getSheet() : total / reqBo.getSheet() + 1;
        for (int i = 0; i < reqBo.getSheet(); ++i) {
            SeDataAsyncDataReqParam asyncReqParam = new SeDataAsyncDataReqParam();
            asyncReqParam.setSupplierId(supplierId);
            asyncReqParam.setStar(i * cycle);
            asyncReqParam.setEnd((i + 1) * cycle);
            asyncReqParam.setTotal(cycle);
            asyncReqParam.setSize(reqBo.getPageSize());
            asyncReqParam.setIndexName(reqBo.getIndexName());
            if (asyncReqParam.getStar() > total) break;
            SeDataAsyncService asyncService = new SeDataAsyncService();
            asyncService.setAsyncReqParam(asyncReqParam);
            asyncService.setUccCommodityMapper(this.uccCommodityMapper);
            asyncService.setSyncAble(this.syncAble);
            pool.submit(asyncService);
        }
        pool.shutdown();
        while (true) {
            if (pool.isTerminated()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        retBo.setCode("0");
        retBo.setMessage("\u5546\u54c1\u66f4\u65b0\u7ed3\u675f");
        long end = System.currentTimeMillis();
        long consume = (end - start) / 1000L;
        log.info("\u4f9b\u5e94\u5546\uff1a[{}]\uff0c\u6570\u636e\u540c\u6b65\uff08\u5f02\u6b65\uff09\u8017\u65f6\uff1a{}" + supplierId, (Object)consume);
    }
}

