/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import java.util.ArrayList;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class TextRenderPolicy
implements RenderPolicy {
    private static final String LINE_CHARACTOR = "\\n";

    @Override
    public void render(ElementTemplate runTemplateP, Object renderData, XWPFTemplate template) {
        RunTemplate runTemplate = (RunTemplate)runTemplateP;
        XWPFRun run = runTemplate.getRun();
        if (null == renderData) {
            run.setText("", 0);
            return;
        }
        TextRenderData textRenderData = null;
        textRenderData = renderData instanceof TextRenderData ? (TextRenderData)renderData : new TextRenderData(String.valueOf(renderData));
        String data = textRenderData.getText();
        this.styleRun(run, textRenderData.getStyle());
        if (null == data) {
            data = "";
        }
        if (data.contains(LINE_CHARACTOR)) {
            int from = 0;
            int end = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while (-1 != (end = data.indexOf(LINE_CHARACTOR, from))) {
                lines.add(data.substring(from, end));
                from = end + LINE_CHARACTOR.length();
            }
            lines.add(data.substring(from));
            Object[] linesArray = lines.toArray();
            run.setText(linesArray[0].toString(), 0);
            for (int i = 1; i < linesArray.length; ++i) {
                run.addBreak();
                run.setText(linesArray[i].toString());
            }
        } else {
            run.setText(data, 0);
        }
    }

    private void styleRun(XWPFRun run, Style style) {
        if (null != style) {
            String color = style.getColor();
            String fontFamily = style.getFontFamily();
            int fontSize = style.getFontSize();
            Boolean bold = style.isBold();
            Boolean italic = style.isItalic();
            Boolean strike = style.isStrike();
            if (null != color) {
                run.setColor(color);
            }
            if (0 != fontSize) {
                run.setFontSize(fontSize);
            }
            if (null != fontFamily) {
                run.setFontFamily(fontFamily);
            }
            if (null != bold) {
                run.setBold(bold.booleanValue());
            }
            if (null != italic) {
                run.setItalic(italic.booleanValue());
            }
            if (null != strike) {
                run.setStrike(strike.booleanValue());
            }
        }
    }
}

