/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.resolver;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.resolver.GramerSymbol;
import com.deepoove.poi.resolver.RunEdge;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.cell.CellTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateResolver {
    private static final Logger logger = LoggerFactory.getLogger(TemplateResolver.class);
    public static final String RULER_REGEX = "\\{\\{(#|@)?\\w+\\}\\}";
    public static final String EXTRA_REGEX = "(\\{\\{)|(\\}\\})";
    public static Pattern tagPattern = Pattern.compile("\\{\\{(#|@)?\\w+\\}\\}");
    public static Pattern varPattern = Pattern.compile("(\\{\\{)|(\\}\\})");

    public static List<ElementTemplate> parseElementTemplates(NiceXWPFDocument doc) {
        List footers;
        if (null == doc) {
            return null;
        }
        ArrayList<ElementTemplate> rts = new ArrayList<ElementTemplate>();
        rts.addAll(TemplateResolver.parseParagraph(doc.getParagraphs()));
        rts.addAll(TemplateResolver.parseTable(doc.getTables()));
        List headers = doc.getHeaderList();
        if (null != headers) {
            for (XWPFHeader header : headers) {
                rts.addAll(TemplateResolver.parseParagraph(header.getParagraphs()));
                rts.addAll(TemplateResolver.parseTable(header.getTables()));
            }
        }
        if (null != (footers = doc.getFooterList())) {
            for (XWPFFooter footer : footers) {
                rts.addAll(TemplateResolver.parseParagraph(footer.getParagraphs()));
                rts.addAll(TemplateResolver.parseTable(footer.getTables()));
            }
        }
        return rts;
    }

    private static List<RunTemplate> parseParagraph(List<XWPFParagraph> paragraphs) {
        ArrayList<RunTemplate> result = new ArrayList<RunTemplate>();
        if (null != paragraphs) {
            for (XWPFParagraph paragraph : paragraphs) {
                List<RunTemplate> parseRun = TemplateResolver.parseRun(paragraph);
                if (null == parseRun) continue;
                result.addAll(parseRun);
            }
        }
        return result;
    }

    private static List<ElementTemplate> parseTable(List<XWPFTable> tables) {
        ArrayList<ElementTemplate> result = new ArrayList<ElementTemplate>();
        if (null != tables && !tables.isEmpty()) {
            for (XWPFTable tb : tables) {
                List<ElementTemplate> parseTable = TemplateResolver.parseTable(tb);
                if (null == parseTable) continue;
                result.addAll(parseTable);
            }
        }
        return result;
    }

    private static CellTemplate parseCell(XWPFTableCell cell) {
        if (null == cell) {
            return null;
        }
        String text = cell.getText();
        if (null == text || "".equals(text.trim())) {
            return null;
        }
        return (CellTemplate)TemplateResolver.parseTemplateFactory(text, cell);
    }

    public static List<ElementTemplate> parseTable(XWPFTable table) {
        if (null == table) {
            return null;
        }
        ArrayList<ElementTemplate> rts = new ArrayList<ElementTemplate>();
        List rows = table.getRows();
        if (null != rows) {
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                if (null == cells) continue;
                for (XWPFTableCell cell : cells) {
                    rts.addAll(TemplateResolver.parseParagraph(cell.getParagraphs()));
                    rts.addAll(TemplateResolver.parseTable(cell.getTables()));
                }
            }
        }
        return rts;
    }

    public static List<RunTemplate> parseRun(XWPFParagraph paragraph) {
        int n;
        List runs = paragraph.getRuns();
        if (null == runs || runs.isEmpty()) {
            return null;
        }
        String text = paragraph.getText();
        logger.debug("Paragrah's text is:" + text);
        ArrayList<Pair<RunEdge, RunEdge>> pairs = new ArrayList<Pair<RunEdge, RunEdge>>();
        ArrayList<String> tags = new ArrayList<String>();
        TemplateResolver.calcTagPosInParagraph(text, pairs, tags);
        ArrayList<RunTemplate> rts = new ArrayList<RunTemplate>();
        if (pairs.isEmpty()) {
            return rts;
        }
        TemplateResolver.calcRunPosInParagraph(runs, pairs);
        for (Pair pair : pairs) {
            logger.debug(((RunEdge)pair.getLeft()).toString());
            logger.debug(((RunEdge)pair.getRight()).toString());
        }
        Pair pair2 = (Pair)pairs.get(0);
        int tagIndex = n = pairs.size();
        for (int n2 = n - 1; n2 >= 0; --n2) {
            RunTemplate runTemplate;
            pair2 = (Pair)pairs.get(n2);
            RunEdge left2 = (RunEdge)pair2.getLeft();
            RunEdge right2 = (RunEdge)pair2.getRight();
            int left_r = left2.getRunPos();
            int right_r = right2.getRunPos();
            int runEdge = left2.getRunEdge();
            int runEdge2 = right2.getRunEdge();
            String text1 = ((XWPFRun)runs.get(left_r)).getText(0);
            String text2 = ((XWPFRun)runs.get(right_r)).getText(0);
            if (runEdge2 + 1 >= text2.length()) {
                if (left_r != right_r) {
                    paragraph.removeRun(right_r);
                }
            } else {
                String substring = text2.substring(runEdge2 + 1, text2.length());
                if (left_r == right_r) {
                    XWPFRun insertNewRun = paragraph.insertNewRun(right_r + 1);
                    TemplateResolver.styleRun(insertNewRun, (XWPFRun)runs.get(right_r));
                    insertNewRun.setText(substring, 0);
                } else {
                    ((XWPFRun)runs.get(right_r)).setText(substring, 0);
                }
            }
            for (int m = right_r - 1; m > left_r; --m) {
                paragraph.removeRun(m);
            }
            if (runEdge <= 0) {
                ((XWPFRun)runs.get(left_r)).setText((String)tags.get(--tagIndex), 0);
                runTemplate = TemplateResolver.parseRun((XWPFRun)runs.get(left_r));
            } else {
                String substring = text1.substring(0, runEdge);
                XWPFRun xwpfRun = (XWPFRun)runs.get(left_r);
                ((XWPFRun)runs.get(left_r)).setText(substring, 0);
                XWPFRun insertNewRun = paragraph.insertNewRun(left_r + 1);
                TemplateResolver.styleRun(insertNewRun, xwpfRun);
                insertNewRun.setText((String)tags.get(--tagIndex), 0);
                runTemplate = TemplateResolver.parseRun((XWPFRun)runs.get(left_r + 1));
            }
            if (null == runTemplate) continue;
            rts.add(runTemplate);
        }
        return rts;
    }

    private static void calcRunPosInParagraph(List<XWPFRun> runs, List<Pair<RunEdge, RunEdge>> pairs) {
        int size = runs.size();
        int pos = 0;
        int calc = 0;
        Pair<RunEdge, RunEdge> pair = pairs.get(pos);
        RunEdge leftEdge = (RunEdge)pair.getLeft();
        RunEdge rightEdge = (RunEdge)pair.getRight();
        int leftInAll = leftEdge.getAllPos();
        int rightInAll = rightEdge.getAllPos();
        for (int i = 0; i < size; ++i) {
            XWPFRun run = runs.get(i);
            String str = run.getText(0);
            if (null == str) {
                logger.warn("found the empty text run,may be produce bug:" + run);
                calc += run.toString().length();
                continue;
            }
            logger.debug(str);
            if (str.length() + calc < leftInAll) {
                calc += str.length();
                continue;
            }
            for (int j = 0; j < str.length(); ++j) {
                if (calc + j == leftInAll) {
                    leftEdge.setRunPos(i);
                    leftEdge.setRunEdge(j);
                    leftEdge.setText(str);
                }
                if (calc + j != rightInAll - 1) continue;
                rightEdge.setRunPos(i);
                rightEdge.setRunEdge(j);
                rightEdge.setText(str);
                if (pos == pairs.size() - 1) break;
                pair = pairs.get(++pos);
                leftEdge = (RunEdge)pair.getLeft();
                rightEdge = (RunEdge)pair.getRight();
                leftInAll = leftEdge.getAllPos();
                rightInAll = rightEdge.getAllPos();
            }
            calc += str.length();
        }
    }

    private static void calcTagPosInParagraph(String text, List<Pair<RunEdge, RunEdge>> pairs, List<String> tags) {
        String group = null;
        int start = 0;
        int end = 0;
        Matcher matcher = tagPattern.matcher(text);
        while (matcher.find()) {
            group = matcher.group();
            tags.add(group);
            start = text.indexOf(group, end);
            end = start + group.length();
            pairs.add((Pair<RunEdge, RunEdge>)new ImmutablePair((Object)new RunEdge(start, group), (Object)new RunEdge(end, group)));
        }
    }

    private static void styleRun(XWPFRun destRun, XWPFRun srcRun) {
        if (null == destRun || null == srcRun) {
            return;
        }
        destRun.setBold(srcRun.isBold());
        destRun.setColor(srcRun.getColor());
        destRun.setFontFamily(srcRun.getFontFamily());
        int fontSize = srcRun.getFontSize();
        if (-1 != fontSize) {
            destRun.setFontSize(fontSize);
        }
        destRun.setItalic(srcRun.isItalic());
        destRun.setStrike(srcRun.isStrike());
        destRun.setUnderline(srcRun.getUnderline());
    }

    public static RunTemplate parseRun(XWPFRun run) {
        String text = null;
        if (null == run || StringUtils.isBlank((CharSequence)(text = run.getText(0)))) {
            return null;
        }
        return (RunTemplate)TemplateResolver.parseTemplateFactory(text, run);
    }

    private static <T> ElementTemplate parseTemplateFactory(String text, T obj) {
        logger.debug("parse text:" + text);
        if (tagPattern.matcher(text).matches()) {
            String tag = varPattern.matcher(text).replaceAll("").trim();
            GramerSymbol parseGramer = TemplateResolver.parseGramer(tag);
            String parseTagName = TemplateResolver.parseTagName(tag);
            if (obj.getClass() == XWPFRun.class) {
                return RunTemplate.createRunTemplate(parseGramer, parseTagName, (XWPFRun)obj);
            }
            if (obj.getClass() == XWPFTableCell.class) {
                return CellTemplate.create(parseGramer, parseTagName, (XWPFTableCell)obj);
            }
        }
        return null;
    }

    public static GramerSymbol parseGramer(String tag) {
        char symbol = tag.charAt(0);
        switch (symbol) {
            case '@': {
                return GramerSymbol.IMAGE;
            }
            case '#': {
                return GramerSymbol.TABLE;
            }
        }
        return GramerSymbol.TEXT;
    }

    public static String parseTagName(String tag) {
        if (TemplateResolver.parseGramer(tag) == GramerSymbol.TEXT) {
            return tag;
        }
        return tag.substring(1);
    }
}

