/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.util.ParagraphUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenderPolicy<T>
implements RenderPolicy {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        Object model = null;
        try {
            model = data;
        }
        catch (ClassCastException e) {
            throw new RenderException("Error Render Data format for template: " + eleTemplate.getSource(), e);
        }
        RenderContext<Object> context = new RenderContext<Object>(eleTemplate, model, template);
        if (!this.validate(model)) {
            this.postValidError(context);
            return;
        }
        try {
            this.beforeRender(context);
            this.doRender(context);
            this.afterRender(context);
        }
        catch (Exception e) {
            this.reThrowException(context, e);
        }
    }

    public abstract void doRender(RenderContext<T> var1) throws Exception;

    protected boolean validate(T data) {
        return true;
    }

    protected void beforeRender(RenderContext<T> context) {
    }

    protected void afterRender(RenderContext<T> context) {
    }

    protected void reThrowException(RenderContext<T> context, Exception e) {
        throw new RenderException("Render template " + context.getEleTemplate() + " error", e);
    }

    protected void postValidError(RenderContext<T> context) {
        ValidErrorHandler errorHandler = context.getConfig().getValidErrorHandler();
        this.logger.debug("The data [{}] of the template {} is illegal, will apply error handler [{}]", new Object[]{context.getData(), context.getTagSource(), ClassUtils.getSimpleName(errorHandler.getClass())});
        errorHandler.handler(context);
    }

    public static void clearPlaceholder(RenderContext<?> context, boolean clearParagraph) {
        String paragraphText;
        XWPFRun run = context.getRun();
        IRunBody parent = run.getParent();
        String text = run.text();
        run.setText("", 0);
        if (clearParagraph && parent instanceof XWPFParagraph && text.equals(paragraphText = ParagraphUtils.trimLine((XWPFParagraph)parent))) {
            NiceXWPFDocument doc = context.getXWPFDocument();
            int pos = doc.getPosOfParagraph((XWPFParagraph)parent);
            doc.removeBodyElement(pos);
        }
    }

    public static class AbortHandler
    implements ValidErrorHandler {
        @Override
        public void handler(RenderContext<?> context) {
            throw new RenderException("Validate the data of the element " + context.getTagSource() + " error, data may be illegal: " + context.getData());
        }
    }

    public static class ClearHandler
    implements ValidErrorHandler {
        @Override
        public void handler(RenderContext<?> context) {
            AbstractRenderPolicy.clearPlaceholder(context, false);
        }
    }

    public static class DiscardHandler
    implements ValidErrorHandler {
        @Override
        public void handler(RenderContext<?> context) {
        }
    }

    public static interface ValidErrorHandler {
        public void handler(RenderContext<?> var1);
    }
}

