/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.data.HyperLinkTextRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.StyleUtils;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class TextRenderPolicy
extends AbstractRenderPolicy<Object> {
    public static final String REGEX_LINE_CHARACTOR = "\\n";

    @Override
    protected boolean validate(Object data) {
        return null != data;
    }

    @Override
    public void doRender(RenderContext<Object> context) throws Exception {
        Helper.renderTextRun(context.getRun(), context.getData());
    }

    public static class Helper {
        public static void renderTextRun(XWPFRun run, Object renderData) {
            XWPFRun textRun = run;
            if (renderData instanceof HyperLinkTextRenderData) {
                XWPFRun hyperLinkRun = NiceXWPFDocument.insertNewHyperLinkRun(run, ((HyperLinkTextRenderData)renderData).getUrl());
                run.setText("", 0);
                textRun = hyperLinkRun;
            }
            TextRenderData data = renderData instanceof TextRenderData ? (TextRenderData)renderData : new TextRenderData(renderData.toString());
            String text = null == data.getText() ? "" : data.getText();
            StyleUtils.styleRun(textRun, data.getStyle());
            String[] split = text.split(TextRenderPolicy.REGEX_LINE_CHARACTOR, -1);
            if (null != split && split.length > 0) {
                textRun.setText(split[0], 0);
                for (int i = 1; i < split.length; ++i) {
                    textRun.addCarriageReturn();
                    textRun.setText(split[i]);
                }
            }
        }
    }
}

