/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.render.compute.RenderDataCompute;
import com.deepoove.poi.render.processor.Visitor;
import com.deepoove.poi.resolver.Resolver;
import com.deepoove.poi.template.ChartTemplate;
import com.deepoove.poi.template.InlineIterableTemplate;
import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.template.PictureTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.xwpf.XWPFTextboxContent;
import java.util.HashSet;
import java.util.List;
import org.apache.xmlbeans.XmlObject;

public abstract class DefaultTemplateProcessor
implements Visitor {
    protected XWPFTemplate template;
    protected final RenderDataCompute renderDataCompute;
    protected final Resolver resolver;

    public DefaultTemplateProcessor(XWPFTemplate template, Resolver resolver, RenderDataCompute renderDataCompute) {
        this.template = template;
        this.resolver = resolver;
        this.renderDataCompute = renderDataCompute;
    }

    protected void visitOther(MetaTemplate template) {
    }

    public void process(List<MetaTemplate> templates) {
        templates.forEach(template -> template.accept(this));
        HashSet textboxs = new HashSet();
        templates.forEach(template -> {
            if (template instanceof RunTemplate && ((RunTemplate)template).getRun().getParagraph().getBody() instanceof XWPFTextboxContent) {
                textboxs.add((XWPFTextboxContent)((RunTemplate)template).getRun().getParagraph().getBody());
            }
        });
        textboxs.forEach(content -> content.getXmlObject().set((XmlObject)content.getCTTxbxContent()));
    }

    @Override
    public void visit(InlineIterableTemplate iterableTemplate) {
        this.visitOther(iterableTemplate);
    }

    @Override
    public void visit(RunTemplate runTemplate) {
        this.visitOther(runTemplate);
    }

    @Override
    public void visit(PictureTemplate pictureTemplate) {
        this.visitOther(pictureTemplate);
    }

    @Override
    public void visit(ChartTemplate chartTemplate) {
        this.visitOther(chartTemplate);
    }

    @Override
    public void visit(IterableTemplate iterableTemplate) {
        this.visitOther(iterableTemplate);
    }
}

