/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.NumberingWrapper;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;

public class NumberingContinue {
    private Map<BigInteger, BigInteger> consistCache = new HashMap<BigInteger, BigInteger>();
    private BigInteger continueNumID;

    public NumberingContinue() {
    }

    public NumberingContinue(BigInteger numID) {
        this.continueNumID = numID;
    }

    public static NumberingContinue of(BodyContainer bodyContainer, int start, int end, IterableTemplate iterable) {
        if (start + 1 >= end) {
            return new NumberingContinue();
        }
        List<IBodyElement> elements = bodyContainer.getBodyElements().subList(start + 1, end);
        if (elements.isEmpty()) {
            return new NumberingContinue();
        }
        CTNumPr first = null;
        int firstPos = -1;
        for (IBodyElement element : elements) {
            XWPFParagraph paragraph;
            CTP ctp;
            if (element.getElementType() != BodyElementType.PARAGRAPH || (ctp = (paragraph = (XWPFParagraph)element).getCTP()).getPPr() == null || ctp.getPPr().getNumPr() == null) continue;
            CTNumPr numPr = ctp.getPPr().getNumPr();
            if (null == first) {
                first = numPr;
                firstPos = bodyContainer.getPosOfParagraphCTP(ctp);
                continue;
            }
            if (!Objects.equals(numPr.getIlvl().getVal(), first.getIlvl().getVal()) || !Objects.equals(numPr.getNumId().getVal(), first.getNumId().getVal())) continue;
            first = null;
            break;
        }
        if (null == first) {
            return new NumberingContinue();
        }
        List<MetaTemplate> templates = iterable.getTemplates();
        for (MetaTemplate template : templates) {
            if (!(template instanceof IterableTemplate)) continue;
            CTP startCtp = ((XWPFParagraph)((IterableTemplate)template).getStartRun().getParent()).getCTP();
            CTP endCtp = ((XWPFParagraph)((IterableTemplate)template).getEndRun().getParent()).getCTP();
            int startPos = bodyContainer.getPosOfParagraphCTP(startCtp);
            if (startPos >= firstPos) break;
            int endPos = bodyContainer.getPosOfParagraphCTP(endCtp);
            if (firstPos <= startPos || firstPos >= endPos) continue;
            return new NumberingContinue();
        }
        return new NumberingContinue(first.getNumId().getVal());
    }

    public NumberingContinue resetCache() {
        this.consistCache.clear();
        return this;
    }

    public void updateNumbering(XWPFParagraph source, XWPFParagraph target) {
        XWPFDocument document = source.getDocument();
        XWPFNumbering numbering = document.getNumbering();
        if (null == numbering) {
            return;
        }
        BigInteger numID = source.getNumID();
        if (numID == null) {
            return;
        }
        if (null != this.continueNumID && numID.equals(this.continueNumID)) {
            return;
        }
        if (this.consistCache.get(numID) != null) {
            target.setNumID(this.consistCache.get(numID));
            return;
        }
        NumberingWrapper wrapper = new NumberingWrapper(numbering);
        XWPFNum num = numbering.getNum(numID);
        if (null == num) {
            return;
        }
        XWPFAbstractNum abstractNum = numbering.getAbstractNum(num.getCTNum().getAbstractNumId().getVal());
        CTAbstractNum ctAbstractNum = (CTAbstractNum)abstractNum.getAbstractNum().copy();
        ctAbstractNum.setAbstractNumId(wrapper.getNextAbstractNumID());
        if (ctAbstractNum.isSetNsid()) {
            ctAbstractNum.unsetNsid();
        }
        if (ctAbstractNum.isSetTmpl()) {
            ctAbstractNum.unsetTmpl();
        }
        BigInteger abstractNumID = numbering.addAbstractNum(new XWPFAbstractNum(ctAbstractNum));
        BigInteger newNumId = numbering.addNum(abstractNumID);
        target.setNumID(newNumId);
        this.consistCache.put(numID, newNumId);
    }
}

