/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.online.aop;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.AopTargetUtil;
import com.dic.bid.common.flow.dao.FlowTransProducerMapper;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowTransProducer;
import com.dic.bid.common.flow.online.object.TransactionalFlowBusinessData;
import java.util.Collection;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FlowMultiDatabaseWriteAspect {
    private static final Logger log = LoggerFactory.getLogger(FlowMultiDatabaseWriteAspect.class);
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private FlowTransProducerMapper flowTransProducerMapper;

    @Pointcut(value="execution(public * com.dic.bid.common.flow..service.impl..*(..)) && @annotation(com.dic.bid.common.core.annotation.MultiDatabaseWriteMethod)")
    public void multiDatabaseWriteMethodPointCut() {
    }

    @Around(value="multiDatabaseWriteMethodPointCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        String initMethod = AopTargetUtil.getFullMethodName((ProceedingJoinPoint)joinPoint);
        TransactionalFlowBusinessData data = TransactionalFlowBusinessData.getOrCreateFromRequestAttribute();
        if (data.getInitMethod() == null) {
            data.setInitMethod(initMethod);
        }
        try {
            Object result = joinPoint.proceed();
            if (StrUtil.equals((CharSequence)initMethod, (CharSequence)data.getInitMethod()) && CollUtil.isNotEmpty((Collection)data.getSqlDataList())) {
                this.fillupTransactionalBusinessData();
                FlowTransProducer producerData = (FlowTransProducer)BeanUtil.copyProperties((Object)((Object)data), FlowTransProducer.class, (String[])new String[0]);
                producerData.setAppCode(TokenData.takeFromRequest().getAppCode());
                producerData.setTryTimes(Integer.valueOf(1));
                String sqlData = JSON.toJSONStringWithDateFormat((Object)data.getSqlDataList(), (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
                producerData.setSqlData(sqlData);
                this.flowTransProducerMapper.insert((Object)producerData);
                this.eventPublisher.publishEvent((Object)data);
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            TransactionalFlowBusinessData.removeFromRequestAttribute();
            throw e;
        }
        finally {
            if (StrUtil.equals((CharSequence)initMethod, (CharSequence)data.getInitMethod())) {
                TransactionalFlowBusinessData.removeFromRequestAttribute();
            }
        }
    }

    private void fillupTransactionalBusinessData() {
        FlowTaskComment comment = FlowTaskComment.getFromRequest();
        TransactionalFlowBusinessData data = TransactionalFlowBusinessData.getFromRequestAttribute();
        if (comment != null) {
            data.setProcessInstanceId(comment.getProcessInstanceId());
            data.setTaskId(comment.getTaskId());
            data.setTaskKey(comment.getTaskKey());
            data.setTaskName(comment.getTaskName());
            data.setTaskComment(comment.getTaskComment());
        }
    }
}

