/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.online.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class FlowMultiDatabaseWriteExAspect {
    private static final Logger log = LoggerFactory.getLogger(FlowMultiDatabaseWriteExAspect.class);

    @Pointcut(value="execution(public * com.dic.bid.common.flow.online.service.impl..*(..)) && @annotation(com.dic.bid.common.core.annotation.MultiDatabaseWriteMethod)")
    public void multiDatabaseWriteMethodPointCut() {
    }

    @Around(value="multiDatabaseWriteMethodPointCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            return joinPoint.proceed();
        }
        catch (Exception e) {
            log.error("FlowMultiDatabaseWriteExAspect throw", (Throwable)e);
            throw e;
        }
    }
}

