/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.online.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.annotation.DisableDataFilter;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.constant.ErrorCodeEnum;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.core.object.GlobalThreadLocal;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.object.Tuple2;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.core.util.MyPageUtil;
import com.dic.bid.common.flow.constant.FlowTaskStatus;
import com.dic.bid.common.flow.dto.FlowTaskCommentDto;
import com.dic.bid.common.flow.dto.FlowWorkOrderDto;
import com.dic.bid.common.flow.exception.FlowOperationException;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.model.FlowEntryPublish;
import com.dic.bid.common.flow.model.FlowMessage;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowTransProducer;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.model.FlowWorkOrderExt;
import com.dic.bid.common.flow.online.service.FlowOnlineOperationService;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.service.FlowMessageService;
import com.dic.bid.common.flow.service.FlowTransProducerService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.util.FlowOperationHelper;
import com.dic.bid.common.flow.vo.FlowEntryVo;
import com.dic.bid.common.flow.vo.FlowTaskVo;
import com.dic.bid.common.flow.vo.FlowWorkOrderVo;
import com.dic.bid.common.flow.vo.TaskInfoVo;
import com.dic.bid.common.log.annotation.OperationLog;
import com.dic.bid.common.online.config.OnlineProperties;
import com.dic.bid.common.online.dto.OnlineFilterDto;
import com.dic.bid.common.online.model.OnlineColumn;
import com.dic.bid.common.online.model.OnlineDatasource;
import com.dic.bid.common.online.model.OnlineDatasourceRelation;
import com.dic.bid.common.online.model.OnlineForm;
import com.dic.bid.common.online.model.OnlineFormDatasource;
import com.dic.bid.common.online.model.OnlinePageDatasource;
import com.dic.bid.common.online.model.OnlineTable;
import com.dic.bid.common.online.service.OnlineDatasourceService;
import com.dic.bid.common.online.service.OnlineFormService;
import com.dic.bid.common.online.service.OnlineOperationService;
import com.dic.bid.common.online.service.OnlinePageService;
import com.dic.bid.common.online.service.OnlineTableService;
import com.dic.bid.common.online.util.OnlineOperationHelper;
import com.dic.bid.common.redis.cache.SessionCacheHelper;
import com.dic.bid.common.satoken.annotation.SaTokenDenyAuth;
import com.github.pagehelper.page.PageMethod;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u5de5\u4f5c\u6d41\u5728\u7ebf\u8868\u5355\u6d41\u7a0b\u64cd\u4f5c\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-flow.urlPrefix}/flowOnlineOperation"})
@ConditionalOnProperty(name={"common-flow.operationEnabled"}, havingValue="true")
public class FlowOnlineOperationController {
    private static final Logger log = LoggerFactory.getLogger(FlowOnlineOperationController.class);
    @Autowired
    private FlowEntryService flowEntryService;
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowOperationHelper flowOperationHelper;
    @Autowired
    private FlowOnlineOperationService flowOnlineOperationService;
    @Autowired
    private FlowWorkOrderService flowWorkOrderService;
    @Autowired
    private FlowMessageService flowMessageService;
    @Autowired
    private FlowTransProducerService flowTransProducerService;
    @Autowired
    private OnlineFormService onlineFormService;
    @Autowired
    private OnlinePageService onlinePageService;
    @Autowired
    private OnlineOperationService onlineOperationService;
    @Autowired
    private OnlineTableService onlineTableService;
    @Autowired
    private OnlineDatasourceService onlineDatasourceService;
    @Autowired
    private OnlineOperationHelper onlineOperationHelper;
    @Autowired
    private OnlineProperties onlineProperties;
    @Autowired
    private SessionCacheHelper sessionCacheHelper;
    private static final String ONE_TO_MANY_VAR_SUFFIX = "List";

    @DisableDataFilter
    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=100)
    @PostMapping(value={"/startPreview"})
    public ResponseResult<Void> startPreview(@MyRequestBody(required=true) String processDefinitionKey, @MyRequestBody(required=true) FlowTaskCommentDto flowTaskCommentDto, @MyRequestBody JSONObject taskVariableData, @MyRequestBody(required=true) JSONObject masterData, @MyRequestBody JSONObject slaveData, @MyRequestBody JSONObject copyData) {
        return this.startAndTake(processDefinitionKey, flowTaskCommentDto, taskVariableData, masterData, slaveData, copyData);
    }

    @DisableDataFilter
    @OperationLog(type=100)
    @PostMapping(value={"/startWithBusinessKey"})
    public ResponseResult<Void> startWithBusinessKey(@MyRequestBody(required=true) String processDefinitionKey, @MyRequestBody(required=true) String id) {
        ResponseResult<Tuple2<FlowEntryPublish, OnlineDatasource>> verifyResult = this.verifyAndGetFlowEntryPublishAndDatasource(processDefinitionKey, false);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        OnlineDatasource datasource = (OnlineDatasource)((Tuple2)verifyResult.getData()).getSecond();
        if (!this.onlineOperationService.existId(datasource.getMasterTable(), id)) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        if (this.flowWorkOrderService.existUnfinished(processDefinitionKey, (Object)id)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u4e1a\u52a1\u6570\u636eId\u5b58\u5728\u5c1a\u672a\u5b8c\u6210\u5ba1\u6279\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u540c\u4e00\u4e1a\u52a1\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u540c\u65f6\u91cd\u590d\u63d0\u4ea4\u5ba1\u6279\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        this.flowOnlineOperationService.startWithBusinessKey(((FlowEntryPublish)((Tuple2)verifyResult.getData()).getFirst()).getProcessDefinitionId(), datasource.getMasterTableId(), id);
        return ResponseResult.success();
    }

    @DisableDataFilter
    @SaTokenDenyAuth
    @OperationLog(type=100)
    @PostMapping(value={"/startAndTakeUserTask/{processDefinitionKey}"})
    public ResponseResult<Void> startAndTakeUserTask(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody(required=true) FlowTaskCommentDto flowTaskCommentDto, @MyRequestBody JSONObject taskVariableData, @MyRequestBody(required=true) JSONObject masterData, @MyRequestBody JSONObject slaveData, @MyRequestBody JSONObject copyData) {
        return this.startAndTake(processDefinitionKey, flowTaskCommentDto, taskVariableData, masterData, slaveData, copyData);
    }

    @DisableDataFilter
    @SaTokenDenyAuth
    @PostMapping(value={"/startAndSaveDraft/{processDefinitionKey}"})
    public ResponseResult<FlowTaskVo> startAndSaveDraft(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody String processInstanceId, @MyRequestBody JSONObject masterData, @MyRequestBody JSONObject slaveData) {
        FlowWorkOrder flowWorkOrder;
        if (MapUtil.isEmpty((Map)masterData) && MapUtil.isEmpty((Map)slaveData)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e1a\u52a1\u6570\u636e\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        ResponseResult<Tuple2<FlowEntryPublish, OnlineDatasource>> verifyResult = this.verifyAndGetFlowEntryPublishAndDatasource(processDefinitionKey, true);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowEntryPublish flowEntryPublish = (FlowEntryPublish)((Tuple2)verifyResult.getData()).getFirst();
        OnlineTable masterTable = ((OnlineDatasource)((Tuple2)verifyResult.getData()).getSecond()).getMasterTable();
        for (OnlineColumn column : masterTable.getColumnMap().values()) {
            if (ObjectUtil.equals((Object)column.getFieldKind(), (Object)21)) {
                masterData.put(column.getColumnName(), (Object)TokenData.takeFromRequest().getUserId());
                continue;
            }
            if (!ObjectUtil.equals((Object)column.getFieldKind(), (Object)19)) continue;
            masterData.put(column.getColumnName(), (Object)TokenData.takeFromRequest().getDeptId());
        }
        if (processInstanceId == null) {
            flowWorkOrder = this.flowOnlineOperationService.saveNewDraftAndStartProcess(flowEntryPublish.getProcessDefinitionId(), masterTable.getTableId(), masterData, slaveData);
        } else {
            ResponseResult flowWorkOrderResult = this.flowOperationHelper.verifyAndGetFlowWorkOrderWithDraft(processDefinitionKey, processInstanceId);
            if (!flowWorkOrderResult.isSuccess()) {
                return ResponseResult.errorFrom((ResponseResult)flowWorkOrderResult);
            }
            flowWorkOrder = (FlowWorkOrder)flowWorkOrderResult.getData();
            this.flowWorkOrderService.updateDraft(((FlowWorkOrder)flowWorkOrderResult.getData()).getWorkOrderId(), JSON.toJSONString((Object)masterData), JSON.toJSONString((Object)slaveData));
        }
        List taskList = this.flowApiService.getProcessInstanceActiveTaskList(flowWorkOrder.getProcessInstanceId());
        List flowTaskVoList = this.flowApiService.convertToFlowTaskList(taskList);
        return ResponseResult.success(flowTaskVoList.get(0));
    }

    @DisableDataFilter
    @OperationLog(type=120)
    @PostMapping(value={"/submitUserTask"})
    public ResponseResult<Void> submitUserTask(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) FlowTaskCommentDto flowTaskCommentDto, @MyRequestBody JSONObject taskVariableData, @MyRequestBody JSONObject masterData, @MyRequestBody JSONObject slaveData, @MyRequestBody JSONObject copyData) {
        Task task = this.flowApiService.getProcessInstanceActiveTask(processInstanceId, taskId);
        ResponseResult taskInfoResult = this.flowOperationHelper.verifyAndGetRuntimeTaskInfo(task);
        if (!taskInfoResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)taskInfoResult);
        }
        TaskInfoVo taskInfo = (TaskInfoVo)taskInfoResult.getData();
        ResponseResult<OnlineDatasource> datasourceResult = this.verifyAndGetOnlineDatasource(taskInfo.getFormId());
        if (!datasourceResult.isSuccess()) {
            return ResponseResult.errorFrom(datasourceResult);
        }
        CallResult assigneeVerifyResult = this.flowApiService.verifyAssigneeOrCandidateAndClaim(task);
        if (!assigneeVerifyResult.isSuccess()) {
            return ResponseResult.errorFrom((CallResult)assigneeVerifyResult);
        }
        OnlineDatasource datasource = (OnlineDatasource)datasourceResult.getData();
        ProcessInstance instance = this.flowApiService.getProcessInstance(processInstanceId);
        String dataId = instance.getBusinessKey();
        if (MapUtil.isNotEmpty((Map)copyData)) {
            if (taskVariableData == null) {
                taskVariableData = new JSONObject();
            }
            taskVariableData.put("copyDataKey", (Object)copyData);
        }
        this.onlineOperationHelper.enableOnlineExtendExecutor(datasource.getDatasourceId());
        FlowTaskComment flowTaskComment = (FlowTaskComment)BeanUtil.copyProperties((Object)flowTaskCommentDto, FlowTaskComment.class, (String[])new String[0]);
        if (StrUtil.isBlank((CharSequence)dataId)) {
            return this.submitNewTask(processInstanceId, taskId, flowTaskComment, taskVariableData, datasource, masterData, slaveData);
        }
        try {
            if (StrUtil.equals((CharSequence)flowTaskComment.getApprovalType(), (CharSequence)"transfer") && StrUtil.isBlank((CharSequence)flowTaskComment.getDelegateAssignee())) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u52a0\u7b7e\u6216\u8f6c\u529e\u4efb\u52a1\u6307\u6d3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
            ResponseResult slaveDataListResult = this.onlineOperationHelper.buildSlaveDataList(datasource.getDatasourceId(), slaveData);
            if (!slaveDataListResult.isSuccess()) {
                return ResponseResult.errorFrom((ResponseResult)slaveDataListResult);
            }
            this.flowOnlineOperationService.updateAndTakeTask(task, flowTaskComment, taskVariableData, datasource, masterData, dataId, (Map)slaveDataListResult.getData());
        }
        catch (FlowOperationException e) {
            log.error("Failed to call [FlowOnlineOperationService.updateAndTakeTask]", (Throwable)e);
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)e.getMessage());
        }
        return ResponseResult.success();
    }

    @DisableDataFilter
    @GetMapping(value={"/viewDraftData"})
    public ResponseResult<JSONObject> viewDraftData(@RequestParam String processDefinitionKey, @RequestParam String processInstanceId) {
        ResponseResult flowWorkOrderResult = this.flowOperationHelper.verifyAndGetFlowWorkOrderWithDraft(processDefinitionKey, processInstanceId);
        if (!flowWorkOrderResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)flowWorkOrderResult);
        }
        FlowWorkOrder flowWorkOrder = (FlowWorkOrder)flowWorkOrderResult.getData();
        if (flowWorkOrder.getOnlineTableId() == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5de5\u5355\u4e0d\u662f\u5728\u7ebf\u8868\u5355\u5de5\u5355\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowWorkOrderExt flowWorkOrderExt = this.flowWorkOrderService.getFlowWorkOrderExtByWorkOrderId(flowWorkOrder.getWorkOrderId());
        if (StrUtil.isBlank((CharSequence)flowWorkOrderExt.getDraftData())) {
            return ResponseResult.success(null);
        }
        Long tableId = flowWorkOrder.getOnlineTableId();
        OnlineTable masterTable = this.onlineTableService.getOnlineTableFromCache(tableId);
        JSONObject draftData = JSON.parseObject((String)flowWorkOrderExt.getDraftData());
        JSONObject masterData = draftData.getJSONObject("masterData");
        JSONObject slaveData = draftData.getJSONObject("slaveData");
        OnlineDatasource datasource = this.onlineDatasourceService.getOnlineDatasourceByMasterTableId(tableId);
        List slaveRelationList = null;
        if (slaveData != null) {
            ResponseResult relationListResult = this.onlineOperationHelper.verifyAndGetRelationList(datasource.getDatasourceId(), null);
            if (!relationListResult.isSuccess()) {
                return ResponseResult.errorFrom((ResponseResult)relationListResult);
            }
            slaveRelationList = (List)relationListResult.getData();
        }
        datasource.setMasterTable(masterTable);
        JSONObject jsonData = this.buildDraftData(datasource, masterData, slaveRelationList, slaveData);
        return ResponseResult.success((Object)jsonData);
    }

    @DisableDataFilter
    @GetMapping(value={"/viewUserTask"})
    public ResponseResult<JSONObject> viewUserTask(@RequestParam String processInstanceId, @RequestParam String taskId) {
        Task task = this.flowApiService.getProcessInstanceActiveTask(processInstanceId, taskId);
        ProcessInstance instance = this.flowApiService.getProcessInstance(processInstanceId);
        if (StrUtil.isBlank((CharSequence)instance.getBusinessKey())) {
            return ResponseResult.success(null);
        }
        ResponseResult taskInfoResult = this.flowOperationHelper.verifyAndGetRuntimeTaskInfo(task);
        if (!taskInfoResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)taskInfoResult);
        }
        TaskInfoVo taskInfo = (TaskInfoVo)taskInfoResult.getData();
        ResponseResult<OnlineDatasource> datasourceResult = this.verifyAndGetOnlineDatasource(taskInfo.getFormId());
        if (!datasourceResult.isSuccess()) {
            return ResponseResult.errorFrom(datasourceResult);
        }
        ResponseResult relationListResult = this.onlineOperationHelper.verifyAndGetRelationList(((OnlineDatasource)datasourceResult.getData()).getDatasourceId(), null);
        if (!relationListResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)relationListResult);
        }
        JSONObject jsonData = this.buildUserTaskData(instance.getBusinessKey(), (OnlineDatasource)datasourceResult.getData(), (List)relationListResult.getData());
        return ResponseResult.success((Object)jsonData);
    }

    @DisableDataFilter
    @GetMapping(value={"/viewHistoricProcessInstance"})
    public ResponseResult<JSONObject> viewHistoricProcessInstance(@RequestParam String processInstanceId, @RequestParam(required=false) String taskId) {
        ResponseResult verifyResult = this.flowOperationHelper.verifyAndGetHistoricProcessInstance(processInstanceId, taskId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)verifyResult);
        }
        HistoricProcessInstance instance = (HistoricProcessInstance)verifyResult.getData();
        if (StrUtil.isBlank((CharSequence)instance.getBusinessKey())) {
            return ResponseResult.success((Object)new JSONObject());
        }
        FlowEntryPublish flowEntryPublish = (FlowEntryPublish)this.flowEntryService.getFlowEntryPublishList((Set)CollUtil.newHashSet((Object[])new String[]{instance.getProcessDefinitionId()})).get(0);
        TaskInfoVo taskInfoVo = (TaskInfoVo)JSON.parseObject((String)flowEntryPublish.getInitTaskInfo(), TaskInfoVo.class);
        ResponseResult<OnlineDatasource> datasourceResult = this.verifyAndGetOnlineDatasource(taskInfoVo.getFormId());
        if (!datasourceResult.isSuccess()) {
            return ResponseResult.errorFrom(datasourceResult);
        }
        ResponseResult relationListResult = this.onlineOperationHelper.verifyAndGetRelationList(((OnlineDatasource)datasourceResult.getData()).getDatasourceId(), null);
        if (!relationListResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)relationListResult);
        }
        JSONObject jsonData = this.buildUserTaskData(instance.getBusinessKey(), (OnlineDatasource)datasourceResult.getData(), (List)relationListResult.getData());
        return ResponseResult.success((Object)jsonData);
    }

    @DisableDataFilter
    @GetMapping(value={"/viewCopyBusinessData"})
    public ResponseResult<JSONObject> viewCopyBusinessData(@RequestParam Long messageId) {
        FlowMessage flowMessage = (FlowMessage)this.flowMessageService.getById((Serializable)messageId);
        if (flowMessage == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        if (flowMessage.getMessageType() != 1) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d88\u606f\u4e0d\u662f\u6284\u9001\u7c7b\u578b\u6d88\u606f\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (flowMessage.getOnlineFormData() == null || !flowMessage.getOnlineFormData().booleanValue()) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d88\u606f\u4e3a\u9759\u6001\u8def\u7531\u8868\u5355\u6570\u636e\uff0c\u4e0d\u80fd\u901a\u8fc7\u8be5\u63a5\u53e3\u83b7\u53d6\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!this.flowMessageService.isCandidateIdentityOnMessage(messageId)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6d88\u606f\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        HistoricProcessInstance instance = this.flowApiService.getHistoricProcessInstance(flowMessage.getProcessInstanceId());
        if (StrUtil.isBlank((CharSequence)instance.getBusinessKey())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d88\u606f\u4e3a\u6240\u5c5e\u6d41\u7a0b\u5b9e\u4f8b\u6ca1\u6709\u5305\u542b\u4e1a\u52a1\u4e3b\u952eId\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        Long formId = Long.valueOf(flowMessage.getBusinessDataShot());
        ResponseResult<OnlineDatasource> datasourceResult = this.verifyAndGetOnlineDatasource(formId);
        if (!datasourceResult.isSuccess()) {
            return ResponseResult.errorFrom(datasourceResult);
        }
        OnlineDatasource datasource = (OnlineDatasource)datasourceResult.getData();
        ResponseResult relationListResult = this.onlineOperationHelper.verifyAndGetRelationList(datasource.getDatasourceId(), null);
        if (!relationListResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)relationListResult);
        }
        JSONObject jsonData = this.buildUserTaskData(instance.getBusinessKey(), datasource, (List)relationListResult.getData());
        this.flowMessageService.readCopyTask(messageId);
        return ResponseResult.success((Object)jsonData);
    }

    @SaCheckPermission(value={"flowOperation.all"})
    @OperationLog(type=127)
    @PostMapping(value={"/fixBusinessData"})
    public ResponseResult<Void> fixBusinessData(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) Long transId) {
        FlowTransProducer transProducer = (FlowTransProducer)this.flowTransProducerService.getById((Serializable)transId);
        if (transProducer == null) {
            String errorMessage = "\u6570\u636e\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u6570\u636e\u4fee\u590d\u6d41\u6c34\u53f7Id\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        if (!StrUtil.equals((CharSequence)processInstanceId, (CharSequence)transProducer.getProcessInstanceId())) {
            String errorMessage = "\u6570\u636e\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u6570\u636e\u4fee\u590d\u6d41\u6c34\u53f7Id\u4e0e\u6d41\u7a0b\u5b9e\u4f8bId\u4e0d\u5339\u914d\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        this.flowOnlineOperationService.fixBusinessData(transProducer);
        this.flowTransProducerService.removeById((Serializable)transProducer.getTransId());
        return ResponseResult.success();
    }

    @SaTokenDenyAuth
    @PostMapping(value={"/listWorkOrder/{processDefinitionKey}"})
    public ResponseResult<MyPageData<FlowWorkOrderVo>> listWorkOrder(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody FlowWorkOrderDto flowWorkOrderDtoFilter, @MyRequestBody MyPageParam pageParam, @MyRequestBody String ignoreMaskFields) {
        if (pageParam != null) {
            PageMethod.startPage((int)pageParam.getPageNum(), (int)pageParam.getPageSize(), (boolean)pageParam.getCount());
        }
        FlowWorkOrder flowWorkOrderFilter = this.flowOperationHelper.makeWorkOrderFilter(flowWorkOrderDtoFilter, processDefinitionKey);
        MyOrderParam orderParam = new MyOrderParam();
        orderParam.add((Object)new MyOrderParam.OrderInfo("workOrderId", Boolean.valueOf(false), null));
        String orderBy = MyOrderParam.buildOrderBy((MyOrderParam)orderParam, FlowWorkOrder.class);
        List flowWorkOrderList = this.flowWorkOrderService.getFlowWorkOrderList(flowWorkOrderFilter, orderBy);
        MyPageData resultData = MyPageUtil.makeResponseData((List)flowWorkOrderList, FlowWorkOrderVo.class);
        this.flowOperationHelper.buildWorkOrderApprovalStatus(processDefinitionKey, resultData.getDataList());
        this.flowWorkOrderService.fillUserShowNameByLoginName(resultData.getDataList());
        GlobalThreadLocal.setDataFilter((boolean)false);
        ResponseResult<Void> responseResult = this.makeWorkOrderTaskInfo(resultData.getDataList(), ignoreMaskFields);
        if (!responseResult.isSuccess()) {
            return ResponseResult.errorFrom(responseResult);
        }
        return ResponseResult.success((Object)resultData);
    }

    @DisableDataFilter
    @OperationLog(type=50, saveResponse=false)
    @PostMapping(value={"/upload"})
    public void upload(@RequestParam String processDefinitionKey, @RequestParam(required=false) String processInstanceId, @RequestParam(required=false) String taskId, @RequestParam Long datasourceId, @RequestParam(required=false) Long relationId, @RequestParam String fieldName, @RequestParam Boolean asImage, @RequestParam(value="uploadFile") MultipartFile uploadFile) throws IOException {
        ResponseResult<String> verifyResult = this.verifyUploadOrDownload(processDefinitionKey, processInstanceId, taskId, datasourceId);
        if (!verifyResult.isSuccess()) {
            ResponseResult.output((int)403, (ResponseResult)ResponseResult.errorFrom(verifyResult));
            return;
        }
        ResponseResult<OnlineTable> verifyTableResult = this.verifyAndGetOnlineTable(datasourceId, relationId, null, null);
        if (!verifyTableResult.isSuccess()) {
            ResponseResult.output((int)403, (ResponseResult)ResponseResult.errorFrom(verifyTableResult));
            return;
        }
        this.onlineOperationHelper.doUpload((OnlineTable)verifyTableResult.getData(), fieldName, asImage, uploadFile);
    }

    @DisableDataFilter
    @OperationLog(type=55, saveResponse=false)
    @GetMapping(value={"/download"})
    public void download(@RequestParam String processDefinitionKey, @RequestParam(required=false) String processInstanceId, @RequestParam(required=false) String taskId, @RequestParam Long datasourceId, @RequestParam(required=false) Long relationId, @RequestParam(required=false) String dataId, @RequestParam String fieldName, @RequestParam String filename, @RequestParam Boolean asImage, HttpServletResponse response) throws IOException {
        ResponseResult<String> verifyResult = this.verifyUploadOrDownload(processDefinitionKey, processInstanceId, taskId, datasourceId);
        if (!verifyResult.isSuccess()) {
            ResponseResult.output((int)403, (ResponseResult)ResponseResult.errorFrom(verifyResult));
            return;
        }
        ResponseResult<OnlineTable> verifyTableResult = this.verifyAndGetOnlineTable(datasourceId, relationId, (String)verifyResult.getData(), dataId);
        if (!verifyTableResult.isSuccess()) {
            ResponseResult.output((int)403, (ResponseResult)ResponseResult.errorFrom(verifyTableResult));
            return;
        }
        this.onlineOperationHelper.doDownload((OnlineTable)verifyTableResult.getData(), dataId, fieldName, filename, asImage, response);
    }

    @GetMapping(value={"/listFlowEntryForm"})
    public ResponseResult<List<FlowEntryVo>> listFlowEntryForm() {
        List flowEntryList = this.flowEntryService.getFlowEntryList(null, null);
        List flowEntryVoList = MyModelUtil.copyCollectionTo((Collection)flowEntryList, FlowEntryVo.class);
        if (CollUtil.isNotEmpty((Collection)flowEntryVoList)) {
            Set pageIdSet = flowEntryVoList.stream().map(FlowEntryVo::getPageId).collect(Collectors.toSet());
            List formList = this.onlineFormService.getOnlineFormListByPageIds(pageIdSet);
            formList.forEach(f -> f.setWidgetJson(null));
            Map<Long, List<OnlineForm>> formMap = formList.stream().collect(Collectors.groupingBy(OnlineForm::getPageId));
            for (FlowEntryVo flowEntryVo : flowEntryVoList) {
                List<OnlineForm> flowEntryFormList = formMap.get(flowEntryVo.getPageId());
                flowEntryVo.setFormList(MyModelUtil.beanToMapList(flowEntryFormList));
            }
        }
        return ResponseResult.success((Object)flowEntryVoList);
    }

    @GetMapping(value={"/calculatePermData"})
    public ResponseResult<List<Map<String, Object>>> calculatePermData(@RequestParam Set<Long> onlineFlowEntryIds) {
        return ResponseResult.success(this.flowOnlineOperationService.calculatePermData(onlineFlowEntryIds));
    }

    private ResponseResult<Void> startAndTake(String processDefinitionKey, FlowTaskCommentDto flowTaskCommentDto, JSONObject taskVariableData, JSONObject masterData, JSONObject slaveData, JSONObject copyData) {
        ResponseResult<Tuple2<FlowEntryPublish, OnlineDatasource>> verifyResult = this.verifyAndGetFlowEntryPublishAndDatasource(processDefinitionKey, true);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowEntryPublish flowEntryPublish = (FlowEntryPublish)((Tuple2)verifyResult.getData()).getFirst();
        OnlineDatasource datasource = (OnlineDatasource)((Tuple2)verifyResult.getData()).getSecond();
        OnlineTable masterTable = datasource.getMasterTable();
        if (MapUtil.isNotEmpty((Map)copyData)) {
            if (taskVariableData == null) {
                taskVariableData = new JSONObject();
            }
            taskVariableData.put("copyDataKey", (Object)copyData);
        }
        FlowTaskComment flowTaskComment = (FlowTaskComment)BeanUtil.copyProperties((Object)flowTaskCommentDto, FlowTaskComment.class, (String[])new String[0]);
        this.onlineOperationHelper.enableOnlineExtendExecutor(datasource.getDatasourceId());
        if (slaveData == null) {
            this.flowOnlineOperationService.saveNewAndStartProcess(flowEntryPublish.getProcessDefinitionId(), flowTaskComment, taskVariableData, masterTable, masterData);
        } else {
            ResponseResult slaveDataListResult = this.onlineOperationHelper.buildSlaveDataList(datasource.getDatasourceId(), slaveData);
            if (!slaveDataListResult.isSuccess()) {
                return ResponseResult.errorFrom((ResponseResult)slaveDataListResult);
            }
            this.flowOnlineOperationService.saveNewAndStartProcess(flowEntryPublish.getProcessDefinitionId(), flowTaskComment, taskVariableData, masterTable, masterData, (Map)slaveDataListResult.getData());
        }
        return ResponseResult.success();
    }

    private ResponseResult<OnlineDatasource> verifyAndGetOnlineDatasource(Long formId) {
        List formDatasourceList = this.onlineFormService.getFormDatasourceListFromCache(formId);
        if (CollUtil.isEmpty((Collection)formDatasourceList)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6d41\u7a0b\u4efb\u52a1\u7ed1\u5b9a\u7684\u5728\u7ebf\u8868\u5355Id [" + formId + "] \u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u6d41\u7a0b\u56fe\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return this.onlineOperationHelper.verifyAndGetDatasource(((OnlineFormDatasource)formDatasourceList.get(0)).getDatasourceId());
    }

    private ResponseResult<Tuple2<FlowEntryPublish, OnlineDatasource>> verifyAndGetFlowEntryPublishAndDatasource(String processDefinitionKey, boolean checkStarter) {
        ResponseResult flowEntryResult = this.flowOperationHelper.verifyAndGetFlowEntry(processDefinitionKey);
        if (!flowEntryResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)flowEntryResult);
        }
        FlowEntryPublish flowEntryPublish = ((FlowEntry)flowEntryResult.getData()).getMainFlowEntryPublish();
        if (BooleanUtil.isFalse((Boolean)flowEntryPublish.getActiveStatus())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u53d1\u5e03\u5bf9\u8c61\u5df2\u88ab\u6302\u8d77\uff0c\u4e0d\u80fd\u542f\u52a8\u65b0\u6d41\u7a0b\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        ResponseResult taskInfoResult = this.flowOperationHelper.verifyAndGetInitialTaskInfo(flowEntryPublish, checkStarter);
        if (!taskInfoResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)taskInfoResult);
        }
        TaskInfoVo taskInfo = (TaskInfoVo)taskInfoResult.getData();
        ResponseResult<OnlineDatasource> datasourceResult = this.verifyAndGetOnlineDatasource(taskInfo.getFormId());
        if (!datasourceResult.isSuccess()) {
            return ResponseResult.errorFrom(datasourceResult);
        }
        return ResponseResult.success((Object)new Tuple2((Object)flowEntryPublish, datasourceResult.getData()));
    }

    private ResponseResult<OnlineTable> verifyAndGetOnlineTable(Long datasourceId, Long relationId, String businessKey, String dataId) {
        OnlineTable masterTable;
        ResponseResult datasourceResult = this.onlineOperationHelper.verifyAndGetDatasource(datasourceId);
        if (!datasourceResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)datasourceResult);
        }
        OnlineTable table = masterTable = ((OnlineDatasource)datasourceResult.getData()).getMasterTable();
        ResponseResult relationResult = null;
        if (relationId != null) {
            relationResult = this.onlineOperationHelper.verifyAndGetRelation(datasourceId, relationId);
            if (!relationResult.isSuccess()) {
                return ResponseResult.errorFrom((ResponseResult)relationResult);
            }
            table = ((OnlineDatasourceRelation)relationResult.getData()).getSlaveTable();
        }
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{businessKey, dataId})) {
            return ResponseResult.success((Object)table);
        }
        if (relationId == null) {
            if (!StrUtil.equals((CharSequence)businessKey, (CharSequence)dataId)) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u53c2\u6570\u4e3b\u952eId\u4e0e\u6d41\u7a0b\u4e3b\u8868\u4e3b\u952eId\u4e0d\u5339\u914d\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
            return ResponseResult.success((Object)table);
        }
        OnlineDatasourceRelation relation = (OnlineDatasourceRelation)relationResult.getData();
        OnlineTable slaveTable = relation.getSlaveTable();
        Map dataMap = this.onlineOperationService.getMasterData(slaveTable, null, null, dataId);
        if (dataMap == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4ece\u8868\u4e3b\u952eId\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        OnlineColumn slaveColumn = relation.getSlaveColumn();
        Object relationSlaveDataId = dataMap.get(slaveColumn.getColumnName());
        if (relationSlaveDataId == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5173\u8054\u7684\u4ece\u8868\u5b57\u6bb5\u503c\u4e3aNULL\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        OnlineColumn masterColumn = (OnlineColumn)masterTable.getColumnMap().get(relation.getMasterColumnId());
        if (BooleanUtil.isTrue((Boolean)masterColumn.getPrimaryKey()) && !StrUtil.equals((CharSequence)relationSlaveDataId.toString(), (CharSequence)businessKey)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u4ece\u8868\u4e3b\u952eId\u5173\u8054\u7684\u4e3b\u8868Id\u5f53\u524d\u6d41\u7a0b\u7684BusinessKey\u4e0d\u4e00\u81f4\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        Map masterDataMap = this.onlineOperationService.getMasterData(masterTable, null, null, businessKey);
        if (masterDataMap == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e3b\u8868\u4e3b\u952eId\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        Object relationMasterDataId = masterDataMap.get(masterColumn.getColumnName());
        if (relationMasterDataId == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5173\u8054\u7684\u4e3b\u8868\u5b57\u6bb5\u503c\u4e3aNULL\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!StrUtil.equals((CharSequence)relationMasterDataId.toString(), (CharSequence)relationSlaveDataId.toString())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5173\u8054\u7684\u4e3b\u8868\u5b57\u6bb5\u503c\u548c\u4ece\u8868\u5b57\u6bb5\u503c\u4e0d\u4e00\u81f4\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success((Object)table);
    }

    private ResponseResult<String> verifyUploadOrDownload(String processDefinitionKey, String processInstanceId, String taskId, Long datasourceId) {
        List datasourceList;
        Optional<Long> r;
        String errorMessage;
        ResponseResult verifyResult;
        if (!StrUtil.isAllBlank((CharSequence[])new CharSequence[]{processInstanceId, taskId}) && !(verifyResult = this.flowOperationHelper.verifyUploadOrDownloadPermission(processInstanceId, taskId)).isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)ResponseResult.errorFrom((ResponseResult)verifyResult));
        }
        FlowEntry flowEntry = this.flowEntryService.getFlowEntryFromCache(processDefinitionKey);
        if (flowEntry == null) {
            errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u6d41\u7a0bId\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        String businessKey = null;
        if (processInstanceId != null) {
            HistoricProcessInstance instance = this.flowApiService.getHistoricProcessInstance(processInstanceId);
            if (!StrUtil.equals((CharSequence)flowEntry.getProcessDefinitionKey(), (CharSequence)instance.getProcessDefinitionKey())) {
                errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u6d41\u7a0b\u5b9e\u4f8b\u5e76\u4e0d\u5c5e\u4e8e\u5f53\u524d\u6d41\u7a0b\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
            businessKey = instance.getBusinessKey();
        }
        if (!(r = (datasourceList = this.onlinePageService.getOnlinePageDatasourceListByPageId(flowEntry.getPageId())).stream().map(OnlinePageDatasource::getDatasourceId).filter(c -> c.equals(datasourceId)).findFirst()).isPresent()) {
            errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6570\u636e\u6e90Id\u5e76\u4e0d\u5c5e\u4e8e\u5f53\u524d\u6d41\u7a0b\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success((Object)businessKey);
    }

    private ResponseResult<Void> submitNewTask(String instanceId, String taskId, FlowTaskComment comment, JSONObject variableData, OnlineDatasource datasource, JSONObject masterData, JSONObject slaveData) {
        OnlineTable masterTable = datasource.getMasterTable();
        if (slaveData == null) {
            this.flowOnlineOperationService.saveNewAndTakeTask(instanceId, taskId, comment, variableData, masterTable, masterData);
        } else {
            ResponseResult slaveDataListResult = this.onlineOperationHelper.buildSlaveDataList(datasource.getDatasourceId(), slaveData);
            if (!slaveDataListResult.isSuccess()) {
                return ResponseResult.errorFrom((ResponseResult)slaveDataListResult);
            }
            this.flowOnlineOperationService.saveNewAndTakeTask(instanceId, taskId, comment, variableData, masterTable, masterData, (Map)slaveDataListResult.getData());
        }
        return ResponseResult.success();
    }

    private JSONObject buildUserTaskData(String businessKey, OnlineDatasource datasource, List<OnlineDatasourceRelation> relationList) {
        this.onlineOperationHelper.enableOnlineExtendExecutor(datasource.getDatasourceId());
        OnlineTable masterTable = datasource.getMasterTable();
        JSONObject jsonData = new JSONObject();
        List oneToOneRelationList = relationList.stream().filter(r -> r.getRelationType().equals(0)).collect(Collectors.toList());
        Map result = this.onlineOperationService.getMasterData(masterTable, oneToOneRelationList, relationList, businessKey);
        if (MapUtil.isEmpty((Map)result)) {
            return jsonData;
        }
        jsonData.put(datasource.getVariableName(), (Object)result);
        List oneToManyRelationList = relationList.stream().filter(r -> r.getRelationType().equals(1)).collect(Collectors.toList());
        if (CollUtil.isEmpty(oneToManyRelationList)) {
            return jsonData;
        }
        for (OnlineDatasourceRelation relation : oneToManyRelationList) {
            OnlineFilterDto filterDto = new OnlineFilterDto();
            filterDto.setTableName(relation.getSlaveTable().getTableName());
            OnlineColumn slaveColumn = (OnlineColumn)relation.getSlaveTable().getColumnMap().get(relation.getSlaveColumnId());
            filterDto.setColumnName(slaveColumn.getColumnName());
            filterDto.setFilterType(Integer.valueOf(1));
            OnlineColumn masterColumn = (OnlineColumn)masterTable.getColumnMap().get(relation.getMasterColumnId());
            Object columnValue = result.get(masterColumn.getColumnName());
            filterDto.setColumnValue(columnValue);
            MyPageData pageData = this.onlineOperationService.getSlaveDataList(relation, (List)CollUtil.newLinkedList((Object[])new OnlineFilterDto[]{filterDto}), null, null);
            if (!CollUtil.isNotEmpty((Collection)pageData.getDataList())) continue;
            result.put(relation.getVariableName() + ONE_TO_MANY_VAR_SUFFIX, pageData.getDataList());
        }
        return jsonData;
    }

    private JSONObject buildDraftData(OnlineDatasource datasource, JSONObject masterData, List<OnlineDatasourceRelation> relationList, JSONObject slaveData) {
        OnlineTable masterTable = datasource.getMasterTable();
        JSONObject jsonData = new JSONObject();
        JSONObject normalizedMasterData = new JSONObject();
        Map<String, OnlineColumn> columnNameAndColumnMap = masterTable.getColumnMap().values().stream().collect(Collectors.toMap(OnlineColumn::getColumnName, c -> c));
        if (masterData != null) {
            for (Map.Entry entry : masterData.entrySet()) {
                OnlineColumn column = columnNameAndColumnMap.get(entry.getKey());
                Serializable v = this.onlineOperationHelper.convertToTypeValue(column, entry.getValue().toString());
                normalizedMasterData.put((String)entry.getKey(), (Object)v);
            }
        }
        if (slaveData != null && relationList != null) {
            Map<Long, OnlineDatasourceRelation> relationMap = relationList.stream().collect(Collectors.toMap(OnlineDatasourceRelation::getRelationId, c -> c));
            for (Map.Entry entry : slaveData.entrySet()) {
                OnlineDatasourceRelation relation = relationMap.get(Long.valueOf((String)entry.getKey()));
                if (relation == null) continue;
                this.buildRelationDraftData(relation, entry.getValue(), normalizedMasterData);
            }
        }
        jsonData.put(datasource.getVariableName(), (Object)normalizedMasterData);
        return jsonData;
    }

    private void buildRelationDraftData(OnlineDatasourceRelation relation, Object value, JSONObject masterData) {
        if (relation.getRelationType().equals(0)) {
            Map<String, OnlineColumn> slaveColumnNameAndColumnMap = relation.getSlaveTable().getColumnMap().values().stream().collect(Collectors.toMap(OnlineColumn::getColumnName, c -> c));
            JSONObject slaveObject = (JSONObject)value;
            JSONObject normalizedSlaveObject = new JSONObject();
            for (Map.Entry entry2 : slaveObject.entrySet()) {
                OnlineColumn column = slaveColumnNameAndColumnMap.get(entry2.getKey());
                Serializable v = this.onlineOperationHelper.convertToTypeValue(column, entry2.getValue().toString());
                normalizedSlaveObject.put((String)entry2.getKey(), (Object)v);
            }
            masterData.put(relation.getVariableName(), (Object)normalizedSlaveObject);
        } else if (relation.getRelationType().equals(1)) {
            JSONArray slaveArray = (JSONArray)value;
            JSONArray normalizedSlaveArray = new JSONArray();
            for (int i = 0; i <= slaveArray.size() - 1; ++i) {
                JSONObject slaveObject = slaveArray.getJSONObject(i);
                JSONObject normalizedSlaveObject = new JSONObject();
                normalizedSlaveObject.putAll((Map)slaveObject);
                normalizedSlaveArray.add((Object)normalizedSlaveObject);
            }
            masterData.put(relation.getVariableName(), (Object)normalizedSlaveArray);
        }
    }

    private ResponseResult<Void> makeWorkOrderTaskInfo(List<FlowWorkOrderVo> flowWorkOrderVoList, String ignoreMaskFields) {
        if (CollUtil.isEmpty(flowWorkOrderVoList)) {
            return ResponseResult.success();
        }
        Set definitionIdSet = flowWorkOrderVoList.stream().map(FlowWorkOrderVo::getProcessDefinitionId).collect(Collectors.toSet());
        List flowEntryPublishList = this.flowEntryService.getFlowEntryPublishList(definitionIdSet);
        Map<String, FlowEntryPublish> flowEntryPublishMap = flowEntryPublishList.stream().collect(Collectors.toMap(FlowEntryPublish::getProcessDefinitionId, c -> c));
        for (FlowWorkOrderVo flowWorkOrderVo : flowWorkOrderVoList) {
            FlowEntryPublish flowEntryPublish = flowEntryPublishMap.get(flowWorkOrderVo.getProcessDefinitionId());
            flowWorkOrderVo.setInitTaskInfo(flowEntryPublish.getInitTaskInfo());
        }
        Long tableId = flowWorkOrderVoList.get(0).getOnlineTableId();
        OnlineTable masterTable = this.onlineTableService.getOnlineTableFromCache(tableId);
        ResponseResult<Void> responseResult = this.buildWorkOrderMasterData(flowWorkOrderVoList, masterTable, ignoreMaskFields);
        if (!responseResult.isSuccess()) {
            return ResponseResult.errorFrom(responseResult);
        }
        responseResult = this.buildWorkOrderDraftData(flowWorkOrderVoList, masterTable);
        if (!responseResult.isSuccess()) {
            return ResponseResult.errorFrom(responseResult);
        }
        List unfinishedProcessInstanceIds = flowWorkOrderVoList.stream().filter(c -> !c.getFlowStatus().equals(3)).map(FlowWorkOrderVo::getProcessInstanceId).collect(Collectors.toList());
        if (CollUtil.isEmpty(unfinishedProcessInstanceIds)) {
            return ResponseResult.success();
        }
        Map<String, List<Task>> taskMap = this.flowApiService.getTaskListByProcessInstanceIds(unfinishedProcessInstanceIds).stream().collect(Collectors.groupingBy(TaskInfo::getProcessInstanceId));
        for (FlowWorkOrderVo flowWorkOrderVo : flowWorkOrderVoList) {
            List<Task> instanceTaskList = taskMap.get(flowWorkOrderVo.getProcessInstanceId());
            if (instanceTaskList == null) continue;
            JSONArray taskArray = new JSONArray();
            for (Task task : instanceTaskList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskName", (Object)task.getName());
                jsonObject.put("taskKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("assignee", (Object)task.getAssignee());
                taskArray.add((Object)jsonObject);
            }
            flowWorkOrderVo.setRuntimeTaskInfoList(taskArray);
        }
        return ResponseResult.success();
    }

    private ResponseResult<Void> buildWorkOrderDraftData(List<FlowWorkOrderVo> flowWorkOrderVoList, OnlineTable masterTable) {
        List draftWorkOrderList = flowWorkOrderVoList.stream().filter(c -> c.getFlowStatus().equals(FlowTaskStatus.DRAFT)).collect(Collectors.toList());
        if (CollUtil.isEmpty(draftWorkOrderList)) {
            return ResponseResult.success();
        }
        Set workOrderIdSet = draftWorkOrderList.stream().map(FlowWorkOrderVo::getWorkOrderId).collect(Collectors.toSet());
        List workOrderExtList = this.flowWorkOrderService.getFlowWorkOrderExtByWorkOrderIds(workOrderIdSet);
        Map<Long, FlowWorkOrderExt> workOrderExtMap = workOrderExtList.stream().collect(Collectors.toMap(FlowWorkOrderExt::getWorkOrderId, c -> c));
        for (FlowWorkOrderVo workOrder : draftWorkOrderList) {
            FlowWorkOrderExt workOrderExt = workOrderExtMap.get(workOrder.getWorkOrderId());
            if (workOrderExt == null) continue;
            JSONObject draftData = JSON.parseObject((String)workOrderExt.getDraftData());
            JSONObject masterData = draftData.getJSONObject("masterData");
            JSONObject slaveData = draftData.getJSONObject("slaveData");
            OnlineDatasource datasource = this.onlineDatasourceService.getOnlineDatasourceByMasterTableId(masterTable.getTableId());
            List slaveRelationList = null;
            if (slaveData != null) {
                ResponseResult relationListResult = this.onlineOperationHelper.verifyAndGetRelationList(datasource.getDatasourceId(), Integer.valueOf(0));
                if (!relationListResult.isSuccess()) {
                    return ResponseResult.errorFrom((ResponseResult)relationListResult);
                }
                slaveRelationList = (List)relationListResult.getData();
            }
            datasource.setMasterTable(masterTable);
            JSONObject jsonData = this.buildDraftData(datasource, masterData, slaveRelationList, slaveData);
            JSONObject masterAndOneToOneData = jsonData.getJSONObject(datasource.getVariableName());
            if (MapUtil.isNotEmpty((Map)masterAndOneToOneData)) {
                LinkedList<JSONObject> dataList = new LinkedList<JSONObject>();
                dataList.add(masterAndOneToOneData);
                this.onlineOperationService.buildDataListWithDict(masterTable, slaveRelationList, dataList);
            }
            workOrder.setMasterData((Map)masterAndOneToOneData);
        }
        return ResponseResult.success();
    }

    private ResponseResult<Void> buildWorkOrderMasterData(List<FlowWorkOrderVo> flowWorkOrderVoList, OnlineTable masterTable, String ignoreMaskFields) {
        Set businessKeySet = flowWorkOrderVoList.stream().map(FlowWorkOrderVo::getBusinessKey).filter(Objects::nonNull).collect(Collectors.toSet());
        if (CollUtil.isEmpty(businessKeySet)) {
            return ResponseResult.success();
        }
        Set convertedBusinessKeySet = this.onlineOperationHelper.convertToTypeValue(masterTable.getPrimaryKeyColumn(), businessKeySet);
        LinkedList<OnlineFilterDto> filterList = new LinkedList<OnlineFilterDto>();
        OnlineFilterDto filterDto = new OnlineFilterDto();
        filterDto.setTableName(masterTable.getTableName());
        filterDto.setColumnName(masterTable.getPrimaryKeyColumn().getColumnName());
        filterDto.setFilterType(Integer.valueOf(4));
        filterDto.setColumnValueList(new HashSet(convertedBusinessKeySet));
        filterList.add(filterDto);
        TaskInfoVo taskInfoVo = (TaskInfoVo)JSON.parseObject((String)flowWorkOrderVoList.get(0).getInitTaskInfo(), TaskInfoVo.class);
        ResponseResult<OnlineDatasource> datasourceResult = this.verifyAndGetOnlineDatasource(taskInfoVo.getFormId());
        if (!datasourceResult.isSuccess()) {
            return ResponseResult.errorFrom(datasourceResult);
        }
        OnlineDatasource datasource = (OnlineDatasource)datasourceResult.getData();
        ResponseResult relationListResult = this.onlineOperationHelper.verifyAndGetRelationList(datasource.getDatasourceId(), Integer.valueOf(0));
        if (!relationListResult.isSuccess()) {
            return ResponseResult.errorFrom((ResponseResult)relationListResult);
        }
        MyPageData pageData = this.onlineOperationService.getMasterDataList(masterTable, (List)relationListResult.getData(), null, filterList, null, null);
        List dataList = pageData.getDataList();
        this.onlineOperationHelper.maskFieldDataList(dataList, masterTable, (List)relationListResult.getData(), ignoreMaskFields);
        Map<Object, Map> dataMap = dataList.stream().collect(Collectors.toMap(c -> c.get(masterTable.getPrimaryKeyColumn().getColumnName()).toString(), c -> c));
        for (FlowWorkOrderVo flowWorkOrderVo : flowWorkOrderVoList) {
            Serializable dataId;
            Map data;
            if (!StrUtil.isNotBlank((CharSequence)flowWorkOrderVo.getBusinessKey()) || (data = dataMap.get((dataId = this.onlineOperationHelper.convertToTypeValue(masterTable.getPrimaryKeyColumn(), flowWorkOrderVo.getBusinessKey())).toString())) == null) continue;
            flowWorkOrderVo.setMasterData(data);
        }
        return ResponseResult.success();
    }
}

