/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.online.object;

import com.dic.bid.common.core.util.ContextUtil;
import com.dic.bid.common.online.object.TransactionalBusinessData;
import javax.servlet.http.HttpServletRequest;

public class TransactionalFlowBusinessData
extends TransactionalBusinessData {
    private String processInstanceId;
    private String taskId;
    private String taskKey;
    private String taskName;
    private String taskComment;
    private static final ThreadLocal<TransactionalFlowBusinessData> FLOW_BUSINESS_DATA_THREAD_LOCAL = new ThreadLocal();

    public TransactionalFlowBusinessData() {
    }

    public TransactionalFlowBusinessData(HttpServletRequest request) {
        super(request);
    }

    public static TransactionalFlowBusinessData getFromRequestAttribute() {
        HttpServletRequest request = ContextUtil.getHttpRequest();
        if (request != null) {
            return (TransactionalFlowBusinessData)((Object)request.getAttribute("transactionalBusinessData"));
        }
        return FLOW_BUSINESS_DATA_THREAD_LOCAL.get();
    }

    public static TransactionalFlowBusinessData getOrCreateFromRequestAttribute() {
        TransactionalFlowBusinessData data;
        HttpServletRequest request = ContextUtil.getHttpRequest();
        if (request != null) {
            data = (TransactionalFlowBusinessData)((Object)request.getAttribute("transactionalBusinessData"));
            if (data != null) {
                return data;
            }
            data = new TransactionalFlowBusinessData(request);
            request.setAttribute("transactionalBusinessData", (Object)data);
        } else {
            data = FLOW_BUSINESS_DATA_THREAD_LOCAL.get();
            if (data != null) {
                return data;
            }
            data = new TransactionalFlowBusinessData();
            FLOW_BUSINESS_DATA_THREAD_LOCAL.set(data);
        }
        return data;
    }

    public static void removeFromRequestAttribute() {
        if (ContextUtil.hasRequestContext()) {
            ContextUtil.getHttpRequest().removeAttribute("transactionalBusinessData");
        } else {
            FLOW_BUSINESS_DATA_THREAD_LOCAL.remove();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionalFlowBusinessData)) {
            return false;
        }
        TransactionalFlowBusinessData other = (TransactionalFlowBusinessData)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$processInstanceId = this.getProcessInstanceId();
        String other$processInstanceId = other.getProcessInstanceId();
        if (this$processInstanceId == null ? other$processInstanceId != null : !this$processInstanceId.equals(other$processInstanceId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$taskKey = this.getTaskKey();
        String other$taskKey = other.getTaskKey();
        if (this$taskKey == null ? other$taskKey != null : !this$taskKey.equals(other$taskKey)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$taskComment = this.getTaskComment();
        String other$taskComment = other.getTaskComment();
        return !(this$taskComment == null ? other$taskComment != null : !this$taskComment.equals(other$taskComment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionalFlowBusinessData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $processInstanceId = this.getProcessInstanceId();
        result = result * 59 + ($processInstanceId == null ? 43 : $processInstanceId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $taskKey = this.getTaskKey();
        result = result * 59 + ($taskKey == null ? 43 : $taskKey.hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $taskComment = this.getTaskComment();
        result = result * 59 + ($taskComment == null ? 43 : $taskComment.hashCode());
        return result;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskComment() {
        return this.taskComment;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskKey(String taskKey) {
        this.taskKey = taskKey;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setTaskComment(String taskComment) {
        this.taskComment = taskComment;
    }

    public String toString() {
        return "TransactionalFlowBusinessData(processInstanceId=" + this.getProcessInstanceId() + ", taskId=" + this.getTaskId() + ", taskKey=" + this.getTaskKey() + ", taskName=" + this.getTaskName() + ", taskComment=" + this.getTaskComment() + ")";
    }
}

