/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.online.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dic.bid.common.core.annotation.MyDataSource;
import com.dic.bid.common.flow.base.service.BaseFlowOnlineService;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.online.object.TransactionalFlowBusinessData;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.online.exception.OnlineRuntimeException;
import com.dic.bid.common.online.model.OnlineColumn;
import com.dic.bid.common.online.model.OnlineDatasource;
import com.dic.bid.common.online.model.OnlineDatasourceRelation;
import com.dic.bid.common.online.model.OnlineTable;
import com.dic.bid.common.online.service.OnlineDatasourceRelationService;
import com.dic.bid.common.online.service.OnlineDatasourceService;
import com.dic.bid.common.online.service.OnlineOperationService;
import com.dic.bid.common.online.service.OnlineTableService;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSource(value=1010)
@Service(value="flowOnlineBusinessService")
public class FlowOnlineBusinessServiceImpl
implements BaseFlowOnlineService {
    private static final Logger log = LoggerFactory.getLogger(FlowOnlineBusinessServiceImpl.class);
    @Autowired
    private FlowCustomExtFactory flowCustomExtFactory;
    @Autowired
    private OnlineTableService onlineTableService;
    @Autowired
    private OnlineDatasourceService onlineDatasourceService;
    @Autowired
    private OnlineDatasourceRelationService onlineDatasourceRelationService;
    @Autowired
    private OnlineOperationService onlineOperationService;

    @PostConstruct
    public void doRegister() {
        this.flowCustomExtFactory.getOnlineBusinessDataExtHelper().setOnlineBusinessService((BaseFlowOnlineService)this);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateFlowStatus(FlowWorkOrder workOrder) {
        OnlineTable onlineTable = this.onlineTableService.getOnlineTableFromCache(workOrder.getOnlineTableId());
        if (onlineTable == null) {
            log.error("OnlineTableId [{}] doesn't exist while calling FlowOnlineBusinessServiceImpl.updateFlowStatus", (Object)workOrder.getOnlineTableId());
            return;
        }
        String dataId = workOrder.getBusinessKey();
        this.handleTransactionalFlowBusinessData(workOrder, "FlowOnlineBusinessServiceImpl.updateFlowStatus");
        for (OnlineColumn column : onlineTable.getColumnMap().values()) {
            if (ObjectUtil.equals((Object)column.getFieldKind(), (Object)26)) {
                this.onlineOperationService.updateColumn(onlineTable, dataId, column, (Object)workOrder.getFlowStatus());
            }
            if (!ObjectUtil.equals((Object)column.getFieldKind(), (Object)25)) continue;
            this.onlineOperationService.updateColumn(onlineTable, dataId, column, (Object)workOrder.getLatestApprovalStatus());
        }
    }

    public void deleteBusinessData(FlowWorkOrder workOrder) {
        OnlineTable onlineTable = this.onlineTableService.getOnlineTableFromCache(workOrder.getOnlineTableId());
        if (onlineTable == null) {
            log.error("OnlineTableId [{}] doesn't exist while calling FlowOnlineBusinessServiceImpl.deleteBusinessData", (Object)workOrder.getOnlineTableId());
            return;
        }
        OnlineDatasource datasource = this.onlineDatasourceService.getOnlineDatasourceByMasterTableId(onlineTable.getTableId());
        List relationList = this.onlineDatasourceRelationService.getOnlineDatasourceRelationListFromCache((Set)CollUtil.newHashSet((Object[])new Long[]{datasource.getDatasourceId()}));
        String dataId = workOrder.getBusinessKey();
        for (OnlineDatasourceRelation relation : relationList) {
            OnlineTable slaveTable = this.onlineTableService.getOnlineTableFromCache(relation.getSlaveTableId());
            if (slaveTable == null) {
                throw new OnlineRuntimeException("\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6570\u636e\u6e90\u5173\u8054 [" + relation.getRelationName() + "] \u7684\u4ece\u8868Id\u4e0d\u5b58\u5728\uff01");
            }
            relation.setSlaveTable(slaveTable);
        }
        this.handleTransactionalFlowBusinessData(workOrder, "FlowOnlineBusinessServiceImpl.deleteBusinessData");
        this.onlineOperationService.delete(onlineTable, relationList, dataId);
    }

    private void handleTransactionalFlowBusinessData(FlowWorkOrder workOrder, String desc) {
        TransactionalFlowBusinessData eventData = TransactionalFlowBusinessData.getFromRequestAttribute();
        if (eventData != null) {
            eventData.setProcessInstanceId(workOrder.getProcessInstanceId());
            eventData.setOperationDesc(desc);
        }
    }
}

