/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.online.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.annotation.MultiDatabaseWriteMethod;
import com.dic.bid.common.core.annotation.MyDataSource;
import com.dic.bid.common.core.config.CoreProperties;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.dbutil.provider.DataSourceProvider;
import com.dic.bid.common.dbutil.provider.PostgreSqlProvider;
import com.dic.bid.common.flow.config.FlowProperties;
import com.dic.bid.common.flow.dao.FlowTransProducerMapper;
import com.dic.bid.common.flow.exception.FlowOperationException;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowTransProducer;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.online.object.TransactionalFlowBusinessData;
import com.dic.bid.common.flow.online.service.FlowOnlineOperationService;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.online.config.OnlineProperties;
import com.dic.bid.common.online.exception.OnlineRuntimeException;
import com.dic.bid.common.online.model.OnlineDatasource;
import com.dic.bid.common.online.model.OnlineDatasourceRelation;
import com.dic.bid.common.online.model.OnlineTable;
import com.dic.bid.common.online.object.TransactionalBusinessData;
import com.dic.bid.common.online.service.OnlineDatasourceService;
import com.dic.bid.common.online.service.OnlineOperationService;
import com.dic.bid.common.online.util.OnlineDataSourceUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@MyDataSource(value=1010)
@Service(value="flowOnlineOperationService")
public class FlowOnlineOperationServiceImpl
implements FlowOnlineOperationService {
    private static final Logger log = LoggerFactory.getLogger(FlowOnlineOperationServiceImpl.class);
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowWorkOrderService flowWorkOrderService;
    @Autowired
    private FlowEntryService flowEntryService;
    @Autowired
    private OnlineOperationService onlineOperationService;
    @Autowired
    private OnlineDatasourceService onlineDatasourceService;
    @Autowired
    private OnlineProperties onlineProperties;
    @Autowired
    private FlowProperties flowProperties;
    @Autowired
    private CoreProperties coreProperties;
    @Autowired
    private OnlineDataSourceUtil dataSourceUtil;
    @Autowired
    private FlowTransProducerMapper flowTransProducerMapper;

    @Override
    @MultiDatabaseWriteMethod
    @Transactional(rollbackFor={Exception.class})
    public void startWithBusinessKey(String processDefinitionId, Long onlineTableId, String dataId) {
        ProcessInstance instance = this.flowApiService.start(processDefinitionId, (Object)dataId);
        this.flowWorkOrderService.saveNew(instance, (Object)dataId, onlineTableId, null);
    }

    @Override
    @MultiDatabaseWriteMethod
    @Transactional(rollbackFor={Exception.class})
    public void saveNewAndStartProcess(String processDefinitionId, FlowTaskComment flowTaskComment, JSONObject taskVariableData, OnlineTable table, JSONObject data) {
        this.saveNewAndStartProcess(processDefinitionId, flowTaskComment, taskVariableData, table, data, null);
    }

    @Override
    @MultiDatabaseWriteMethod
    @Transactional(rollbackFor={Exception.class})
    public void saveNewAndStartProcess(String processDefinitionId, FlowTaskComment flowTaskComment, JSONObject taskVariableData, OnlineTable masterTable, JSONObject masterData, Map<OnlineDatasourceRelation, List<JSONObject>> slaveDataListMap) {
        Object dataId = this.onlineOperationService.saveNewWithRelation(masterTable, masterData, slaveDataListMap);
        Assert.notNull((Object)dataId);
        if (taskVariableData == null) {
            taskVariableData = new JSONObject();
        }
        taskVariableData.put("masterData", (Object)masterData);
        taskVariableData.put("slaveData", this.normailizeSlaveDataListMap(slaveDataListMap));
        taskVariableData.put("masterTable", (Object)masterTable);
        ProcessInstance instance = this.flowApiService.start(processDefinitionId, dataId);
        this.flowWorkOrderService.saveNew(instance, dataId, masterTable.getTableId(), null);
        this.flowApiService.takeFirstTask(instance.getProcessInstanceId(), flowTaskComment, taskVariableData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowWorkOrder saveNewDraftAndStartProcess(String processDefinitionId, Long tableId, JSONObject masterData, JSONObject slaveData) {
        ProcessInstance instance = this.flowApiService.start(processDefinitionId, null);
        return this.flowWorkOrderService.saveNewWithDraft(instance, tableId, null, JSON.toJSONString((Object)masterData), JSON.toJSONString((Object)slaveData));
    }

    @Override
    @MultiDatabaseWriteMethod
    @Transactional(rollbackFor={Exception.class})
    public void saveNewAndTakeTask(String processInstanceId, String taskId, FlowTaskComment flowTaskComment, JSONObject taskVariableData, OnlineTable table, JSONObject data) {
        this.saveNewAndTakeTask(processInstanceId, taskId, flowTaskComment, taskVariableData, table, data, null);
    }

    @Override
    @MultiDatabaseWriteMethod
    @Transactional(rollbackFor={Exception.class})
    public void saveNewAndTakeTask(String processInstanceId, String taskId, FlowTaskComment flowTaskComment, JSONObject taskVariableData, OnlineTable masterTable, JSONObject masterData, Map<OnlineDatasourceRelation, List<JSONObject>> slaveDataListMap) {
        Object dataId = this.onlineOperationService.saveNewWithRelation(masterTable, masterData, slaveDataListMap);
        Assert.notNull((Object)dataId);
        Task task = this.flowApiService.getProcessInstanceActiveTask(processInstanceId, taskId);
        this.flowApiService.setBusinessKeyForProcessInstance(processInstanceId, dataId);
        Map variables = this.flowApiService.initAndGetProcessInstanceVariables(task.getProcessDefinitionId());
        if (taskVariableData == null) {
            taskVariableData = new JSONObject();
        }
        taskVariableData.putAll(variables);
        taskVariableData.put("masterData", (Object)masterData);
        taskVariableData.put("slaveData", this.normailizeSlaveDataListMap(slaveDataListMap));
        taskVariableData.put("masterTable", (Object)masterTable);
        ProcessInstance instance = this.flowApiService.getProcessInstance(processInstanceId);
        this.flowApiService.completeTask(task, flowTaskComment, taskVariableData, null);
        FlowWorkOrder flowWorkOrder = this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(instance.getProcessInstanceId());
        if (flowWorkOrder == null) {
            this.flowWorkOrderService.saveNew(instance, dataId, masterTable.getTableId(), null);
        } else {
            flowWorkOrder.setBusinessKey(dataId.toString());
            flowWorkOrder.setUpdateTime(new java.util.Date());
            flowWorkOrder.setFlowStatus(Integer.valueOf(0));
            this.flowWorkOrderService.updateById((Object)flowWorkOrder);
        }
    }

    @Override
    @MultiDatabaseWriteMethod
    @Transactional(rollbackFor={Exception.class})
    public void updateAndTakeTask(Task task, FlowTaskComment flowTaskComment, JSONObject taskVariableData, OnlineDatasource datasource, JSONObject masterData, String masterDataId, Map<OnlineDatasourceRelation, List<JSONObject>> slaveDataListMap) {
        int flowStatus = 1;
        if (flowTaskComment.getApprovalType().equals("refuse")) {
            flowStatus = 2;
        } else if (flowTaskComment.getApprovalType().equals("stop")) {
            flowStatus = 3;
        }
        OnlineTable masterTable = datasource.getMasterTable();
        Long datasourceId = datasource.getDatasourceId();
        this.flowWorkOrderService.updateFlowStatusByProcessInstanceId(task.getProcessInstanceId(), Integer.valueOf(flowStatus));
        this.updateMasterData(masterTable, masterData, masterDataId);
        if (slaveDataListMap != null) {
            for (Map.Entry<OnlineDatasourceRelation, List<JSONObject>> relationEntry : slaveDataListMap.entrySet()) {
                Long relationId = relationEntry.getKey().getRelationId();
                this.onlineOperationService.updateRelationData(masterTable, (Map)masterData, masterDataId, datasourceId, relationId, relationEntry.getValue());
            }
        }
        if (flowTaskComment.getApprovalType().equals("stop")) {
            Integer s = MapUtil.getInt((Map)taskVariableData, (Object)"latestApprovalStatus");
            this.flowWorkOrderService.updateLatestApprovalStatusByProcessInstanceId(task.getProcessInstanceId(), s);
            CallResult stopResult = this.flowApiService.stopProcessInstance(task.getProcessInstanceId(), flowTaskComment.getTaskComment(), flowStatus);
            if (!stopResult.isSuccess()) {
                throw new FlowOperationException(stopResult.getErrorMessage());
            }
        } else {
            if (taskVariableData == null) {
                taskVariableData = new JSONObject();
            }
            taskVariableData.put("masterData", (Object)masterData);
            taskVariableData.put("slaveData", this.normailizeSlaveDataListMap(slaveDataListMap));
            taskVariableData.put("masterTable", (Object)masterTable);
            this.flowApiService.completeTask(task, flowTaskComment, taskVariableData, null);
        }
    }

    @Override
    public void fixBusinessData(FlowTransProducer flowTransProducer) {
        try {
            String sql = "SELECT * FROM zz_flow_trans_consumer WHERE trans_id = " + flowTransProducer.getTransId();
            List dataList = this.dataSourceUtil.query(flowTransProducer.getDblinkId(), sql);
            if (CollUtil.isNotEmpty((Collection)dataList)) {
                return;
            }
        }
        catch (Exception e) {
            log.error("Failed to call dataSourceUtil.query", (Throwable)e);
            throw new OnlineRuntimeException(e.getMessage());
        }
        TransactionalFlowBusinessData businessData = new TransactionalFlowBusinessData();
        businessData.setTransId(flowTransProducer.getTransId());
        businessData.setDblinkId(flowTransProducer.getDblinkId());
        List sqlDataList = JSON.parseArray((String)flowTransProducer.getSqlData(), TransactionalBusinessData.BusinessSqlData.class);
        businessData.setSqlDataList(sqlDataList);
        try {
            this.doHandle(businessData);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new OnlineRuntimeException(e.getMessage());
        }
    }

    @Override
    public List<Map<String, Object>> calculatePermData(Set<Long> onlineFormEntryIds) {
        if (CollUtil.isEmpty(onlineFormEntryIds)) {
            return new LinkedList<Map<String, Object>>();
        }
        LinkedList<Map<String, Object>> permDataList = new LinkedList<Map<String, Object>>();
        List flowEntries = this.flowEntryService.getInList(onlineFormEntryIds);
        Set pageIds = flowEntries.stream().map(FlowEntry::getPageId).collect(Collectors.toSet());
        Map pageAndVariableNameMap = this.onlineDatasourceService.getPageIdAndVariableNameMapByPageIds(pageIds);
        for (FlowEntry flowEntry : flowEntries) {
            JSONObject permData = new JSONObject();
            permData.put("entryId", (Object)flowEntry.getEntryId());
            String key = StrUtil.upperFirst((CharSequence)flowEntry.getProcessDefinitionKey());
            LinkedList<String> permCodeList = new LinkedList<String>();
            String formPermCode = "form" + key;
            permCodeList.add(formPermCode);
            permCodeList.add(formPermCode + ":fragment" + key);
            permData.put("permCodeList", permCodeList);
            String flowUrlPrefix = this.flowProperties.getUrlPrefix();
            String onlineUrlPrefix = this.onlineProperties.getUrlPrefix();
            LinkedList permList = CollUtil.newLinkedList((Object[])new String[]{onlineUrlPrefix + "/onlineForm/view", onlineUrlPrefix + "/onlineForm/render", onlineUrlPrefix + "/onlineOperation/listByOneToManyRelationId/" + (String)pageAndVariableNameMap.get(flowEntry.getPageId()), onlineUrlPrefix + "/onlineOperation/uploadByOneToManyRelationId/" + (String)pageAndVariableNameMap.get(flowEntry.getPageId()), onlineUrlPrefix + "/onlineOperation/dowloadByOneToManyRelationId/" + (String)pageAndVariableNameMap.get(flowEntry.getPageId()), flowUrlPrefix + "/flowOperation/viewInitialHistoricTaskInfo", flowUrlPrefix + "/flowOperation/startOnly", flowUrlPrefix + "/flowOperation/viewInitialTaskInfo", flowUrlPrefix + "/flowOperation/viewRuntimeTaskInfo", flowUrlPrefix + "/flowOperation/viewProcessBpmn", flowUrlPrefix + "/flowOperation/viewHighlightFlowData", flowUrlPrefix + "/flowOperation/listFlowTaskComment", flowUrlPrefix + "/flowOperation/cancelWorkOrder", flowUrlPrefix + "/flowOperation/printWorkOrder/", flowUrlPrefix + "/flowOperation/listRuntimeTask", flowUrlPrefix + "/flowOperation/listHistoricProcessInstance", flowUrlPrefix + "/flowOperation/listHistoricTask", flowUrlPrefix + "/flowOperation/freeJumpTo", flowUrlPrefix + "/flowOnlineOperation/startPreview", flowUrlPrefix + "/flowOnlineOperation/viewUserTask", flowUrlPrefix + "/flowOnlineOperation/viewHistoricProcessInstance", flowUrlPrefix + "/flowOnlineOperation/submitUserTask", flowUrlPrefix + "/flowOnlineOperation/upload", flowUrlPrefix + "/flowOnlineOperation/download", flowUrlPrefix + "/flowOperation/submitConsign", flowUrlPrefix + "/flowOnlineOperation/startAndTakeUserTask/" + flowEntry.getProcessDefinitionKey(), flowUrlPrefix + "/flowOnlineOperation/startAndSaveDraft/" + flowEntry.getProcessDefinitionKey(), flowUrlPrefix + "/flowOnlineOperation/listWorkOrder/" + flowEntry.getProcessDefinitionKey()});
            permData.put("permList", (Object)permList);
            permDataList.add((Map<String, Object>)permData);
        }
        return permDataList;
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT)
    public void bulkHandleBusinessData(TransactionalFlowBusinessData businessData) {
        try {
            this.doHandle(businessData);
            this.flowTransProducerMapper.deleteById((Serializable)businessData.getTransId());
        }
        catch (Exception e) {
            log.error("Failed to commit online business data [** " + JSON.toJSONString((Object)((Object)businessData)) + " **]", (Throwable)e);
            FlowTransProducer transProducer = (FlowTransProducer)this.flowTransProducerMapper.selectById((Serializable)businessData.getTransId());
            transProducer.setErrorReason(e.getMessage());
            this.flowTransProducerMapper.updateById((Object)transProducer);
            businessData.setErrorReason(e.getMessage());
            throw new OnlineRuntimeException(e.getMessage());
        }
    }

    private void doHandle(TransactionalFlowBusinessData businessData) throws Exception {
        try (Connection conn = null;){
            conn = this.dataSourceUtil.getConnection(businessData.getDblinkId());
            conn.setAutoCommit(false);
            for (TransactionalBusinessData.BusinessSqlData s : businessData.getSqlDataList()) {
                List paramList = null;
                if (CollUtil.isNotEmpty((Collection)s.getColumnValueList())) {
                    paramList = s.getColumnValueList().stream().map(Object.class::cast).collect(Collectors.toList());
                }
                this.dataSourceUtil.execute(conn, s.getSql(), paramList);
            }
            this.insertFlowConsumerTrans(conn, businessData);
            conn.commit();
        }
    }

    private void insertFlowConsumerTrans(Connection conn, TransactionalFlowBusinessData businessData) {
        DataSourceProvider provider = this.dataSourceUtil.getProvider(businessData.getDblinkId());
        Long transId = businessData.getTransId();
        String sql = "INSERT INTO zz_flow_trans_consumer VALUES(?,?)";
        if (provider instanceof PostgreSqlProvider) {
            this.dataSourceUtil.execute(conn, sql, (List)CollUtil.newArrayList((Object[])new Object[]{transId, new Date(System.currentTimeMillis())}));
        } else {
            this.dataSourceUtil.execute(conn, sql, (List)CollUtil.newArrayList((Object[])new Object[]{transId, new java.util.Date()}));
        }
    }

    private void updateMasterData(OnlineTable masterTable, JSONObject masterData, String dataId) {
        if (masterData == null) {
            return;
        }
        Map originalMasterData = this.onlineOperationService.getMasterData(masterTable, null, null, dataId);
        for (Map.Entry entry : originalMasterData.entrySet()) {
            masterData.putIfAbsent(entry.getKey(), entry.getValue());
        }
        if (!this.onlineOperationService.update(masterTable, masterData)) {
            throw new FlowOperationException("\u4e3b\u8868\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
    }

    private Map<String, List<JSONObject>> normailizeSlaveDataListMap(Map<OnlineDatasourceRelation, List<JSONObject>> slaveDataListMap) {
        if (slaveDataListMap == null || slaveDataListMap.isEmpty()) {
            return null;
        }
        HashMap<String, List<JSONObject>> resultMap = new HashMap<String, List<JSONObject>>(slaveDataListMap.size());
        for (Map.Entry<OnlineDatasourceRelation, List<JSONObject>> entry : slaveDataListMap.entrySet()) {
            resultMap.put(entry.getKey().getSlaveTable().getTableName(), entry.getValue());
        }
        return resultMap;
    }
}

