/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.advice;

import com.alibaba.fastjson.JSON;
import com.dic.bid.common.core.constant.ErrorCodeEnum;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.util.ContextUtil;
import com.dic.bid.common.flow.exception.FlowEmptyUserException;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.service.FlowTaskCommentService;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.engine.api.FlowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@Order(value=1)
@RestControllerAdvice(value={"com.dic.bid"})
public class FlowExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(FlowExceptionHandler.class);
    @Autowired
    private FlowTaskCommentService flowTaskCommentService;

    @ExceptionHandler(value={FlowableException.class})
    public ResponseResult<Void> exceptionHandle(FlowableException ex, HttpServletRequest request) {
        if (ex instanceof FlowEmptyUserException) {
            FlowEmptyUserException flowEmptyUserException = (FlowEmptyUserException)ex;
            FlowTaskComment comment = (FlowTaskComment)JSON.parseObject((String)flowEmptyUserException.getMessage(), FlowTaskComment.class);
            this.flowTaskCommentService.saveNew(comment);
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)"\u4e0b\u4e00\u4e2a\u4efb\u52a1\u8282\u70b9\u7684\u5ba1\u6279\u4eba\u4e3a\u7a7a\uff0c\u63d0\u4ea4\u88ab\u81ea\u52a8\u9a73\u56de\uff01");
        }
        log.error("Unhandled FlowException from URL [" + request.getRequestURI() + "]", (Throwable)ex);
        ContextUtil.getHttpResponse().setStatus(500);
        return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
    }

    private <T extends Exception> T findCause(Throwable ex, Class<T> clazz) {
        if (ex.getCause() == null) {
            return null;
        }
        if (ex.getCause().getClass().equals(clazz)) {
            return (T)((Exception)ex.getCause());
        }
        return this.findCause(ex.getCause(), clazz);
    }
}

