/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.base.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.exception.MyRuntimeException;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.core.object.MyRelationParam;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.flow.exception.FlowOperationException;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.model.FlowWorkOrderExt;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.vo.FlowWorkOrderVo;
import com.dic.bid.common.redis.cache.SessionCacheHelper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseFlowService<M, K extends Serializable>
extends BaseService<M, K> {
    private static final Logger log = LoggerFactory.getLogger(BaseFlowService.class);
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowWorkOrderService flowWorkOrderService;
    @Autowired
    private SessionCacheHelper cacheHelper;

    @Transactional(rollbackFor={Exception.class})
    public void startWithBusinessKey(String processDefinitionId, K dataId) {
        ProcessInstance instance = this.flowApiService.start(processDefinitionId, dataId);
        this.flowWorkOrderService.saveNew(instance, dataId, null, this.tableName);
    }

    @Transactional(rollbackFor={Exception.class})
    public void startAndTakeFirst(String processDefinitionId, K dataId, FlowTaskComment comment, JSONObject variables) {
        ProcessInstance instance = this.flowApiService.start(processDefinitionId, dataId);
        this.flowWorkOrderService.saveNew(instance, dataId, null, this.tableName);
        this.flowApiService.takeFirstTask(instance.getProcessInstanceId(), comment, variables);
    }

    @Transactional(rollbackFor={Exception.class})
    public FlowWorkOrder saveNewDraftAndStartProcess(String processDefinitionId, String masterData, String slaveData) {
        ProcessInstance instance = this.flowApiService.start(processDefinitionId, null);
        Map<String, Object> variableMap = this.flowApiService.initAndGetProcessInstanceVariables(processDefinitionId);
        this.flowApiService.setProcessInstanceVariables(instance.getProcessInstanceId(), variableMap);
        return this.flowWorkOrderService.saveNewWithDraft(instance, null, this.tableName, masterData, slaveData);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDraft(Long workOrderId, String masterData, String slaveData) {
        this.flowWorkOrderService.updateDraft(workOrderId, masterData, slaveData);
    }

    @Transactional(rollbackFor={Exception.class})
    public void takeFirstTask(String processInstanceId, String taskId, K dataId, FlowTaskComment comment, JSONObject variables) {
        Task task = this.flowApiService.getProcessInstanceActiveTask(processInstanceId, taskId);
        this.flowApiService.setBusinessKeyForProcessInstance(processInstanceId, dataId);
        ProcessInstance instance = this.flowApiService.getProcessInstance(processInstanceId);
        FlowWorkOrder flowWorkOrder = this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(instance.getProcessInstanceId());
        if (flowWorkOrder == null) {
            this.flowWorkOrderService.saveNew(instance, dataId, null, this.tableName);
        } else {
            flowWorkOrder.setBusinessKey(dataId.toString());
            flowWorkOrder.setUpdateTime(new Date());
            flowWorkOrder.setFlowStatus(0);
            this.flowWorkOrderService.updateById(flowWorkOrder);
        }
        this.flowApiService.completeTask(task, comment, variables, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void takeTask(Task task, K dataId, FlowTaskComment comment, JSONObject variables) {
        int flowStatus = 1;
        if (comment.getApprovalType().equals("refuse")) {
            flowStatus = 2;
        } else if (comment.getApprovalType().equals("stop")) {
            flowStatus = 3;
        }
        if (comment.getApprovalType().equals("stop")) {
            Integer s = MapUtil.getInt((Map)variables, (Object)"latestApprovalStatus");
            this.flowWorkOrderService.updateLatestApprovalStatusByProcessInstanceId(task.getProcessInstanceId(), s);
            CallResult stopResult = this.flowApiService.stopProcessInstance(task.getProcessInstanceId(), comment.getTaskComment(), flowStatus);
            if (!stopResult.isSuccess()) {
                throw new FlowOperationException(stopResult.getErrorMessage());
            }
        } else {
            this.flowWorkOrderService.updateFlowStatusByProcessInstanceId(task.getProcessInstanceId(), flowStatus);
            this.flowApiService.completeTask(task, comment, variables, null);
        }
    }

    public void buildDraftData(List<FlowWorkOrderVo> draftWorkOrderList) {
        if (CollUtil.isEmpty(draftWorkOrderList)) {
            return;
        }
        Set<Long> workOrderIdSet = draftWorkOrderList.stream().map(FlowWorkOrderVo::getWorkOrderId).collect(Collectors.toSet());
        Map<Long, FlowWorkOrderExt> workOrderExtMap = this.flowWorkOrderService.getFlowWorkOrderExtByWorkOrderIds(workOrderIdSet).stream().collect(Collectors.toMap(FlowWorkOrderExt::getWorkOrderId, c -> c));
        for (FlowWorkOrderVo workOrder : draftWorkOrderList) {
            Object model;
            FlowWorkOrderExt workOrderExt = workOrderExtMap.get(workOrder.getWorkOrderId());
            if (workOrderExt == null) continue;
            JSONObject draftData = JSON.parseObject((String)workOrderExt.getDraftData());
            JSONObject masterData = draftData.getJSONObject("masterData");
            JSONObject slaveData = draftData.getJSONObject("slaveData");
            if (masterData != null) {
                model = masterData.toJavaObject(this.modelClass);
                super.buildRelationForData(model, MyRelationParam.dictOnly());
            } else {
                model = ReflectUtil.newInstance((Class)this.modelClass, (Object[])new Object[0]);
            }
            this.bindLocalOneToOneSlaveData(model, slaveData);
            super.buildLocalOneToOneDictOnly(model);
            workOrder.setMasterData(BeanUtil.beanToMap((Object)model, (String[])new String[0]));
        }
    }

    public void syncBusinessData(FlowWorkOrder workOrder) {
    }

    public void updateFlowStatus(FlowWorkOrder workOrder) {
        if (this.flowStatusField == null && this.flowLatestApprovalStatusField == null) {
            return;
        }
        Serializable id = this.convertToKeyValue(workOrder.getBusinessKey());
        Object data = this.getById(id);
        if (data == null) {
            String msg = StrFormatter.format((String)"WorkOrderId [{}] don't find business data by key [{}] while calling [updateFlowStatus].", (Object[])new Object[]{workOrder.getWorkOrderId(), workOrder.getBusinessKey()});
            log.warn(msg);
            return;
        }
        if (this.flowStatusField != null) {
            ReflectUtil.setFieldValue((Object)data, (Field)this.flowStatusField, (Object)workOrder.getFlowStatus());
        }
        if (this.flowLatestApprovalStatusField != null) {
            ReflectUtil.setFieldValue((Object)data, (Field)this.flowLatestApprovalStatusField, (Object)workOrder.getLatestApprovalStatus());
        }
        this.mapper().updateById(data);
    }

    public void removeByWorkOrder(FlowWorkOrder workOrder) {
        Serializable id = this.convertToKeyValue(workOrder.getBusinessKey());
        Object data = this.getById(id);
        if (data == null) {
            String msg = StrFormatter.format((String)"WorkOrderId [{}] don't find business data by key [{}] while calling [removeByWorkOrder].", (Object[])new Object[]{workOrder.getWorkOrderId(), workOrder.getBusinessKey()});
            log.warn(msg);
            return;
        }
        this.remove(id);
    }

    public String getBusinessData(String processInstanceId, String businessKey) {
        Serializable id = this.convertToKeyValue(businessKey);
        Object data = this.getByIdWithRelation(id, MyRelationParam.full());
        return JSON.toJSONStringWithDateFormat((Object)data, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
    }

    public String getNormalizedDraftData(String processInstanceId, JSONObject masterData, JSONObject slaveData) {
        if (slaveData != null) {
            throw new UnsupportedOperationException("Please implement getNormalizedDraftData by self, because draft data includes related slaveData");
        }
        if (masterData == null) {
            return JSON.toJSONString((Object)ReflectUtil.newInstance((Class)this.modelClass, (Object[])new Object[0]));
        }
        Object model = BeanUtil.toBean((Object)masterData, (Class)this.modelClass);
        HashSet cachedDownableFilename = new HashSet(MyModelUtil.extractDownloadFileName((Object)model, (Class)this.modelClass));
        this.cacheHelper.putSessionDownloadableFileNameSet(cachedDownableFilename);
        return JSON.toJSONStringWithDateFormat((Object)model, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
    }

    private Serializable convertToKeyValue(String businessKey) {
        if (this.idFieldClass.equals(String.class)) {
            return businessKey;
        }
        if (this.idFieldClass.equals(Long.class)) {
            return Long.valueOf(businessKey);
        }
        if (this.idFieldClass.equals(Integer.class)) {
            return Integer.valueOf(businessKey);
        }
        throw new MyRuntimeException("Unsupported Primary Key Field Type.");
    }

    private void bindLocalOneToOneSlaveData(M model, JSONObject slaveData) {
        if (slaveData == null) {
            return;
        }
        for (BaseService.RelationStruct relationStruct : this.localRelationOneToOneStructList) {
            Field relationField = relationStruct.getRelationField();
            JSONObject slaveObject = slaveData.getJSONObject(relationField.getName());
            if (slaveObject == null) continue;
            ReflectUtil.setFieldValue(model, (Field)relationField, (Object)slaveObject.toJavaObject(relationStruct.getRelationOneToOne().slaveModelClass()));
        }
    }
}

