/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.cmd;

import cn.hutool.core.util.StrUtil;
import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityManager;

public class AddSequenceMultiInstanceCmd
implements Command<List<String>> {
    private String originalAssignees;
    private String taskId;
    private List<String> newAssignees;
    private boolean before;

    public List<String> execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        TaskEntityManager taskEntityManager = processEngineConfiguration.getTaskServiceConfiguration().getTaskEntityManager();
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        TaskEntity taskEntity = (TaskEntity)taskEntityManager.findById(this.taskId);
        ExecutionEntity currentExecutionEntity = (ExecutionEntity)executionEntityManager.findById(taskEntity.getExecutionId());
        ExecutionEntity multiExecutionEntity = this.searchForMultiInstanceActivity(taskEntity, executionEntityManager);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)multiExecutionEntity.getProcessDefinitionId());
        Activity miActivityElement = (Activity)bpmnModel.getFlowElement(multiExecutionEntity.getCurrentActivityId());
        MultiInstanceLoopCharacteristics loopCharacteristics = miActivityElement.getLoopCharacteristics();
        if (loopCharacteristics == null) {
            throw new FlowableException("\u6b64\u8282\u70b9\u4e0d\u662f\u591a\u5b9e\u4f8b\u8282\u70b9");
        }
        if (!loopCharacteristics.isSequential()) {
            throw new FlowableException("\u6b64\u8282\u70b9\u4e3a\u4e32\u884c\u8282\u70b9");
        }
        RuntimeService runtimeService = processEngineConfiguration.getRuntimeService();
        List collectionUsers = StrUtil.split((CharSequence)this.originalAssignees, (CharSequence)",");
        Integer loopCounter = (Integer)currentExecutionEntity.getVariableLocal("loopCounter", Integer.class);
        if (this.before) {
            collectionUsers.addAll(loopCounter, this.newAssignees);
            runtimeService.setVariable(taskEntity.getProcessInstanceId(), "assigneeList", (Object)collectionUsers);
            TaskHelper.changeTaskAssignee((TaskEntity)taskEntity, (String)this.newAssignees.get(0));
        } else {
            collectionUsers.addAll(loopCounter + 1, this.newAssignees);
            runtimeService.setVariable(taskEntity.getProcessInstanceId(), "assigneeList", (Object)collectionUsers);
        }
        Integer nrOfInstances = (Integer)multiExecutionEntity.getVariableLocal("nrOfInstances");
        multiExecutionEntity.setVariableLocal("nrOfInstances", (Object)(nrOfInstances + this.newAssignees.size()));
        return collectionUsers;
    }

    protected ExecutionEntity searchForMultiInstanceActivity(TaskEntity taskEntity, ExecutionEntityManager executionEntityManager) {
        ExecutionEntity miExecution = null;
        ExecutionEntity taskExecution = (ExecutionEntity)executionEntityManager.findById(taskEntity.getExecutionId());
        ExecutionEntity parentExecution = (ExecutionEntity)executionEntityManager.findById(taskExecution.getParentId());
        if (taskEntity.getTaskDefinitionKey().equals(parentExecution.getActivityId()) && parentExecution.isMultiInstanceRoot()) {
            miExecution = parentExecution;
        }
        if (miExecution == null) {
            throw new FlowableException("Multiple multi instance executions found for activity id " + taskEntity.getTaskDefinitionKey());
        }
        return miExecution;
    }

    public AddSequenceMultiInstanceCmd(String originalAssignees, String taskId, List<String> newAssignees, boolean before) {
        this.originalAssignees = originalAssignees;
        this.taskId = taskId;
        this.newAssignees = newAssignees;
        this.before = before;
    }
}

